/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.descriptor.java.JavaTypedExpressible;

public interface CollectionPart
extends ValuedModelPart,
Fetchable,
JavaTypedExpressible {
    public Nature getNature();

    @Override
    default public String getPartName() {
        return this.getNature().getName();
    }

    default public ModelPart getInclusionCheckPart() {
        return this;
    }

    public static enum Nature {
        ELEMENT("{element}"),
        INDEX("{index}"),
        ID("{collection-id}");

        private final String name;

        private Nature(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Nature fromNameExact(String name) {
            switch (name) {
                case "{element}": {
                    return ELEMENT;
                }
                case "{index}": {
                    return INDEX;
                }
                case "{collection-id}": {
                    return ID;
                }
            }
            return null;
        }

        public static Nature fromName(String name) {
            if ("key".equals(name) || "{key}".equals(name) || "keys".equals(name) || "{keys}".equals(name) || "index".equals(name) || "{index}".equals(name) || "indices".equals(name) || "{indices}".equals(name) || "$index$".equals(name)) {
                return INDEX;
            }
            if ("element".equals(name) || "{element}".equals(name) || "elements".equals(name) || "{elements}".equals(name) || "value".equals(name) || "{value}".equals(name) || "values".equals(name) || "{values}".equals(name) || "$element$".equals(name)) {
                return ELEMENT;
            }
            if (Nature.ID.name.equals(name)) {
                return ID;
            }
            return null;
        }
    }
}

