/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.Remove;
import org.hibernate.TransientObjectException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.cache.spi.entry.StructuredCollectionCacheEntry;
import org.hibernate.cache.spi.entry.StructuredMapCacheEntry;
import org.hibernate.cache.spi.entry.UnstructuredCacheEntry;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.internal.FetchProfileAffectee;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.ast.internal.CollectionElementLoaderByIndex;
import org.hibernate.loader.ast.internal.CollectionLoaderNamedQuery;
import org.hibernate.loader.ast.internal.CollectionLoaderSingleKey;
import org.hibernate.loader.ast.internal.CollectionLoaderSubSelectFetch;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.spi.BatchLoaderFactory;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.PluralAttributeMappingImpl;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.CompositeElementPropertyMapping;
import org.hibernate.persister.collection.DeprecatedCollectionStuff;
import org.hibernate.persister.collection.ElementPropertyMapping;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.RemoveCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.Alias;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Template;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.AliasedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.ColumnValueParameterList;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.internal.TableDeleteStandard;
import org.hibernate.sql.model.jdbc.JdbcDeleteMutation;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

@Internal
public abstract class AbstractCollectionPersister
implements CollectionPersister,
CollectionMutationTarget,
PluralAttributeMappingImpl.Aware,
FetchProfileAffectee,
DeprecatedCollectionStuff {
    private final NavigableRole navigableRole;
    private final CollectionSemantics<?, ?> collectionSemantics;
    private final EntityPersister ownerPersister;
    private final SessionFactoryImplementor factory;
    protected final String qualifiedTableName;
    private final CollectionTableMapping tableMapping;
    private final String sqlSelectSizeString;
    private final String sqlDetectRowByIndexString;
    private final String sqlDetectRowByElementString;
    protected final boolean hasWhere;
    protected final String sqlWhereString;
    private final String sqlWhereStringTemplate;
    private final boolean hasOrder;
    private final boolean hasManyToManyOrder;
    private final String mappedByProperty;
    protected final boolean indexContainsFormula;
    protected final boolean elementIsPureFormula;
    protected final String[] keyColumnNames;
    protected final String[] indexColumnNames;
    protected final String[] indexFormulaTemplates;
    protected final String[] indexFormulas;
    protected final boolean[] indexColumnIsGettable;
    protected final boolean[] indexColumnIsSettable;
    protected final String[] elementColumnNames;
    protected final String[] elementColumnWriters;
    protected final String[] elementColumnReaders;
    protected final String[] elementColumnReaderTemplates;
    protected final String[] elementFormulaTemplates;
    protected final String[] elementFormulas;
    protected final boolean[] elementColumnIsGettable;
    protected final boolean[] elementColumnIsSettable;
    protected final String identifierColumnName;
    private final String queryLoaderName;
    private final boolean isPrimitiveArray;
    private final boolean isLazy;
    private final boolean isExtraLazy;
    protected final boolean isInverse;
    private final boolean isMutable;
    private final boolean isVersioned;
    protected final int batchSize;
    private final FetchMode fetchMode;
    private final boolean hasOrphanDelete;
    private final boolean subselectLoadable;
    private final Class<?> elementClass;
    private final Dialect dialect;
    protected final SqlExceptionHelper sqlExceptionHelper;
    private final BeforeExecutionGenerator identifierGenerator;
    private final PropertyMapping elementPropertyMapping;
    private final EntityPersister elementPersister;
    private final CollectionDataAccess cacheAccessStrategy;
    private final CacheEntryStructure cacheEntryStructure;
    private final FilterHelper filterHelper;
    private final FilterHelper manyToManyFilterHelper;
    private final String manyToManyWhereString;
    private final String manyToManyWhereTemplate;
    private final String[] spaces;
    private final Comparator<?> comparator;
    private CollectionLoader collectionLoader;
    private CollectionElementLoaderByIndex collectionElementLoaderByIndex;
    private PluralAttributeMapping attributeMapping;
    private volatile Set<String> affectingFetchProfiles;
    private String[] indexFragments;
    @Deprecated
    private final CollectionType collectionType;
    @Deprecated
    private final Type keyType;
    @Deprecated
    private final Type identifierType;
    @Deprecated
    private final Type indexType;
    @Deprecated
    protected final Type elementType;
    @Deprecated
    protected final String[] keyColumnAliases;
    @Deprecated
    private final String identifierColumnAlias;
    @Deprecated
    protected final String[] indexColumnAliases;
    @Deprecated
    protected final String[] elementColumnAliases;
    @Deprecated
    private final java.util.Map<String, String[]> collectionPropertyColumnAliases = new HashMap<String, String[]>();

    @Deprecated(since="6.0")
    public AbstractCollectionPersister(Collection collectionBootDescriptor, CollectionDataAccess cacheAccessStrategy, PersisterCreationContext creationContext) throws MappingException, CacheException {
        this(collectionBootDescriptor, cacheAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }

    public AbstractCollectionPersister(Collection collectionBootDescriptor, CollectionDataAccess cacheAccessStrategy, RuntimeModelCreationContext creationContext) throws MappingException, CacheException {
        this.factory = creationContext.getSessionFactory();
        this.collectionSemantics = creationContext.getBootstrapContext().getMetadataBuildingOptions().getPersistentCollectionRepresentationResolver().resolveRepresentation(collectionBootDescriptor);
        this.cacheAccessStrategy = cacheAccessStrategy;
        this.cacheEntryStructure = creationContext.getSessionFactoryOptions().isStructuredCacheEntriesEnabled() ? (collectionBootDescriptor.isMap() ? StructuredMapCacheEntry.INSTANCE : StructuredCollectionCacheEntry.INSTANCE) : UnstructuredCacheEntry.INSTANCE;
        this.dialect = creationContext.getDialect();
        this.sqlExceptionHelper = creationContext.getJdbcServices().getSqlExceptionHelper();
        this.collectionType = collectionBootDescriptor.getCollectionType();
        this.navigableRole = new NavigableRole(collectionBootDescriptor.getRole());
        this.ownerPersister = creationContext.getDomainModel().getEntityDescriptor(collectionBootDescriptor.getOwnerEntityName());
        this.queryLoaderName = collectionBootDescriptor.getLoaderName();
        this.isMutable = collectionBootDescriptor.isMutable();
        this.mappedByProperty = collectionBootDescriptor.getMappedByProperty();
        Value elementBootDescriptor = collectionBootDescriptor.getElement();
        Table table = collectionBootDescriptor.getCollectionTable();
        this.fetchMode = elementBootDescriptor.getFetchMode();
        this.elementType = elementBootDescriptor.getType();
        this.isPrimitiveArray = collectionBootDescriptor.isPrimitiveArray();
        this.subselectLoadable = collectionBootDescriptor.isSubselectLoadable();
        this.qualifiedTableName = this.determineTableName(table);
        int spacesSize = 1 + collectionBootDescriptor.getSynchronizedTables().size();
        this.spaces = new String[spacesSize];
        Iterator<String> tables = collectionBootDescriptor.getSynchronizedTables().iterator();
        for (int i = 1; i < spacesSize; ++i) {
            this.spaces[i] = tables.next();
        }
        if (StringHelper.isNotEmpty(collectionBootDescriptor.getWhere())) {
            this.hasWhere = true;
            this.sqlWhereString = "(" + collectionBootDescriptor.getWhere() + ")";
            this.sqlWhereStringTemplate = Template.renderWhereStringTemplate(this.sqlWhereString, this.dialect, creationContext.getTypeConfiguration(), creationContext.getFunctionRegistry());
        } else {
            this.hasWhere = false;
            this.sqlWhereString = null;
            this.sqlWhereStringTemplate = null;
        }
        this.hasOrphanDelete = collectionBootDescriptor.hasOrphanDelete();
        this.batchSize = collectionBootDescriptor.getBatchSize() < 0 ? this.factory.getSessionFactoryOptions().getDefaultBatchFetchSize() : collectionBootDescriptor.getBatchSize();
        this.isVersioned = collectionBootDescriptor.isOptimisticLocked();
        this.keyType = collectionBootDescriptor.getKey().getType();
        int keySpan = collectionBootDescriptor.getKey().getColumnSpan();
        this.keyColumnNames = new String[keySpan];
        this.keyColumnAliases = new String[keySpan];
        int k = 0;
        for (Column column : collectionBootDescriptor.getKey().getColumns()) {
            this.keyColumnNames[k] = column.getQuotedName(this.dialect);
            this.keyColumnAliases[k] = column.getAlias(this.dialect, table);
            ++k;
        }
        if (this.elementType.isEntityType()) {
            String entityName = ((EntityType)this.elementType).getAssociatedEntityName();
            this.elementPersister = creationContext.getDomainModel().getEntityDescriptor(entityName);
        } else {
            this.elementPersister = null;
        }
        this.spaces[0] = this.getTableName();
        int elementSpan = elementBootDescriptor.getColumnSpan();
        this.elementColumnAliases = new String[elementSpan];
        this.elementColumnNames = new String[elementSpan];
        this.elementColumnWriters = new String[elementSpan];
        this.elementColumnReaders = new String[elementSpan];
        this.elementColumnReaderTemplates = new String[elementSpan];
        this.elementFormulaTemplates = new String[elementSpan];
        this.elementFormulas = new String[elementSpan];
        this.elementColumnIsSettable = new boolean[elementSpan];
        this.elementColumnIsGettable = new boolean[elementSpan];
        boolean isPureFormula = true;
        boolean oneToMany = collectionBootDescriptor.isOneToMany();
        boolean[] columnInsertability = null;
        if (!oneToMany) {
            columnInsertability = elementBootDescriptor.getColumnInsertability();
        }
        int j = 0;
        for (Selectable selectable : elementBootDescriptor.getSelectables()) {
            this.elementColumnAliases[j] = selectable.getAlias(this.dialect, table);
            if (selectable.isFormula()) {
                Formula form = (Formula)selectable;
                this.elementFormulaTemplates[j] = form.getTemplate(this.dialect, creationContext.getTypeConfiguration(), creationContext.getFunctionRegistry());
                this.elementFormulas[j] = form.getFormula();
            } else {
                Column col = (Column)selectable;
                this.elementColumnNames[j] = col.getQuotedName(this.dialect);
                this.elementColumnWriters[j] = col.getWriteExpr(elementBootDescriptor.getSelectableType(this.factory, j), this.dialect);
                this.elementColumnReaders[j] = col.getReadExpr(this.dialect);
                this.elementColumnReaderTemplates[j] = col.getTemplate(this.dialect, creationContext.getTypeConfiguration(), creationContext.getFunctionRegistry());
                this.elementColumnIsGettable[j] = true;
                this.elementColumnIsSettable[j] = this.elementType.isComponentType() ? columnInsertability[j] : true;
                isPureFormula = false;
            }
            ++j;
        }
        this.elementIsPureFormula = isPureFormula;
        boolean hasIndex = collectionBootDescriptor.isIndexed();
        if (hasIndex) {
            IndexedCollection indexedCollection = (IndexedCollection)collectionBootDescriptor;
            this.indexType = indexedCollection.getIndex().getType();
            int indexSpan = indexedCollection.getIndex().getColumnSpan();
            boolean[] indexColumnInsertability = indexedCollection.getIndex().getColumnInsertability();
            boolean[] indexColumnUpdatability = indexedCollection.getIndex().getColumnUpdateability();
            this.indexColumnNames = new String[indexSpan];
            this.indexFormulaTemplates = new String[indexSpan];
            this.indexFormulas = new String[indexSpan];
            this.indexColumnIsGettable = new boolean[indexSpan];
            this.indexColumnIsSettable = new boolean[indexSpan];
            this.indexColumnAliases = new String[indexSpan];
            int i = 0;
            boolean hasFormula = false;
            for (Selectable s : indexedCollection.getIndex().getSelectables()) {
                Column indexCol;
                this.indexColumnAliases[i] = s.getAlias(this.dialect);
                if (s.isFormula()) {
                    Formula indexForm = (Formula)s;
                    this.indexFormulaTemplates[i] = indexForm.getTemplate(this.dialect, creationContext.getTypeConfiguration(), creationContext.getFunctionRegistry());
                    this.indexFormulas[i] = indexForm.getFormula();
                    hasFormula = true;
                } else if (indexedCollection instanceof Map && ((Map)indexedCollection).getMapKeyPropertyName() != null) {
                    indexCol = (Column)s;
                    this.indexFormulaTemplates[i] = "$PlaceHolder$" + indexCol.getQuotedName(this.dialect);
                    this.indexFormulas[i] = indexCol.getQuotedName(this.dialect);
                    hasFormula = true;
                } else {
                    indexCol = (Column)s;
                    this.indexColumnNames[i] = indexCol.getQuotedName(this.dialect);
                    this.indexColumnIsGettable[i] = true;
                    this.indexColumnIsSettable[i] = indexColumnInsertability[i] || indexColumnUpdatability[i];
                }
                ++i;
            }
            this.indexContainsFormula = hasFormula;
        } else {
            this.indexContainsFormula = false;
            this.indexColumnIsGettable = null;
            this.indexColumnIsSettable = null;
            this.indexFormulaTemplates = null;
            this.indexFormulas = null;
            this.indexType = null;
            this.indexColumnNames = null;
            this.indexColumnAliases = null;
        }
        boolean hasIdentifier = collectionBootDescriptor.isIdentified();
        if (hasIdentifier) {
            if (collectionBootDescriptor.isOneToMany()) {
                throw new MappingException("one-to-many collections with identifiers are not supported");
            }
            IdentifierCollection idColl = (IdentifierCollection)collectionBootDescriptor;
            this.identifierType = idColl.getIdentifier().getType();
            Column col = idColl.getIdentifier().getColumns().get(0);
            this.identifierColumnName = col.getQuotedName(this.dialect);
            this.identifierColumnAlias = col.getAlias(this.dialect);
            this.identifierGenerator = this.createGenerator(creationContext, idColl);
        } else {
            this.identifierType = null;
            this.identifierColumnName = null;
            this.identifierColumnAlias = null;
            this.identifierGenerator = null;
        }
        this.sqlSelectSizeString = this.generateSelectSizeString(collectionBootDescriptor.isIndexed() && !collectionBootDescriptor.isMap());
        this.sqlDetectRowByIndexString = this.generateDetectRowByIndexString();
        this.sqlDetectRowByElementString = this.generateDetectRowByElementString();
        this.isLazy = collectionBootDescriptor.isLazy();
        this.isExtraLazy = collectionBootDescriptor.isExtraLazy();
        this.isInverse = collectionBootDescriptor.isInverse();
        this.elementClass = collectionBootDescriptor.isArray() ? ((Array)collectionBootDescriptor).getElementClass() : null;
        this.elementPropertyMapping = this.elementType.isComponentType() ? new CompositeElementPropertyMapping(this.elementColumnNames, this.elementColumnReaders, this.elementColumnReaderTemplates, this.elementFormulaTemplates, (CompositeType)this.elementType, creationContext.getMetadata()) : (!this.elementType.isEntityType() ? new ElementPropertyMapping(this.elementColumnNames, this.elementType) : (this.elementPersister instanceof PropertyMapping ? (PropertyMapping)((Object)this.elementPersister) : new ElementPropertyMapping(this.elementColumnNames, this.elementType)));
        this.hasOrder = collectionBootDescriptor.getOrderBy() != null;
        boolean bl = this.hasManyToManyOrder = collectionBootDescriptor.getManyToManyOrdering() != null;
        if (collectionBootDescriptor.getFilters().isEmpty()) {
            this.filterHelper = null;
        } else {
            java.util.Map<String, String> entityNameByTableNameMap = this.elementPersister == null ? null : AbstractEntityPersister.getEntityNameByTableNameMap(creationContext.getBootModel().getEntityBinding(this.elementPersister.getEntityName()), this.factory.getSqlStringGenerationContext());
            this.filterHelper = new FilterHelper(collectionBootDescriptor.getFilters(), entityNameByTableNameMap, this.factory);
        }
        this.manyToManyFilterHelper = collectionBootDescriptor.getManyToManyFilters().isEmpty() ? null : new FilterHelper(collectionBootDescriptor.getManyToManyFilters(), this.factory);
        if (StringHelper.isEmpty(collectionBootDescriptor.getManyToManyWhere())) {
            this.manyToManyWhereString = null;
            this.manyToManyWhereTemplate = null;
        } else {
            this.manyToManyWhereString = "( " + collectionBootDescriptor.getManyToManyWhere() + ")";
            this.manyToManyWhereTemplate = Template.renderWhereStringTemplate(this.manyToManyWhereString, creationContext.getDialect(), creationContext.getTypeConfiguration(), creationContext.getFunctionRegistry());
        }
        this.comparator = collectionBootDescriptor.getComparator();
        this.initCollectionPropertyMap();
        if (this.hasNamedQueryLoader()) {
            this.getNamedQueryMemento(collectionBootDescriptor.getMetadata());
        }
        this.tableMapping = AbstractCollectionPersister.buildCollectionTableMapping(collectionBootDescriptor, this.getTableName(), this.getCollectionSpaces());
    }

    private BeforeExecutionGenerator createGenerator(RuntimeModelCreationContext context, IdentifierCollection collection) {
        Generator generator = collection.getIdentifier().createGenerator(context.getBootstrapContext().getIdentifierGeneratorFactory(), context.getDialect(), null);
        if (generator.generatedOnExecution()) {
            throw new MappingException("must be an BeforeExecutionGenerator");
        }
        if (generator instanceof IdentifierGenerator) {
            ((IdentifierGenerator)generator).initialize(context.getSqlStringGenerationContext());
        }
        return (BeforeExecutionGenerator)generator;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Comparator<?> getSortingComparator() {
        return this.comparator;
    }

    protected String determineTableName(Table table) {
        return MappingModelCreationHelper.getTableIdentifierExpression(table, this.factory);
    }

    @Override
    public void postInstantiate() throws MappingException {
        this.collectionLoader = this.hasNamedQueryLoader() ? this.createNamedQueryCollectionLoader(this, this.getNamedQueryMemento(null)) : this.createNamedQueryCollectionLoader(new LoadQueryInfluencers(this.factory));
        if (this.attributeMapping.getIndexDescriptor() != null) {
            this.collectionElementLoaderByIndex = new CollectionElementLoaderByIndex(this.attributeMapping, new LoadQueryInfluencers(this.factory), this.factory);
        }
        this.logStaticSQL();
    }

    private NamedQueryMemento getNamedQueryMemento(MetadataImplementor bootModel) {
        NamedQueryMemento memento = this.factory.getQueryEngine().getNamedObjectRepository().resolve(this.factory, bootModel, this.queryLoaderName);
        if (memento == null) {
            throw new IllegalArgumentException("Could not resolve named query '" + this.queryLoaderName + "' for loading collection '" + this.getName() + "'");
        }
        return memento;
    }

    protected void logStaticSQL() {
        String deleteAllSql;
        String deleteRowSql;
        String updateRowSql;
        String insertRowSql;
        if (!ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
            return;
        }
        ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Static SQL for collection: %s", (Object)this.getRole());
        if (this.getRowMutationOperations().hasInsertRow() && (insertRowSql = this.getRowMutationOperations().getInsertRowOperation().getSqlString()) != null) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf(" Row insert: %s", (Object)insertRowSql);
        }
        if (this.getRowMutationOperations().hasUpdateRow() && (updateRowSql = this.getRowMutationOperations().getUpdateRowOperation().getSqlString()) != null) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf(" Row update: %s", (Object)updateRowSql);
        }
        if (this.getRowMutationOperations().hasDeleteRow() && (deleteRowSql = this.getRowMutationOperations().getDeleteRowOperation().getSqlString()) != null) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf(" Row delete: %s", (Object)deleteRowSql);
        }
        if ((deleteAllSql = this.getRemoveCoordinator().getSqlString()) != null) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf(" One-shot delete: %s", (Object)deleteAllSql);
        }
    }

    @Override
    public void initialize(Object key, SharedSessionContractImplementor session) throws HibernateException {
        this.determineLoaderToUse(key, session).load(key, session);
    }

    private boolean hasNamedQueryLoader() {
        return this.queryLoaderName != null;
    }

    public CollectionLoader getCollectionLoader() {
        return this.collectionLoader;
    }

    protected CollectionLoader determineLoaderToUse(Object key, SharedSessionContractImplementor session) {
        CollectionLoader subSelectLoader;
        if (this.hasNamedQueryLoader()) {
            return this.getCollectionLoader();
        }
        LoadQueryInfluencers influencers = session.getLoadQueryInfluencers();
        if (influencers.effectiveSubselectFetchEnabled(this) && (subSelectLoader = this.resolveSubSelectLoader(key, session)) != null) {
            return subSelectLoader;
        }
        return this.attributeMapping.isAffectedByInfluencers(influencers) ? this.createNamedQueryCollectionLoader(influencers) : this.getCollectionLoader();
    }

    private CollectionLoader resolveSubSelectLoader(Object key, SharedSessionContractImplementor session) {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        SubselectFetch subselect = persistenceContext.getBatchFetchQueue().getSubselect(session.generateEntityKey(key, this.getOwnerEntityPersister()));
        if (subselect == null) {
            return null;
        }
        subselect.getResultingEntityKeys().removeIf(entityKey -> !persistenceContext.containsEntity((EntityKey)entityKey));
        return this.createSubSelectLoader(subselect, session);
    }

    protected CollectionLoader createSubSelectLoader(SubselectFetch subselect, SharedSessionContractImplementor session) {
        return new CollectionLoaderSubSelectFetch(this.attributeMapping, null, subselect, session);
    }

    private CollectionLoader createNamedQueryCollectionLoader(LoadQueryInfluencers loadQueryInfluencers) {
        if (loadQueryInfluencers.effectivelyBatchLoadable(this)) {
            int batchSize = loadQueryInfluencers.effectiveBatchSize(this);
            return this.factory.getServiceRegistry().getService(BatchLoaderFactory.class).createCollectionBatchLoader(batchSize, loadQueryInfluencers, this.attributeMapping, this.factory);
        }
        return this.createSingleKeyCollectionLoader(loadQueryInfluencers);
    }

    protected CollectionLoader createNamedQueryCollectionLoader(CollectionPersister persister, NamedQueryMemento namedQueryMemento) {
        return new CollectionLoaderNamedQuery(persister, namedQueryMemento);
    }

    protected CollectionLoader createSingleKeyCollectionLoader(LoadQueryInfluencers loadQueryInfluencers) {
        return new CollectionLoaderSingleKey(this.attributeMapping, loadQueryInfluencers, this.factory);
    }

    @Override
    public CollectionDataAccess getCacheAccessStrategy() {
        return this.cacheAccessStrategy;
    }

    @Override
    public boolean hasCache() {
        return this.cacheAccessStrategy != null;
    }

    protected abstract RowMutationOperations getRowMutationOperations();

    protected abstract RemoveCoordinator getRemoveCoordinator();

    @Override
    public String getSQLOrderByString(String alias) {
        if (this.hasOrdering()) {
            throw new UnsupportedOperationException();
        }
        return "";
    }

    @Override
    public String getManyToManyOrderByString(String alias) {
        if (this.hasManyToManyOrdering()) {
            throw new UnsupportedOperationException();
        }
        return "";
    }

    @Override
    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public boolean hasOrdering() {
        return this.hasOrder;
    }

    @Override
    public boolean hasManyToManyOrdering() {
        return this.isManyToMany() && this.hasManyToManyOrder;
    }

    @Override
    public boolean hasWhere() {
        return this.hasWhere;
    }

    @Override
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Deprecated(forRemoval=true)
    @Remove
    protected Object decrementIndexByBase(Object index) {
        int baseIndex = this.attributeMapping.getIndexMetadata().getListIndexBase();
        if (baseIndex > 0) {
            index = (Integer)index - baseIndex;
        }
        return index;
    }

    protected Object incrementIndexByBase(Object index) {
        int baseIndex = this.attributeMapping.getIndexMetadata().getListIndexBase();
        if (baseIndex > 0) {
            index = (Integer)index + baseIndex;
        }
        return index;
    }

    @Override
    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    @Override
    public boolean isArray() {
        return this.collectionSemantics.getCollectionClassification() == CollectionClassification.ARRAY;
    }

    @Override
    public String getIdentifierColumnName() {
        if (this.collectionSemantics.getCollectionClassification() == CollectionClassification.ID_BAG) {
            return this.identifierColumnName;
        }
        return null;
    }

    @Override
    public String selectFragment(String alias, String columnSuffix) {
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), LockOptions.NONE, (fetchParent, creationState) -> ImmutableFetchList.EMPTY, true, new LoadQueryInfluencers(this.factory), this.factory);
        NavigablePath entityPath = new NavigablePath(attributeMapping.getRootPathName());
        TableGroup rootTableGroup = attributeMapping.createRootTableGroup(true, entityPath, null, new SqlAliasBaseConstant(alias), () -> p -> {}, sqlAstCreationState);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        attributeMapping.createDomainResult(entityPath, rootTableGroup, null, sqlAstCreationState);
        SelectClause selectClause = rootQuerySpec.getSelectClause();
        List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        int i = 0;
        for (String keyAlias : this.keyColumnAliases) {
            sqlSelections.set(i, new SqlSelectionImpl(i, new AliasedExpression(sqlSelections.get(i).getExpression(), keyAlias + columnSuffix)));
            ++i;
        }
        if (this.hasIndex()) {
            for (String indexAlias : this.indexColumnAliases) {
                sqlSelections.set(i, new SqlSelectionImpl(i, new AliasedExpression(sqlSelections.get(i).getExpression(), indexAlias + columnSuffix)));
                ++i;
            }
        }
        if (this.collectionSemantics.getCollectionClassification() == CollectionClassification.ID_BAG) {
            sqlSelections.set(i, new SqlSelectionImpl(i, new AliasedExpression(sqlSelections.get(i).getExpression(), this.identifierColumnAlias + columnSuffix)));
            ++i;
        }
        int columnIndex = 0;
        while (i < sqlSelections.size()) {
            SqlSelection sqlSelection = sqlSelections.get(i);
            sqlSelections.set(i, new SqlSelectionImpl(sqlSelection.getValuesArrayPosition(), new AliasedExpression(sqlSelection.getExpression(), this.elementColumnAliases[columnIndex] + columnSuffix)));
            ++i;
            ++columnIndex;
        }
        String sql = this.getFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildSelectTranslator(this.getFactory(), new SelectStatement(rootQuerySpec)).translate(null, QueryOptions.NONE).getSqlString();
        int fromIndex = sql.lastIndexOf(" from");
        String expression = fromIndex != -1 ? sql.substring("select ".length(), fromIndex) : sql.substring("select ".length());
        return expression;
    }

    protected String generateSelectSizeString(boolean isIntegerIndexed) {
        String selectValue = isIntegerIndexed ? "max(" + this.getIndexColumnNames()[0] + ") + 1" : "count(" + this.getElementColumnNames()[0] + ")";
        return new SimpleSelect(this.getFactory()).setTableName(this.getTableName()).addRestriction(this.getKeyColumnNames()).addWhereToken(this.sqlWhereString).addColumn(selectValue).toStatementString();
    }

    protected String generateDetectRowByIndexString() {
        if (!this.hasIndex()) {
            return null;
        }
        return new SimpleSelect(this.getFactory()).setTableName(this.getTableName()).addRestriction(this.getKeyColumnNames()).addRestriction(this.getIndexColumnNames()).addRestriction(this.indexFormulas).addWhereToken(this.sqlWhereString).addColumn("1").toStatementString();
    }

    protected String generateDetectRowByElementString() {
        return new SimpleSelect(this.getFactory()).setTableName(this.getTableName()).addRestriction(this.getKeyColumnNames()).addRestriction(this.getElementColumnNames()).addRestriction(this.elementFormulas).addWhereToken(this.sqlWhereString).addColumn("1").toStatementString();
    }

    @Override
    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    @Override
    public String[] getIndexFormulas() {
        return this.indexFormulas;
    }

    @Override
    public String[] getIndexColumnNames(String alias) {
        return AbstractCollectionPersister.qualify(alias, this.indexColumnNames, this.indexFormulaTemplates);
    }

    @Override
    public String[] getElementColumnNames(String alias) {
        return AbstractCollectionPersister.qualify(alias, this.elementColumnNames, this.elementFormulaTemplates);
    }

    private static String[] qualify(String alias, String[] columnNames, String[] formulaTemplates) {
        int span = columnNames.length;
        String[] result = new String[span];
        for (int i = 0; i < span; ++i) {
            result[i] = columnNames[i] == null ? StringHelper.replace(formulaTemplates[i], "$PlaceHolder$", alias) : StringHelper.qualify(alias, columnNames[i]);
        }
        return result;
    }

    @Override
    public String[] getElementColumnNames() {
        return this.elementColumnNames;
    }

    @Override
    public String[] getKeyColumnNames() {
        return this.keyColumnNames;
    }

    @Override
    public boolean hasIndex() {
        return this.collectionSemantics.getCollectionClassification().isIndexed();
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isInverse() {
        return this.isInverse;
    }

    @Override
    public String getTableName() {
        return this.qualifiedTableName;
    }

    @Override
    public void remove(Object id, SharedSessionContractImplementor session) throws HibernateException {
        this.getRemoveCoordinator().deleteAllRows(id, session);
    }

    protected boolean isRowDeleteEnabled() {
        return true;
    }

    @Override
    public boolean needsRemove() {
        return !this.isInverse() && this.isRowDeleteEnabled();
    }

    protected boolean isRowInsertEnabled() {
        return true;
    }

    public String getOwnerEntityName() {
        return this.ownerPersister.getEntityName();
    }

    @Override
    public EntityPersister getOwnerEntityPersister() {
        return this.ownerPersister;
    }

    @Override
    @Deprecated
    public IdentifierGenerator getIdentifierGenerator() {
        return (IdentifierGenerator)this.identifierGenerator;
    }

    @Override
    public BeforeExecutionGenerator getGenerator() {
        return this.identifierGenerator;
    }

    @Override
    public boolean hasOrphanDelete() {
        return this.hasOrphanDelete;
    }

    @Override
    public Type toType(String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            return this.indexType;
        }
        return this.elementPropertyMapping.toType(propertyName);
    }

    @Override
    public void applyBaseRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, java.util.Map<String, Filter> enabledFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        this.applyFilterRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, creationState);
        this.applyWhereRestrictions(predicateConsumer, tableGroup, useQualifier, creationState);
    }

    @Override
    public boolean hasWhereRestrictions() {
        return this.hasWhere() || this.manyToManyWhereTemplate != null;
    }

    @Override
    public void applyWhereRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, SqlAstCreationState creationState) {
        TableReference tableReference = this.isManyToMany() ? tableGroup.getPrimaryTableReference() : (this.elementPersister instanceof Joinable ? tableGroup.getTableReference(tableGroup.getNavigablePath(), ((Joinable)((Object)this.elementPersister)).getTableName()) : tableGroup.getTableReference(tableGroup.getNavigablePath(), this.qualifiedTableName));
        String alias = tableReference == null ? null : (useQualifier && tableReference.getIdentificationVariable() != null ? tableReference.getIdentificationVariable() : tableReference.getTableId());
        this.applyWhereFragments(predicateConsumer, alias, tableGroup, creationState);
    }

    protected void applyWhereFragments(Consumer<Predicate> predicateConsumer, String alias, TableGroup tableGroup, SqlAstCreationState astCreationState) {
        AbstractCollectionPersister.applyWhereFragments(predicateConsumer, alias, this.sqlWhereStringTemplate);
    }

    private static void applyWhereFragments(Consumer<Predicate> predicateConsumer, String alias, String template) {
        if (template == null) {
            return;
        }
        String fragment = StringHelper.replace(template, "$PlaceHolder$", alias);
        if (StringHelper.isEmpty(fragment)) {
            return;
        }
        predicateConsumer.accept(new SqlFragmentPredicate(fragment));
    }

    @Override
    public void applyFilterRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, java.util.Map<String, Filter> enabledFilters, SqlAstCreationState creationState) {
        if (this.filterHelper != null) {
            this.filterHelper.applyEnabledFilters(predicateConsumer, this.getFilterAliasGenerator(tableGroup), enabledFilters, tableGroup, creationState);
        }
    }

    @Override
    public abstract boolean isManyToMany();

    @Override
    public void applyBaseManyToManyRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, java.util.Map<String, Filter> enabledFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        if (this.manyToManyFilterHelper == null && this.manyToManyWhereTemplate == null) {
            return;
        }
        if (this.manyToManyFilterHelper != null) {
            FilterAliasGenerator aliasGenerator = this.elementPersister.getFilterAliasGenerator(tableGroup);
            this.manyToManyFilterHelper.applyEnabledFilters(predicateConsumer, aliasGenerator, enabledFilters, tableGroup, creationState);
        }
        if (this.manyToManyWhereString != null) {
            TableReference tableReference = tableGroup.resolveTableReference(((Joinable)((Object)this.elementPersister)).getTableName());
            String alias = tableReference == null ? null : (useQualifier && tableReference.getIdentificationVariable() != null ? tableReference.getIdentificationVariable() : tableReference.getTableId());
            AbstractCollectionPersister.applyWhereFragments(predicateConsumer, alias, this.manyToManyWhereTemplate);
        }
    }

    @Override
    public String getManyToManyFilterFragment(TableGroup tableGroup, java.util.Map<String, Filter> enabledFilters) {
        StringBuilder fragment = new StringBuilder();
        if (this.manyToManyFilterHelper != null) {
            this.manyToManyFilterHelper.render(fragment, this.elementPersister.getFilterAliasGenerator(tableGroup), enabledFilters);
        }
        if (this.manyToManyWhereString != null) {
            if (fragment.length() > 0) {
                fragment.append(" and ");
            }
            assert (this.elementPersister instanceof Joinable);
            TableReference tableReference = tableGroup.resolveTableReference(((Joinable)((Object)this.elementPersister)).getTableName());
            fragment.append(StringHelper.replace(this.manyToManyWhereTemplate, "$PlaceHolder$", tableReference.getIdentificationVariable()));
        }
        return fragment.toString();
    }

    @Override
    public String[] toColumns(String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            if (this.indexFragments == null) {
                String[] tmp = new String[this.indexColumnNames.length];
                for (int i = 0; i < this.indexColumnNames.length; ++i) {
                    tmp[i] = this.indexColumnNames[i] == null ? this.indexFormulas[i] : this.indexColumnNames[i];
                    this.indexFragments = tmp;
                }
            }
            return this.indexFragments;
        }
        return this.elementPropertyMapping.toColumns(propertyName);
    }

    @Override
    public String getName() {
        return this.getRole();
    }

    @Override
    public EntityPersister getElementPersister() {
        if (this.elementPersister == null) {
            throw new AssertionFailure("not an association");
        }
        return this.elementPersister;
    }

    protected EntityPersister getElementPersisterInternal() {
        return this.elementPersister;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public String[] getCollectionSpaces() {
        return this.spaces;
    }

    @Override
    public void processQueuedOps(PersistentCollection<?> collection, Object key, SharedSessionContractImplementor session) {
        if (collection.hasQueuedOperations()) {
            this.doProcessQueuedOps(collection, key, session);
        }
    }

    protected abstract void doProcessQueuedOps(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3) throws HibernateException;

    @Override
    @Deprecated
    public CollectionMetadata getCollectionMetadata() {
        return this;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + "(" + this.navigableRole.getFullPath() + ")";
    }

    @Override
    public boolean isVersioned() {
        return this.isVersioned && this.getOwnerEntityPersister().isVersioned();
    }

    protected SqlExceptionHelper getSQLExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    @Override
    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    @Override
    public boolean isAffectedByEnabledFilters(SharedSessionContractImplementor session) {
        return this.isAffectedByEnabledFilters(session.getLoadQueryInfluencers());
    }

    @Override
    public boolean isSubselectLoadable() {
        return this.subselectLoadable;
    }

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public String[] getCollectionPropertyColumnAliases(String propertyName, String suffix) {
        String[] rawAliases = this.collectionPropertyColumnAliases.get(propertyName);
        if (rawAliases == null) {
            return null;
        }
        String[] result = new String[rawAliases.length];
        Alias alias = new Alias(suffix);
        for (int i = 0; i < rawAliases.length; ++i) {
            result[i] = alias.toUnquotedAliasString(rawAliases[i]);
        }
        return result;
    }

    public void initCollectionPropertyMap() {
        this.initCollectionPropertyMap("key", this.keyType, this.keyColumnAliases);
        this.initCollectionPropertyMap("element", this.elementType, this.elementColumnAliases);
        if (this.hasIndex()) {
            this.initCollectionPropertyMap("index", this.indexType, this.indexColumnAliases);
        }
        if (this.collectionSemantics.getCollectionClassification() == CollectionClassification.ID_BAG) {
            this.initCollectionPropertyMap("id", this.identifierType, new String[]{this.identifierColumnAlias});
        }
    }

    private void initCollectionPropertyMap(String aliasName, Type type, String[] columnAliases) {
        this.collectionPropertyColumnAliases.put(aliasName, columnAliases);
        if (type.isComponentType()) {
            CompositeType ct = (CompositeType)type;
            String[] propertyNames = ct.getPropertyNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                String name = propertyNames[i];
                this.collectionPropertyColumnAliases.put(aliasName + "." + name, new String[]{columnAliases[i]});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSize(Object key, SharedSessionContractImplementor session) {
        try {
            JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
            PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(this.sqlSelectSizeString);
            try {
                this.getKeyType().nullSafeSet(st, key, 1, session);
                ResultSet rs = jdbcCoordinator.getResultSetReturn().extract(st, this.sqlSelectSizeString);
                try {
                    int baseIndex = Math.max(this.attributeMapping.getIndexMetadata().getListIndexBase(), 0);
                    int n = rs.next() ? rs.getInt(1) - baseIndex : 0;
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    return n;
                }
                catch (Throwable throwable) {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    throw throwable;
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw this.getSQLExceptionHelper().convert(sqle, "could not retrieve collection size: " + MessageHelper.collectionInfoString((CollectionPersister)this, key, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    @Override
    public boolean indexExists(Object key, Object index, SharedSessionContractImplementor session) {
        return this.exists(key, this.incrementIndexByBase(index), this.getIndexType(), this.sqlDetectRowByIndexString, session);
    }

    @Override
    public boolean elementExists(Object key, Object element, SharedSessionContractImplementor session) {
        return this.exists(key, element, this.getElementType(), this.sqlDetectRowByElementString, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(Object key, Object indexOrElement, Type indexOrElementType, String sql, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(sql);
        this.getKeyType().nullSafeSet(st, key, 1, session);
        indexOrElementType.nullSafeSet(st, indexOrElement, this.keyColumnNames.length + 1, session);
        ResultSet rs = jdbcCoordinator.getResultSetReturn().extract(st, sql);
        try {
            boolean bl = rs.next();
            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
            jdbcCoordinator.afterStatementExecution();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    throw throwable;
                }
                catch (TransientObjectException e) {
                    boolean bl = false;
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                    jdbcCoordinator.afterStatementExecution();
                    return bl;
                }
            }
            catch (Throwable throwable2) {
                try {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                    jdbcCoordinator.afterStatementExecution();
                    throw throwable2;
                }
                catch (SQLException sqle) {
                    throw this.getSQLExceptionHelper().convert(sqle, "could not check row existence: " + MessageHelper.collectionInfoString((CollectionPersister)this, key, this.getFactory()), this.sqlSelectSizeString);
                }
            }
        }
    }

    @Override
    public Object getElementByIndex(Object key, Object index, SharedSessionContractImplementor session, Object owner) {
        return this.collectionElementLoaderByIndex.load(key, index, session);
    }

    @Override
    public boolean isExtraLazy() {
        return this.isExtraLazy;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public boolean isBatchLoadable() {
        return this.batchSize > 1;
    }

    @Override
    public String getMappedByProperty() {
        return this.mappedByProperty;
    }

    public abstract FilterAliasGenerator getFilterAliasGenerator(String var1);

    public abstract FilterAliasGenerator getFilterAliasGenerator(TableGroup var1);

    @Override
    public void injectAttributeMapping(PluralAttributeMapping attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    @Override
    public PluralAttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    @Override
    public void registerAffectingFetchProfile(String fetchProfileName) {
        if (this.affectingFetchProfiles == null) {
            this.affectingFetchProfiles = new HashSet<String>();
        }
        this.affectingFetchProfiles.add(fetchProfileName);
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        if (this.affectingFetchProfiles != null && influencers.hasEnabledFetchProfiles()) {
            for (String profileName : this.affectingFetchProfiles) {
                if (!influencers.isFetchProfileEnabled(profileName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        if (influencers.hasEnabledFilters()) {
            java.util.Map<String, Filter> enabledFilters = influencers.getEnabledFilters();
            return this.filterHelper != null && this.filterHelper.isAffectedBy(enabledFilters) || this.manyToManyFilterHelper != null && this.manyToManyFilterHelper.isAffectedBy(enabledFilters);
        }
        return false;
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return false;
    }

    @Override
    public CollectionSemantics<?, ?> getCollectionSemantics() {
        return this.collectionSemantics;
    }

    @Override
    public PluralAttributeMapping getTargetPart() {
        return this.attributeMapping;
    }

    @Override
    public String getIdentifierTableName() {
        return this.tableMapping.getTableName();
    }

    @Override
    public CollectionTableMapping getCollectionTableMapping() {
        return this.tableMapping;
    }

    @Override
    public boolean hasPhysicalIndexColumn() {
        return this.hasIndex() && !this.indexContainsFormula;
    }

    @Override
    public void forEachMutableTable(Consumer<CollectionTableMapping> consumer) {
        consumer.accept(this.tableMapping);
    }

    @Override
    public void forEachMutableTableReverse(Consumer<CollectionTableMapping> consumer) {
        consumer.accept(this.tableMapping);
    }

    private static CollectionTableMapping buildCollectionTableMapping(Collection collectionBootDescriptor, String qualifiedTableName, String[] spaces) {
        return new CollectionTableMapping(qualifiedTableName, spaces, !collectionBootDescriptor.isOneToMany(), collectionBootDescriptor.isInverse(), new TableMapping.MutationDetails(MutationType.INSERT, AbstractCollectionPersister.determineExpectation(collectionBootDescriptor.getCustomSQLInsertCheckStyle(), collectionBootDescriptor.getCustomSQLInsert(), collectionBootDescriptor.isCustomInsertCallable()), collectionBootDescriptor.getCustomSQLInsert(), collectionBootDescriptor.isCustomInsertCallable()), new TableMapping.MutationDetails(MutationType.UPDATE, AbstractCollectionPersister.determineExpectation(collectionBootDescriptor.getCustomSQLUpdateCheckStyle(), collectionBootDescriptor.getCustomSQLUpdate(), collectionBootDescriptor.isCustomUpdateCallable()), collectionBootDescriptor.getCustomSQLUpdate(), collectionBootDescriptor.isCustomUpdateCallable()), collectionBootDescriptor.getKey().isCascadeDeleteEnabled(), new TableMapping.MutationDetails(MutationType.DELETE, AbstractCollectionPersister.determineExpectation(collectionBootDescriptor.getCustomSQLDeleteAllCheckStyle(), collectionBootDescriptor.getCustomSQLDeleteAll(), collectionBootDescriptor.isCustomDeleteAllCallable(), Expectations.NONE), collectionBootDescriptor.getCustomSQLDeleteAll(), collectionBootDescriptor.isCustomDeleteAllCallable()), new TableMapping.MutationDetails(MutationType.DELETE, AbstractCollectionPersister.determineExpectation(collectionBootDescriptor.getCustomSQLDeleteCheckStyle(), collectionBootDescriptor.getCustomSQLDelete(), collectionBootDescriptor.isCustomDeleteCallable()), collectionBootDescriptor.getCustomSQLDelete(), collectionBootDescriptor.isCustomDeleteCallable()));
    }

    private static Expectation determineExpectation(ExecuteUpdateResultCheckStyle explicitStyle, String customSql, boolean customSqlCallable, Expectation fallback) {
        if (explicitStyle != null) {
            return Expectations.appropriateExpectation(explicitStyle);
        }
        if (customSql == null) {
            return fallback;
        }
        return Expectations.appropriateExpectation(ExecuteUpdateResultCheckStyle.determineDefault(customSql, customSqlCallable));
    }

    private static Expectation determineExpectation(ExecuteUpdateResultCheckStyle explicitStyle, String customSql, boolean customSqlCallable) {
        return AbstractCollectionPersister.determineExpectation(explicitStyle, customSql, customSqlCallable, Expectations.BASIC);
    }

    protected JdbcMutationOperation buildDeleteAllOperation(MutatingTableReference tableReference) {
        if (this.tableMapping.getDeleteDetails().getCustomSql() != null) {
            return this.buildCustomSqlDeleteAllOperation(tableReference);
        }
        return this.buildGeneratedDeleteAllOperation(tableReference);
    }

    private JdbcDeleteMutation buildCustomSqlDeleteAllOperation(MutatingTableReference tableReference) {
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        ForeignKeyDescriptor keyDescriptor = attributeMapping.getKeyDescriptor();
        ColumnValueParameterList parameterBinders = new ColumnValueParameterList(tableReference, ParameterUsage.RESTRICT, keyDescriptor.getJdbcTypeCount());
        keyDescriptor.getKeyPart().forEachSelectable(parameterBinders);
        TableMapping tableMapping = tableReference.getTableMapping();
        return new JdbcDeleteMutation(tableMapping, this, tableMapping.getDeleteDetails().getCustomSql(), tableMapping.getDeleteDetails().isCallable(), tableMapping.getDeleteDetails().getExpectation(), parameterBinders);
    }

    private JdbcMutationOperation buildGeneratedDeleteAllOperation(MutatingTableReference tableReference) {
        RestrictedTableMutation<JdbcMutationOperation> sqlAst = this.generateDeleteAllAst(tableReference);
        SqlAstTranslator<JdbcMutationOperation> translator = this.getFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildModelMutationTranslator(sqlAst, this.getFactory());
        return translator.translate(null, MutationQueryOptions.INSTANCE);
    }

    public RestrictedTableMutation<JdbcMutationOperation> generateDeleteAllAst(MutatingTableReference tableReference) {
        assert (this.getAttributeMapping() != null);
        ForeignKeyDescriptor fkDescriptor = this.getAttributeMapping().getKeyDescriptor();
        assert (fkDescriptor != null);
        int keyColumnCount = fkDescriptor.getJdbcTypeCount();
        ColumnValueParameterList parameterBinders = new ColumnValueParameterList(tableReference, ParameterUsage.RESTRICT, keyColumnCount);
        ArrayList<ColumnValueBinding> restrictionBindings = CollectionHelper.arrayList(keyColumnCount);
        this.applyKeyRestrictions(tableReference, parameterBinders, restrictionBindings);
        return new TableDeleteStandard(tableReference, this, "one-shot delete for " + this.getRolePath(), restrictionBindings, Collections.emptyList(), parameterBinders, this.sqlWhereString);
    }

    protected void applyKeyRestrictions(MutatingTableReference tableReference, ColumnValueParameterList parameterList, List<ColumnValueBinding> restrictionBindings) {
        ForeignKeyDescriptor fkDescriptor = this.getAttributeMapping().getKeyDescriptor();
        assert (fkDescriptor != null);
        int keyColumnCount = fkDescriptor.getJdbcTypeCount();
        fkDescriptor.getKeyPart().forEachSelectable(parameterList);
        for (ColumnValueParameter columnValueParameter : parameterList) {
            ColumnReference columnReference = columnValueParameter.getColumnReference();
            restrictionBindings.add(new ColumnValueBinding(columnReference, new ColumnWriteFragment("?", columnValueParameter, columnReference.getJdbcMapping())));
        }
    }

    @Override
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Override
    public Type getKeyType() {
        return this.keyType;
    }

    @Override
    public Type getIdentifierType() {
        return this.identifierType;
    }

    @Override
    public Type getIndexType() {
        return this.indexType;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public String[] getKeyColumnAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.keyColumnAliases);
    }

    @Override
    public String[] getElementColumnAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.elementColumnAliases);
    }

    @Override
    public String[] getIndexColumnAliases(String suffix) {
        if (this.hasIndex()) {
            return new Alias(suffix).toAliasStrings(this.indexColumnAliases);
        }
        return null;
    }

    @Override
    public String getIdentifierColumnAlias(String suffix) {
        if (this.collectionSemantics.getCollectionClassification() == CollectionClassification.ID_BAG) {
            return new Alias(suffix).toAliasString(this.identifierColumnAlias);
        }
        return null;
    }
}

