/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.jdbc.internal.StandardJdbcValuesMapping;

public class JdbcValuesMappingImpl
extends StandardJdbcValuesMapping {
    private final int rowSize;
    private final Map<String, LockMode> registeredLockModes;

    public JdbcValuesMappingImpl(List<SqlSelection> sqlSelections, List<DomainResult<?>> domainResults, int rowSize, Map<String, LockMode> registeredLockModes) {
        super(sqlSelections, domainResults);
        this.rowSize = rowSize;
        this.registeredLockModes = registeredLockModes;
    }

    @Override
    public int getRowSize() {
        return this.rowSize;
    }

    @Override
    public List<DomainResultAssembler<?>> resolveAssemblers(final AssemblerCreationState creationState) {
        AssemblerCreationState finalCreationState = this.registeredLockModes == null ? creationState : new AssemblerCreationState(){

            @Override
            public LockMode determineEffectiveLockMode(String identificationVariable) {
                LockMode lockMode = JdbcValuesMappingImpl.this.registeredLockModes.get(identificationVariable);
                if (lockMode == null) {
                    return creationState.determineEffectiveLockMode(identificationVariable);
                }
                return lockMode;
            }

            @Override
            public Initializer resolveInitializer(NavigablePath navigablePath, ModelPart fetchedModelPart, Supplier<Initializer> producer) {
                return creationState.resolveInitializer(navigablePath, fetchedModelPart, producer);
            }

            @Override
            public SqlAstCreationContext getSqlAstCreationContext() {
                return creationState.getSqlAstCreationContext();
            }

            @Override
            public ExecutionContext getExecutionContext() {
                return creationState.getExecutionContext();
            }
        };
        return super.resolveAssemblers(finalCreationState);
    }
}

