/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class SelfRenderingFunctionSqlAstExpression
implements SelfRenderingExpression,
Selectable,
SqlExpressible,
DomainResultProducer,
FunctionExpression {
    private final String functionName;
    private final FunctionRenderer renderer;
    private final List<? extends SqlAstNode> sqlAstArguments;
    private final ReturnableType<?> type;
    private final JdbcMappingContainer expressible;

    @Deprecated(forRemoval=true)
    public SelfRenderingFunctionSqlAstExpression(String functionName, FunctionRenderingSupport renderer, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> type, JdbcMappingContainer expressible) {
        this.functionName = functionName;
        this.renderer = renderer::render;
        this.sqlAstArguments = sqlAstArguments;
        this.type = type;
        this.expressible = expressible;
    }

    public SelfRenderingFunctionSqlAstExpression(String functionName, FunctionRenderer renderer, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> type, JdbcMappingContainer expressible) {
        this.functionName = functionName;
        this.renderer = renderer;
        this.sqlAstArguments = sqlAstArguments;
        this.type = type;
        this.expressible = expressible;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public List<? extends SqlAstNode> getArguments() {
        return this.sqlAstArguments;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.type instanceof SqlExpressible ? (JdbcMappingContainer)((Object)this.type) : this.expressible;
    }

    @Deprecated(forRemoval=true)
    protected FunctionRenderingSupport getRenderer() {
        return this.renderer;
    }

    protected FunctionRenderer getFunctionRenderer() {
        return this.renderer;
    }

    protected ReturnableType<?> getType() {
        return this.type;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaType, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, this, false);
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaType, boolean virtual, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, this, virtual);
    }

    public DomainResult<?> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        BasicValueConverter converter;
        JavaType<Object> jdbcJavaType;
        JdbcMapping jdbcMapping = this.getJdbcMapping();
        if (jdbcMapping != null) {
            jdbcJavaType = jdbcMapping.getJdbcJavaType();
            converter = jdbcMapping.getValueConverter();
        } else if (this.type != null) {
            jdbcJavaType = this.type.getExpressibleJavaType();
            converter = null;
        } else {
            jdbcJavaType = null;
            converter = null;
        }
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        return new BasicResult(sqlAstCreationState.getSqlExpressionResolver().resolveSqlSelection(this, jdbcJavaType, null, sqlAstCreationState.getCreationContext().getMappingMetamodel().getTypeConfiguration()).getValuesArrayPosition(), resultVariable, this.type == null ? null : this.type.getExpressibleJavaType(), converter);
    }

    @Override
    public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
        this.renderer.render(sqlAppender, this.sqlAstArguments, this.type, walker);
    }

    @Override
    public String getAlias(Dialect dialect) {
        return null;
    }

    @Override
    public String getAlias(Dialect dialect, Table table) {
        return null;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getTemplate(Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry registry) {
        return null;
    }

    @Override
    public String getText(Dialect dialect) {
        return null;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        if (this.type instanceof SqlExpressible) {
            return ((SqlExpressible)((Object)this.type)).getJdbcMapping();
        }
        if (this.expressible instanceof SqlExpressible) {
            return ((SqlExpressible)this.expressible).getJdbcMapping();
        }
        return null;
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        JdbcMapping jdbcMapping = this.getJdbcMapping();
        sqlAstCreationState.getSqlExpressionResolver().resolveSqlSelection(this, jdbcMapping != null ? jdbcMapping.getJdbcJavaType() : this.type.getExpressibleJavaType(), null, sqlAstCreationState.getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new UnsupportedOperationException();
    }
}

