/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.boot.model.internal.SoftDeleteHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MatchingIdSelectionHelper;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.StatementCreatorHelper;

public class InlineDeleteHandler
implements DeleteHandler {
    private final MatchingIdRestrictionProducer matchingIdsPredicateProducer;
    private final SqmDeleteStatement<?> sqmDeleteStatement;
    private final DomainParameterXref domainParameterXref;
    private final DomainQueryExecutionContext executionContext;
    private final SessionFactoryImplementor sessionFactory;
    private final SqlAstTranslatorFactory sqlAstTranslatorFactory;
    private final JdbcMutationExecutor jdbcMutationExecutor;

    protected InlineDeleteHandler(MatchingIdRestrictionProducer matchingIdsPredicateProducer, SqmDeleteStatement<?> sqmDeleteStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        this.sqmDeleteStatement = sqmDeleteStatement;
        this.domainParameterXref = domainParameterXref;
        this.matchingIdsPredicateProducer = matchingIdsPredicateProducer;
        this.executionContext = context;
        this.sessionFactory = this.executionContext.getSession().getFactory();
        this.sqlAstTranslatorFactory = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        this.jdbcMutationExecutor = this.sessionFactory.getJdbcServices().getJdbcMutationExecutor();
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        List<Object> idsAndFks = MatchingIdSelectionHelper.selectMatchingIds(this.sqmDeleteStatement, this.domainParameterXref, executionContext);
        if (idsAndFks == null || idsAndFks.isEmpty()) {
            return 0;
        }
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        String mutatingEntityName = ((SqmRoot)this.sqmDeleteStatement.getTarget()).getModel().getHibernateEntityName();
        EntityMappingType entityDescriptor = factory.getRuntimeMetamodels().getEntityMappingType(mutatingEntityName);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.domainParameterXref.getQueryParameterCount());
        MutableInteger valueIndexCounter = new MutableInteger();
        SqmMutationStrategyHelper.visitCollectionTables(entityDescriptor, pluralAttribute -> {
            if (pluralAttribute.getSeparateCollectionTable() != null) {
                int valueIndex;
                ValuedModelPart fkTargetPart = pluralAttribute.getKeyDescriptor().getTargetPart();
                if (fkTargetPart.isEntityIdentifierMapping()) {
                    valueIndex = 0;
                } else {
                    if (valueIndexCounter.get() == 0) {
                        valueIndexCounter.set(entityDescriptor.getIdentifierMapping().getJdbcTypeCount());
                    }
                    valueIndex = valueIndexCounter.get();
                    valueIndexCounter.plus(fkTargetPart.getJdbcTypeCount());
                }
                this.executeDelete(pluralAttribute.getSeparateCollectionTable(), entityDescriptor, () -> fkTargetPart::forEachSelectable, idsAndFks, valueIndex, fkTargetPart, jdbcParameterBindings, executionContext);
            }
        });
        SoftDeleteMapping softDeleteMapping = entityDescriptor.getSoftDeleteMapping();
        if (softDeleteMapping != null) {
            this.performSoftDelete(entityDescriptor, idsAndFks, jdbcParameterBindings, executionContext);
        } else {
            entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnsVisitationSupplier) -> this.executeDelete(tableExpression, entityDescriptor, tableKeyColumnsVisitationSupplier, idsAndFks, 0, null, jdbcParameterBindings, executionContext));
        }
        return idsAndFks.size();
    }

    private void performSoftDelete(EntityMappingType entityDescriptor, List<Object> idsAndFks, JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext executionContext) {
        TableDetails softDeleteTable = entityDescriptor.getSoftDeleteTableDetails();
        SoftDeleteMapping softDeleteMapping = entityDescriptor.getSoftDeleteMapping();
        assert (softDeleteMapping != null);
        NamedTableReference targetTableReference = new NamedTableReference(softDeleteTable.getTableName(), "to_delete_");
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        Predicate matchingIdsPredicate = this.matchingIdsPredicateProducer.produceRestriction(idsAndFks, entityDescriptor, 0, entityDescriptor.getIdentifierMapping(), targetTableReference, null, executionContextAdapter);
        Predicate predicate = Predicate.combinePredicates(matchingIdsPredicate, SoftDeleteHelper.createNonSoftDeletedRestriction(targetTableReference, softDeleteMapping));
        Assignment softDeleteAssignment = SoftDeleteHelper.createSoftDeleteAssignment(targetTableReference, softDeleteMapping);
        UpdateStatement updateStatement = new UpdateStatement(targetTableReference, Collections.singletonList(softDeleteAssignment), predicate);
        JdbcOperationQueryMutation jdbcOperation = this.sqlAstTranslatorFactory.buildMutationTranslator(this.sessionFactory, updateStatement).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        this.jdbcMutationExecutor.execute(jdbcOperation, jdbcParameterBindings, this::prepareQueryStatement, (integer, preparedStatement) -> {}, executionContextAdapter);
    }

    private void executeDelete(String targetTableExpression, EntityMappingType entityDescriptor, Supplier<Consumer<SelectableConsumer>> tableKeyColumnsVisitationSupplier, List<Object> ids, int valueIndex, ModelPart valueModelPart, JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext executionContext) {
        NamedTableReference targetTableReference = new NamedTableReference(targetTableExpression, "to_delete_");
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        Predicate matchingIdsPredicate = this.matchingIdsPredicateProducer.produceRestriction(ids, entityDescriptor, valueIndex, valueModelPart, targetTableReference, tableKeyColumnsVisitationSupplier, executionContextAdapter);
        DeleteStatement deleteStatement = new DeleteStatement(targetTableReference, matchingIdsPredicate);
        JdbcOperationQueryMutation jdbcOperation = this.sqlAstTranslatorFactory.buildMutationTranslator(this.sessionFactory, deleteStatement).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        this.jdbcMutationExecutor.execute(jdbcOperation, jdbcParameterBindings, this::prepareQueryStatement, (integer, preparedStatement) -> {}, executionContextAdapter);
    }

    private PreparedStatement prepareQueryStatement(String sql) {
        return StatementCreatorHelper.prepareQueryStatement(sql, this.executionContext.getSession());
    }
}

