/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmFromClause
implements Serializable {
    private List<SqmRoot<?>> domainRoots;

    public SqmFromClause() {
    }

    public SqmFromClause(int expectedNumberOfRoots) {
        this.domainRoots = CollectionHelper.arrayList(expectedNumberOfRoots);
    }

    private SqmFromClause(SqmFromClause original, SqmCopyContext context) {
        if (original.domainRoots != null) {
            this.domainRoots = new ArrayList(original.domainRoots.size());
            for (SqmRoot<?> domainRoot : original.domainRoots) {
                this.domainRoots.add((SqmRoot<?>)domainRoot.copy(context));
            }
        }
    }

    public SqmFromClause copy(SqmCopyContext context) {
        return new SqmFromClause(this, context);
    }

    public List<SqmRoot<?>> getRoots() {
        return this.domainRoots == null ? Collections.emptyList() : Collections.unmodifiableList(this.domainRoots);
    }

    public void setRoots(List<SqmRoot<?>> domainRoots) {
        this.domainRoots = domainRoots;
    }

    public void addRoot(SqmRoot<?> root) {
        if (this.domainRoots == null) {
            this.domainRoots = new ArrayList();
        }
        this.domainRoots.add(root);
    }

    public void visitRoots(Consumer<SqmRoot<?>> consumer) {
        if (this.domainRoots != null) {
            this.domainRoots.forEach(consumer);
        }
    }

    public int getNumberOfRoots() {
        if (this.domainRoots == null) {
            return 0;
        }
        return this.domainRoots.size();
    }
}

