/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model;

import java.util.List;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.jdbc.Expectation;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationType;

public interface PreparableMutationOperation
extends MutationOperation {
    public String getSqlString();

    public List<JdbcParameterBinder> getParameterBinders();

    public boolean isCallable();

    public Expectation getExpectation();

    default public boolean canBeBatched(BatchKey batchKey, int batchSize) {
        if (batchKey == null || batchSize < 2) {
            return false;
        }
        if (this.getMutationType() == MutationType.INSERT ? this.getTableDetails().isIdentifierTable() && this.getMutationTarget() instanceof EntityMutationTarget && ((EntityMutationTarget)this.getMutationTarget()).getIdentityInsertDelegate() != null : this.getMutationType() == MutationType.UPDATE && this.getTableDetails().isOptional()) {
            return false;
        }
        return this.getExpectation().canBeBatched();
    }
}

