/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.ByteArrayJavaType;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterArray;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayJdbcType
implements JdbcType {
    private final JdbcType elementJdbcType;

    public ArrayJdbcType(JdbcType elementJdbcType) {
        this.elementJdbcType = elementJdbcType;
    }

    @Override
    public int getJdbcTypeCode() {
        return 2003;
    }

    public JdbcType getElementJdbcType() {
        return this.elementJdbcType;
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        JavaType elementJavaType = this.elementJdbcType.getJdbcRecommendedJavaTypeMapping(precision, scale, typeConfiguration);
        return typeConfiguration.getJavaTypeRegistry().resolveDescriptor(Array.newInstance(elementJavaType.getJavaTypeClass(), 0).getClass());
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        JavaType<Byte> elementJavaType;
        if (javaTypeDescriptor instanceof ByteArrayJavaType) {
            elementJavaType = ByteJavaType.INSTANCE;
        } else if (javaTypeDescriptor instanceof BasicPluralJavaType) {
            elementJavaType = ((BasicPluralJavaType)((Object)javaTypeDescriptor)).getElementJavaType();
        } else {
            throw new IllegalArgumentException("not a BasicPluralJavaType");
        }
        return new JdbcLiteralFormatterArray<T>(javaTypeDescriptor, this.elementJdbcType.getJdbcLiteralFormatter(elementJavaType));
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return java.sql.Array.class;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setArray(index, this.getArray(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                java.sql.Array arr = this.getArray(value, options);
                try {
                    st.setObject(name, (Object)arr, 2003);
                }
                catch (SQLException ex) {
                    throw new HibernateException("JDBC driver does not support named parameters for setArray. Use positional.", ex);
                }
            }

            private java.sql.Array getArray(X value, WrapperOptions options) throws SQLException {
                TypeConfiguration typeConfiguration = options.getSessionFactory().getTypeConfiguration();
                JdbcType elementJdbcType = ((ArrayJdbcType)this.getJdbcType()).getElementJdbcType();
                JdbcType underlyingJdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(elementJdbcType.getDefaultSqlTypeCode());
                Class<?> preferredJavaTypeClass = elementJdbcType.getPreferredJavaTypeClass(options);
                Class<Object> elementJdbcJavaTypeClass = preferredJavaTypeClass == null ? underlyingJdbcType.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration).getJavaTypeClass() : preferredJavaTypeClass;
                Class<?> arrayClass = Array.newInstance(elementJdbcJavaTypeClass, 0).getClass();
                Object[] objects = (Object[])this.getJavaType().unwrap(value, arrayClass, options);
                SharedSessionContractImplementor session = options.getSession();
                String typeName = this.getElementTypeName(elementJdbcType, session);
                return session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().createArrayOf(typeName, objects);
            }

            private String getElementTypeName(JdbcType elementJdbcType, SharedSessionContractImplementor session) {
                JavaType<Byte> elementJavaType = this.getJavaType() instanceof ByteArrayJavaType ? ByteJavaType.INSTANCE : ((BasicPluralJavaType)((Object)this.getJavaType())).getElementJavaType();
                Size size = session.getJdbcServices().getDialect().getSizeStrategy().resolveSize(elementJdbcType, elementJavaType, null, null, null);
                DdlTypeRegistry ddlTypeRegistry = session.getTypeConfiguration().getDdlTypeRegistry();
                String typeName = ddlTypeRegistry.getDescriptor(elementJdbcType.getDdlTypeCode()).getTypeName(size, new BasicTypeImpl<Byte>(elementJavaType, elementJdbcType), ddlTypeRegistry);
                int cutIndex = typeName.indexOf(40);
                if (cutIndex > 0) {
                    return typeName.substring(0, cutIndex);
                }
                return typeName;
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(rs.getArray(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getArray(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getArray(name), options);
            }
        };
    }

    @Override
    public String getFriendlyName() {
        return "ARRAY";
    }

    public String toString() {
        return "ArrayTypeDescriptor";
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.getElementJdbcType().equals(((ArrayJdbcType)o).getElementJdbcType());
    }

    public int hashCode() {
        return this.getJdbcTypeCode() + 31 * this.getElementJdbcType().hashCode();
    }
}

