/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.protocol.mappers.saml;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;

public class OrganizationMembershipMapper
extends AbstractSAMLProtocolMapper
implements SAMLAttributeStatementMapper,
EnvironmentDependentProviderFactory {
    public static final String ID = "saml-organization-membership-mapper";
    public static final String ORGANIZATION_ATTRIBUTE_NAME = "organization";

    public static ProtocolMapperModel create() {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(ORGANIZATION_ATTRIBUTE_NAME);
        mapper.setProtocolMapper(ID);
        mapper.setProtocol("saml");
        return mapper;
    }

    @Override
    public void transformAttributeStatement(AttributeStatementType attributeStatement, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        if (!Organizations.isEnabledAndOrganizationsPresent(provider)) {
            return;
        }
        UserModel user = userSession.getUser();
        OrganizationModel organization = provider.getByMember(user);
        if (organization == null || !organization.isEnabled()) {
            return;
        }
        AttributeType attribute = new AttributeType(ORGANIZATION_ATTRIBUTE_NAME);
        attribute.setFriendlyName(ORGANIZATION_ATTRIBUTE_NAME);
        attribute.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_BASIC.get());
        attribute.addAttributeValue((Object)organization.getName());
        attributeStatement.addAttribute(new AttributeStatementType.ASTChoiceType(attribute));
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of();
    }

    public String getId() {
        return ID;
    }

    public String getDisplayType() {
        return "Organization Membership";
    }

    public String getDisplayCategory() {
        return "AttributeStatement Mapper";
    }

    public String getHelpText() {
        return "Add an attribute to the assertion with information about the organization membership.";
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION);
    }
}

