/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.DefaultBruteForceProtector;
import org.keycloak.sessions.AuthenticationSessionModel;

public class DefaultBlockingBruteForceProtector
extends DefaultBruteForceProtector {
    private static final int DEFAULT_MAX_CONCURRENT_ATTEMPTS = 1000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final String OFF_THREAD_STARTED = "#brute_force_started";
    private final Map<String, String> loginAttempts = Collections.synchronizedMap(new LinkedHashMap<String, String>(100, 0.75f){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return DefaultBlockingBruteForceProtector.this.loginAttempts.size() > 1000;
        }
    });

    DefaultBlockingBruteForceProtector(KeycloakSessionFactory factory) {
        super(factory);
    }

    @Override
    public boolean isPermanentlyLockedOut(KeycloakSession session, RealmModel realm, UserModel user) {
        if (super.isPermanentlyLockedOut(session, realm, user)) {
            return true;
        }
        if (!realm.isPermanentLockout()) {
            return false;
        }
        return this.isLoginInProgress(session, user);
    }

    @Override
    public boolean isTemporarilyDisabled(KeycloakSession session, RealmModel realm, UserModel user) {
        if (super.isTemporarilyDisabled(session, realm, user)) {
            return true;
        }
        return this.isLoginInProgress(session, user);
    }

    private boolean isLoginInProgress(KeycloakSession session, UserModel user) {
        AuthenticationSessionModel authSession = session.getContext().getAuthenticationSession();
        if (authSession == null) {
            return false;
        }
        return !this.tryEnlistBlockingTransactionOrSameThread(session, user);
    }

    private boolean tryEnlistBlockingTransactionOrSameThread(KeycloakSession session, final UserModel user) {
        AtomicBoolean inserted = new AtomicBoolean(false);
        String threadInProgress = this.loginAttempts.computeIfAbsent(user.getId(), k -> {
            inserted.set(true);
            return this.getThreadName();
        });
        if (inserted.get()) {
            session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new AbstractKeycloakTransaction(){

                protected void commitImpl() {
                    DefaultBlockingBruteForceProtector.this.loginAttempts.computeIfPresent(user.getId(), (k, v) -> v.endsWith(DefaultBlockingBruteForceProtector.OFF_THREAD_STARTED) ? "" : null);
                }

                protected void rollbackImpl() {
                    DefaultBlockingBruteForceProtector.this.loginAttempts.remove(user.getId());
                }
            });
            return true;
        }
        return this.isCurrentThread(threadInProgress);
    }

    private boolean isCurrentThread(String name) {
        return name.equals(this.getThreadName()) || name.equals(this.getThreadName() + OFF_THREAD_STARTED);
    }

    private String getThreadName() {
        return Thread.currentThread().getName();
    }

    private void enlistRemoval(KeycloakSession session, final String userId) {
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new AbstractKeycloakTransaction(){

            protected void commitImpl() {
                DefaultBlockingBruteForceProtector.this.loginAttempts.computeIfPresent(userId, (k, v) -> v.isEmpty() ? null : v.substring(0, v.length() - DefaultBlockingBruteForceProtector.OFF_THREAD_STARTED.length()));
            }

            protected void rollbackImpl() {
                DefaultBlockingBruteForceProtector.this.loginAttempts.remove(userId);
            }
        });
    }

    @Override
    protected void processLogin(RealmModel realm, UserModel user, ClientConnection clientConnection, boolean success) {
        this.loginAttempts.computeIfPresent(user.getId(), (k, v) -> v + OFF_THREAD_STARTED);
        super.processLogin(realm, user, clientConnection, success);
    }

    @Override
    protected void failure(KeycloakSession session, RealmModel realm, String userId, String remoteAddr, long failureTime) {
        this.enlistRemoval(session, userId);
        super.failure(session, realm, userId, remoteAddr, failureTime);
    }

    @Override
    protected void success(KeycloakSession session, RealmModel realm, String userId) {
        this.enlistRemoval(session, userId);
        super.success(session, realm, userId);
    }
}

