/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class ClientScopeAddedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String clientScopeId;
    private String realmId;

    public static ClientScopeAddedEvent create(String clientScopeId, String realmId) {
        ClientScopeAddedEvent event = new ClientScopeAddedEvent();
        event.clientScopeId = clientScopeId;
        event.realmId = realmId;
        return event;
    }

    @Override
    public String getId() {
        return this.clientScopeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientScopeAddedEvent that = (ClientScopeAddedEvent)o;
        return Objects.equals(this.clientScopeId, that.clientScopeId) && Objects.equals(this.realmId, that.realmId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientScopeId, this.realmId);
    }

    public String toString() {
        return String.format("ClientScopeAddedEvent [ clientScopeId=%s, realmId=%s ]", this.clientScopeId, this.realmId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.clientScopeAdded(this.realmId, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<ClientScopeAddedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ClientScopeAddedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.clientScopeId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
        }

        public ClientScopeAddedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ClientScopeAddedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ClientScopeAddedEvent res = new ClientScopeAddedEvent();
            res.clientScopeId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

