/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.security.AccessController;
import org.jboss.marshalling._private.GetUnsafeAction;
import org.jboss.marshalling.reflect.JDKSpecific;
import org.jboss.marshalling.util.Kind;
import sun.misc.Unsafe;

public final class SerializableField {
    static final Unsafe unsafe = System.getSecurityManager() == null ? GetUnsafeAction.INSTANCE.run() : AccessController.doPrivileged(GetUnsafeAction.INSTANCE);
    private final Class<?> type;
    private final Field field;
    private final String name;
    private final boolean unshared;
    private final Kind kind;
    private final long fieldOffset;
    private final int recordComponentIndex;

    public SerializableField(Class<?> type, String name, boolean unshared) {
        this(type, name, unshared, null, null);
    }

    SerializableField(Class<?> type, String name, boolean unshared, Field field, RecordComponent recordComponent) {
        assert (field == null || (field.getModifiers() & 8) == 0 && !field.getDeclaringClass().isArray());
        this.type = type;
        this.name = name;
        this.unshared = unshared;
        this.field = field;
        long l = this.fieldOffset = field == null || recordComponent != null ? -1L : unsafe.objectFieldOffset(field);
        if (field != null) {
            if (field.getType() != type) {
                throw new IllegalStateException("Constructed a serializable field with the wrong type (field type is " + field.getType() + ", our type is " + type + ")");
            }
            if (!field.getName().equals(name)) {
                throw new IllegalStateException("Constructed a serializable field with the wrong name (field name is " + field.getName() + ", our name is " + name + ")");
            }
        }
        if (recordComponent != null) {
            if (field == null) {
                throw new IllegalStateException("Record component field not passed for name " + recordComponent.getName());
            }
            if (recordComponent.getType() != type) {
                throw new IllegalStateException("Record component field with the wrong type (field type is " + recordComponent.getType() + ", our type is " + type + ")");
            }
            if (!recordComponent.getName().equals(name)) {
                throw new IllegalStateException("Record component field with the wrong name (field name is " + recordComponent.getName() + ", our name is " + name + ")");
            }
            this.recordComponentIndex = recordComponent.getIndex();
        } else {
            this.recordComponentIndex = -1;
        }
        this.kind = type == Boolean.TYPE ? Kind.BOOLEAN : (type == Byte.TYPE ? Kind.BYTE : (type == Short.TYPE ? Kind.SHORT : (type == Integer.TYPE ? Kind.INT : (type == Long.TYPE ? Kind.LONG : (type == Character.TYPE ? Kind.CHAR : (type == Float.TYPE ? Kind.FLOAT : (type == Double.TYPE ? Kind.DOUBLE : Kind.OBJECT)))))));
    }

    @Deprecated
    public Field getField() {
        return this.field;
    }

    public boolean isAccessible() {
        return this.field != null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Class<?> getType() throws ClassNotFoundException {
        return this.type;
    }

    public void setBoolean(Object instance, boolean value) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Boolean.TYPE) {
            throw new ClassCastException();
        }
        unsafe.putBoolean(instance, this.fieldOffset, value);
    }

    public void setChar(Object instance, char value) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Character.TYPE) {
            throw new ClassCastException();
        }
        unsafe.putChar(instance, this.fieldOffset, value);
    }

    public void setByte(Object instance, byte value) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Byte.TYPE) {
            throw new ClassCastException();
        }
        unsafe.putByte(instance, this.fieldOffset, value);
    }

    public void setShort(Object instance, short value) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Short.TYPE) {
            throw new ClassCastException();
        }
        unsafe.putShort(instance, this.fieldOffset, value);
    }

    public void setInt(Object instance, int value) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Integer.TYPE) {
            throw new ClassCastException();
        }
        unsafe.putInt(instance, this.fieldOffset, value);
    }

    public void setLong(Object instance, long value) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Long.TYPE) {
            throw new ClassCastException();
        }
        unsafe.putLong(instance, this.fieldOffset, value);
    }

    public void setFloat(Object instance, float value) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Float.TYPE) {
            throw new ClassCastException();
        }
        unsafe.putFloat(instance, this.fieldOffset, value);
    }

    public void setDouble(Object instance, double value) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Double.TYPE) {
            throw new ClassCastException();
        }
        unsafe.putDouble(instance, this.fieldOffset, value);
    }

    public void setObject(Object instance, Object value) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        Class<?> fieldType = this.field.getType();
        if (fieldType.isPrimitive()) {
            throw new ClassCastException();
        }
        fieldType.cast(value);
        unsafe.putObject(instance, this.fieldOffset, value);
    }

    public boolean getBoolean(Object instance) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Boolean.TYPE) {
            throw new ClassCastException();
        }
        return unsafe.getBoolean(instance, this.fieldOffset);
    }

    public char getChar(Object instance) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Character.TYPE) {
            throw new ClassCastException();
        }
        return unsafe.getChar(instance, this.fieldOffset);
    }

    public byte getByte(Object instance) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Byte.TYPE) {
            throw new ClassCastException();
        }
        return unsafe.getByte(instance, this.fieldOffset);
    }

    public short getShort(Object instance) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Short.TYPE) {
            throw new ClassCastException();
        }
        return unsafe.getShort(instance, this.fieldOffset);
    }

    public int getInt(Object instance) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Integer.TYPE) {
            throw new ClassCastException();
        }
        return unsafe.getInt(instance, this.fieldOffset);
    }

    public long getLong(Object instance) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Long.TYPE) {
            throw new ClassCastException();
        }
        return unsafe.getLong(instance, this.fieldOffset);
    }

    public float getFloat(Object instance) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Float.TYPE) {
            throw new ClassCastException();
        }
        return unsafe.getFloat(instance, this.fieldOffset);
    }

    public double getDouble(Object instance) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType() != Double.TYPE) {
            throw new ClassCastException();
        }
        return unsafe.getDouble(instance, this.fieldOffset);
    }

    public Object getObject(Object instance) throws ClassCastException, IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.field == null) {
            throw new IllegalArgumentException();
        }
        this.field.getDeclaringClass().cast(instance);
        if (this.field.getType().isPrimitive()) {
            throw new ClassCastException();
        }
        return unsafe.getObject(instance, this.fieldOffset);
    }

    public void readFrom(Object instance, ObjectInput input) throws IOException, ClassNotFoundException {
        switch (this.kind) {
            case BOOLEAN: {
                this.setBoolean(instance, input.readBoolean());
                break;
            }
            case BYTE: {
                this.setByte(instance, input.readByte());
                break;
            }
            case CHAR: {
                this.setChar(instance, input.readChar());
                break;
            }
            case DOUBLE: {
                this.setDouble(instance, input.readDouble());
                break;
            }
            case FLOAT: {
                this.setFloat(instance, input.readFloat());
                break;
            }
            case INT: {
                this.setInt(instance, input.readInt());
                break;
            }
            case LONG: {
                this.setLong(instance, input.readLong());
                break;
            }
            case SHORT: {
                this.setShort(instance, input.readShort());
                break;
            }
            case OBJECT: {
                this.setObject(instance, input.readObject());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void writeTo(Object instance, ObjectOutput output) throws IOException {
        switch (this.kind) {
            case BOOLEAN: {
                output.writeBoolean(this.getBoolean(instance));
                break;
            }
            case BYTE: {
                output.writeByte(this.getByte(instance));
                break;
            }
            case CHAR: {
                output.writeChar(this.getChar(instance));
                break;
            }
            case DOUBLE: {
                output.writeDouble(this.getDouble(instance));
                break;
            }
            case FLOAT: {
                output.writeFloat(this.getFloat(instance));
                break;
            }
            case INT: {
                output.writeInt(this.getInt(instance));
                break;
            }
            case LONG: {
                output.writeLong(this.getLong(instance));
                break;
            }
            case SHORT: {
                output.writeShort(this.getShort(instance));
                break;
            }
            case OBJECT: {
                output.writeObject(this.getObject(instance));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public Object getRecordComponentValue(Object obj) {
        if (this.recordComponentIndex == -1) {
            return null;
        }
        return JDKSpecific.getRecordComponentValue(obj, this.name, this.type);
    }

    public int getRecordComponentIndex() {
        return this.recordComponentIndex;
    }

    static final class RecordComponent {
        private final String name;
        private final Class<?> type;
        private final int index;

        RecordComponent(String name, Class<?> type, int index) {
            this.name = name;
            this.type = type;
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

