/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TPMTHA
implements Serializable {
    private final TPMIAlgHash hashAlg;
    private final byte[] digest;

    public TPMTHA(@NonNull TPMIAlgHash hashAlg, @NonNull byte[] digest) {
        this.hashAlg = hashAlg;
        this.digest = digest;
    }

    public @NonNull TPMIAlgHash getHashAlg() {
        return this.hashAlg;
    }

    public @NonNull byte[] getDigest() {
        return ArrayUtil.clone((byte[])this.digest);
    }

    public @NonNull byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this.digest.length);
        buffer.put(UnsignedNumberUtil.toBytes((int)this.hashAlg.getValue()));
        buffer.put(this.digest);
        return buffer.array();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMTHA tpmtha = (TPMTHA)o;
        return this.hashAlg == tpmtha.hashAlg && Arrays.equals(this.digest, tpmtha.digest);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.hashAlg});
        result = 31 * result + Arrays.hashCode(this.digest);
        return result;
    }
}

