/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.type;

import io.quarkus.deployment.configuration.type.ArrayOf;
import io.quarkus.deployment.configuration.type.CollectionOf;
import io.quarkus.deployment.configuration.type.Leaf;
import io.quarkus.deployment.configuration.type.LowerBoundCheckOf;
import io.quarkus.deployment.configuration.type.OptionalOf;
import io.quarkus.deployment.configuration.type.UpperBoundCheckOf;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.annotations.DefaultConverter;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;

public abstract class ConverterType {
    ConverterType() {
    }

    public abstract Class<?> getLeafType();

    public static ConverterType of(Field member) {
        return ConverterType.of(member.getGenericType(), member);
    }

    public static ConverterType of(Parameter parameter) {
        return ConverterType.of(parameter.getParameterizedType(), parameter);
    }

    public static ConverterType of(Type type, AnnotatedElement element) {
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return new ArrayOf(ConverterType.of(genericArrayType.getGenericComponentType(), element));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return new ArrayOf(ConverterType.of(clazz.getComponentType(), element));
            }
            ConvertWith convertWith = element.getAnnotation(ConvertWith.class);
            Leaf leaf = convertWith == null && element.getAnnotation(DefaultConverter.class) == null && clazz.isEnum() ? new Leaf(clazz, HyphenateEnumConverter.class) : new Leaf(clazz, convertWith == null ? null : convertWith.value());
            return leaf;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Class<?> rawType = ReflectUtil.rawTypeOf(paramType);
            Type[] args = paramType.getActualTypeArguments();
            if (args.length == 1) {
                Type arg = args[0];
                if (rawType == Class.class) {
                    ConverterType result = ConverterType.of(Class.class, element);
                    if (arg instanceof WildcardType) {
                        WildcardType wcType = (WildcardType)arg;
                        Class<?>[] upperBounds = ReflectUtil.rawTypesOfDestructive(wcType.getUpperBounds());
                        Class<?>[] lowerBounds = ReflectUtil.rawTypesOfDestructive(wcType.getLowerBounds());
                        for (Class<?> upperBound : upperBounds) {
                            if (upperBound == Object.class) continue;
                            result = new UpperBoundCheckOf(upperBound, result);
                        }
                        for (Class<?> lowerBound : lowerBounds) {
                            result = new LowerBoundCheckOf(lowerBound, result);
                        }
                        return result;
                    }
                    throw new IllegalArgumentException("Class configuration item types cannot be invariant");
                }
                ConverterType nested = ConverterType.of(arg, element);
                if (rawType == List.class || rawType == Set.class || rawType == SortedSet.class || rawType == NavigableSet.class) {
                    return new CollectionOf(nested, rawType);
                }
                if (rawType == Optional.class) {
                    return new OptionalOf(nested);
                }
                throw ConverterType.unsupportedType(type);
            }
            if (args.length == 2) {
                if (rawType == Map.class) {
                    return ConverterType.of(ReflectUtil.typeOfParameter(paramType, 1), element);
                }
                throw ConverterType.unsupportedType(type);
            }
            throw ConverterType.unsupportedType(type);
        }
        throw ConverterType.unsupportedType(type);
    }

    private static IllegalArgumentException unsupportedType(Type type) {
        return new IllegalArgumentException("Unsupported type: " + type);
    }
}

