/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class PropertyUtils {
    private static final String OS_NAME = "os.name";
    private static final String USER_HOME = "user.home";
    private static final String WINDOWS = "windows";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private PropertyUtils() {
    }

    public static boolean isWindows() {
        return PropertyUtils.getProperty(OS_NAME).toLowerCase(Locale.ENGLISH).contains(WINDOWS);
    }

    public static String getUserHome() {
        return PropertyUtils.getProperty(USER_HOME);
    }

    public static String getProperty(final String name, final String defValue) {
        assert (name != null) : "name is null";
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name, defValue);
                }
            });
        }
        return System.getProperty(name, defValue);
    }

    public static String getProperty(final String name) {
        assert (name != null) : "name is null";
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
        }
        return System.getProperty(name);
    }

    public static final Boolean getBooleanOrNull(String name) {
        String value = PropertyUtils.getProperty(name);
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public static final boolean getBoolean(String name, boolean notFoundValue) {
        String value = PropertyUtils.getProperty(name, notFoundValue ? TRUE : FALSE);
        return value.isEmpty() ? true : Boolean.parseBoolean(value);
    }

    public static void store(Properties properties, Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            PropertyUtils.store(properties, writer);
        }
    }

    public static void store(Properties properties, Writer writer) throws IOException {
        ArrayList<String> names = new ArrayList<String>(properties.size());
        for (Object object : properties.keySet()) {
            names.add(object == null ? null : object.toString());
        }
        Collections.sort(names);
        for (String string : names) {
            PropertyUtils.store(writer, string, properties.getProperty(string));
        }
    }

    public static void store(Map<String, String> properties, Path file) throws IOException {
        ArrayList<String> names = new ArrayList<String>(properties.keySet());
        Collections.sort(names);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            for (String name : names) {
                PropertyUtils.store(writer, name, properties.get(name));
            }
        }
    }

    public static void store(Writer writer, String name, String value) throws IOException {
        if (value != null) {
            name = PropertyUtils.toWritableValue(name, true, true);
            value = PropertyUtils.toWritableValue(value, false, true);
            writer.write(name);
            writer.write("=");
            writer.write(value);
            writer.write(System.lineSeparator());
        }
    }

    private static String toWritableValue(String str, boolean escapeSpace, boolean escapeUnicode) {
        int len = str.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = str.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertyUtils.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertyUtils.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertyUtils.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertyUtils.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

