---
id: Tile
section: components
beta: true
cssPrefix: pf-c-tile
---import './Tile.css'

## Examples

### Basic tiles

```html isBeta
<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header">
    <div class="pf-c-tile__title">Default</div>
  </div>
</div>
<div class="pf-c-tile pf-m-selected" tabindex="0">
  <div class="pf-c-tile__header">
    <div class="pf-c-tile__title">Selected</div>
  </div>
</div>
<div class="pf-c-tile pf-m-disabled" tabindex="-1">
  <div class="pf-c-tile__header">
    <div class="pf-c-tile__title">Disabled</div>
  </div>
</div>
<br />
<br />

<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header">
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-selected" tabindex="0">
  <div class="pf-c-tile__header">
    <div class="pf-c-tile__title">Selected</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-disabled" tabindex="-1">
  <div class="pf-c-tile__header">
    <div class="pf-c-tile__title">Disabled</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<br />
<br />

<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header">
    <div class="pf-c-tile__icon">
      <i class="fas fa-plus" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-selected" tabindex="0">
  <div class="pf-c-tile__header">
    <div class="pf-c-tile__icon">
      <i class="fas fa-plus" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Selected</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-disabled" tabindex="-1">
  <div class="pf-c-tile__header">
    <div class="pf-c-tile__icon">
      <i class="fas fa-plus" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Disabled</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>

```

### Stacked tiles

```html
<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <i class="fas fa-bell" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-selected" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <i class="fas fa-bell" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Selected</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-disabled" tabindex="-1">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <i class="fas fa-bell" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Disabled</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<br />
<br />

<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="UTF-8"?>
      <svg
        width="1.1em"
        height="1em"
        viewBox="0 0 30 27"
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
      >
        <!-- Generator: Sketch 54 (76480) - https://sketchapp.com -->
        <title>Group 12</title>
        <desc>Created with Sketch.</desc>
        <g stroke="none" stroke-width="1" fill="none">
          <g transform="translate(-351.000000, -422.000000)" fill="#000000">
            <g transform="translate(322.000000, 395.000000)">
              <g transform="translate(29.000000, 27.000000)">
                <g>
                  <path
                    d="M29.3047523,13.6067281 L14.8028311,0.0924998513 L14.6960566,0 L14.5601618,0.0924998513 L0.0873609707,13.6067281 L0,13.689978 L0.0679474216,13.7824778 L5.82406471,21.5709653 L5.88230536,21.6449652 L5.9793731,21.6449652 L10.2794742,20.7199667 L14.5601618,26.4364575 L14.6766431,26.5937073 L14.7931244,26.4364575 L19.0932255,20.6829668 L23.3836198,21.6079653 L23.4806876,21.6079653 L23.5389282,21.5339654 L29.3047523,13.7454779 L29.3726997,13.6529781 L29.3047523,13.6067281 Z M20.9957533,15.1699756 L21.5005056,16.2522239 L18.7826087,19.878218 L17.5789687,19.6192185 L20.9957533,15.1699756 Z M21.1607685,13.7454779 L16.0841254,2.77499554 L23.2186047,11.0999822 L21.1607685,13.7454779 Z M22.3255814,16.4002236 L22.3741153,16.3354737 L22.3741153,16.2614739 L21.5587462,14.5039767 L24.1116279,11.0999822 L24.1698686,11.0999822 L24.1019211,11.0167323 L18.9573306,5.01349194 L28.411729,13.8194778 L26.4703741,16.4002236 L23.1506572,20.8864664 L19.5494439,20.1002177 L22.3255814,16.4002236 Z M12.269363,20.2482175 L14.6669363,23.3747124 L14.7931244,23.5412122 L14.9096057,23.3747124 L17.1227503,20.2482175 L18.3166835,20.516467 L14.6960566,25.3634592 L11.0754297,20.516467 L12.269363,20.2482175 Z M12.871183,19.8227181 L14.6960566,2.88599536 L16.5015167,19.8227181 L14.7542973,22.2924642 L12.871183,19.8227181 Z M13.8418605,3.34849462 L12.1237614,18.8144698 L8.73609707,14.4207268 L13.8418605,3.34849462 Z M6.17350859,11.0999822 L13.3176946,2.77499554 L8.23134479,13.7454779 L6.17350859,11.0999822 Z M10.4347826,4.99499197 L5.29019211,10.9982323 L5.22224469,11.0999822 L5.29019211,11.183232 L7.88190091,14.5502266 L7.06653185,16.3077238 L7.06653185,16.3817237 L7.06653185,16.4464736 L9.79413549,20.1002177 L6.20262892,20.8864664 L0.970677452,13.7732279 L10.4347826,4.99499197 Z M11.8131446,19.6469684 L10.6095046,19.905968 L7.90131446,16.2522239 L8.39635996,15.1699756 L11.8131446,19.6469684 Z M15.5308392,3.34849462 L20.6463094,14.4484768 L17.2683519,18.8422197 L15.5308392,3.34849462 Z"
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-selected" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="UTF-8"?>
      <svg
        width="1.1em"
        height="1em"
        viewBox="0 0 30 27"
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
      >
        <!-- Generator: Sketch 54 (76480) - https://sketchapp.com -->
        <title>Group 12</title>
        <desc>Created with Sketch.</desc>
        <g stroke="none" stroke-width="1" fill="none">
          <g transform="translate(-351.000000, -422.000000)" fill="#000000">
            <g transform="translate(322.000000, 395.000000)">
              <g transform="translate(29.000000, 27.000000)">
                <g>
                  <path
                    d="M29.3047523,13.6067281 L14.8028311,0.0924998513 L14.6960566,0 L14.5601618,0.0924998513 L0.0873609707,13.6067281 L0,13.689978 L0.0679474216,13.7824778 L5.82406471,21.5709653 L5.88230536,21.6449652 L5.9793731,21.6449652 L10.2794742,20.7199667 L14.5601618,26.4364575 L14.6766431,26.5937073 L14.7931244,26.4364575 L19.0932255,20.6829668 L23.3836198,21.6079653 L23.4806876,21.6079653 L23.5389282,21.5339654 L29.3047523,13.7454779 L29.3726997,13.6529781 L29.3047523,13.6067281 Z M20.9957533,15.1699756 L21.5005056,16.2522239 L18.7826087,19.878218 L17.5789687,19.6192185 L20.9957533,15.1699756 Z M21.1607685,13.7454779 L16.0841254,2.77499554 L23.2186047,11.0999822 L21.1607685,13.7454779 Z M22.3255814,16.4002236 L22.3741153,16.3354737 L22.3741153,16.2614739 L21.5587462,14.5039767 L24.1116279,11.0999822 L24.1698686,11.0999822 L24.1019211,11.0167323 L18.9573306,5.01349194 L28.411729,13.8194778 L26.4703741,16.4002236 L23.1506572,20.8864664 L19.5494439,20.1002177 L22.3255814,16.4002236 Z M12.269363,20.2482175 L14.6669363,23.3747124 L14.7931244,23.5412122 L14.9096057,23.3747124 L17.1227503,20.2482175 L18.3166835,20.516467 L14.6960566,25.3634592 L11.0754297,20.516467 L12.269363,20.2482175 Z M12.871183,19.8227181 L14.6960566,2.88599536 L16.5015167,19.8227181 L14.7542973,22.2924642 L12.871183,19.8227181 Z M13.8418605,3.34849462 L12.1237614,18.8144698 L8.73609707,14.4207268 L13.8418605,3.34849462 Z M6.17350859,11.0999822 L13.3176946,2.77499554 L8.23134479,13.7454779 L6.17350859,11.0999822 Z M10.4347826,4.99499197 L5.29019211,10.9982323 L5.22224469,11.0999822 L5.29019211,11.183232 L7.88190091,14.5502266 L7.06653185,16.3077238 L7.06653185,16.3817237 L7.06653185,16.4464736 L9.79413549,20.1002177 L6.20262892,20.8864664 L0.970677452,13.7732279 L10.4347826,4.99499197 Z M11.8131446,19.6469684 L10.6095046,19.905968 L7.90131446,16.2522239 L8.39635996,15.1699756 L11.8131446,19.6469684 Z M15.5308392,3.34849462 L20.6463094,14.4484768 L17.2683519,18.8422197 L15.5308392,3.34849462 Z"
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    </div>
    <div class="pf-c-tile__title">Selected</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-disabled" tabindex="-1">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="UTF-8"?>
      <svg
        width="1.1em"
        height="1em"
        viewBox="0 0 30 27"
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
      >
        <!-- Generator: Sketch 54 (76480) - https://sketchapp.com -->
        <title>Group 12</title>
        <desc>Created with Sketch.</desc>
        <g stroke="none" stroke-width="1" fill="none">
          <g transform="translate(-351.000000, -422.000000)" fill="#000000">
            <g transform="translate(322.000000, 395.000000)">
              <g transform="translate(29.000000, 27.000000)">
                <g>
                  <path
                    d="M29.3047523,13.6067281 L14.8028311,0.0924998513 L14.6960566,0 L14.5601618,0.0924998513 L0.0873609707,13.6067281 L0,13.689978 L0.0679474216,13.7824778 L5.82406471,21.5709653 L5.88230536,21.6449652 L5.9793731,21.6449652 L10.2794742,20.7199667 L14.5601618,26.4364575 L14.6766431,26.5937073 L14.7931244,26.4364575 L19.0932255,20.6829668 L23.3836198,21.6079653 L23.4806876,21.6079653 L23.5389282,21.5339654 L29.3047523,13.7454779 L29.3726997,13.6529781 L29.3047523,13.6067281 Z M20.9957533,15.1699756 L21.5005056,16.2522239 L18.7826087,19.878218 L17.5789687,19.6192185 L20.9957533,15.1699756 Z M21.1607685,13.7454779 L16.0841254,2.77499554 L23.2186047,11.0999822 L21.1607685,13.7454779 Z M22.3255814,16.4002236 L22.3741153,16.3354737 L22.3741153,16.2614739 L21.5587462,14.5039767 L24.1116279,11.0999822 L24.1698686,11.0999822 L24.1019211,11.0167323 L18.9573306,5.01349194 L28.411729,13.8194778 L26.4703741,16.4002236 L23.1506572,20.8864664 L19.5494439,20.1002177 L22.3255814,16.4002236 Z M12.269363,20.2482175 L14.6669363,23.3747124 L14.7931244,23.5412122 L14.9096057,23.3747124 L17.1227503,20.2482175 L18.3166835,20.516467 L14.6960566,25.3634592 L11.0754297,20.516467 L12.269363,20.2482175 Z M12.871183,19.8227181 L14.6960566,2.88599536 L16.5015167,19.8227181 L14.7542973,22.2924642 L12.871183,19.8227181 Z M13.8418605,3.34849462 L12.1237614,18.8144698 L8.73609707,14.4207268 L13.8418605,3.34849462 Z M6.17350859,11.0999822 L13.3176946,2.77499554 L8.23134479,13.7454779 L6.17350859,11.0999822 Z M10.4347826,4.99499197 L5.29019211,10.9982323 L5.22224469,11.0999822 L5.29019211,11.183232 L7.88190091,14.5502266 L7.06653185,16.3077238 L7.06653185,16.3817237 L7.06653185,16.4464736 L9.79413549,20.1002177 L6.20262892,20.8864664 L0.970677452,13.7732279 L10.4347826,4.99499197 Z M11.8131446,19.6469684 L10.6095046,19.905968 L7.90131446,16.2522239 L8.39635996,15.1699756 L11.8131446,19.6469684 Z M15.5308392,3.34849462 L20.6463094,14.4484768 L17.2683519,18.8422197 L15.5308392,3.34849462 Z"
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    </div>
    <div class="pf-c-tile__title">Disabled</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<br />
<br />

<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="UTF-8"?>
      <svg
        width="2.59em"
        height="1em"
        viewBox="0 0 140 54"
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
      >
        <title>Logo-Red_Hat-Insights-A-Standard-RGB</title>
        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
          <g fill-rule="nonzero">
            <polygon
              fill="#000000"
              points="50.99625 32.5665 53.45325 32.5665 53.45325 48.9465 50.99625 48.9465"
            />
            <path
              d="M56.51775,37.035 L58.85775,37.035 L58.85775,38.22975 C59.8067449,37.2846364 61.1008052,36.7684754 62.43975,36.801 C65.17575,36.801 67.095,38.69775 67.095,41.4585 L67.095,48.9465 L64.755,48.9465 L64.755,41.85 C64.755,39.978 63.60975,38.8305 61.8075,38.8305 C60.6212439,38.7905177 59.5011836,39.3766057 58.85775,40.374 L58.85775,48.93975 L56.51775,48.93975 L56.51775,37.035 Z"
              fill="#000000"
            />
            <path
              d="M69.9255,45.85725 C71.1675,46.8405 72.477,47.35575 73.81125,47.35575 C75.4965,47.35575 76.6665,46.629 76.6665,45.576 C76.6665,44.7345 76.05675,44.24175 74.74725,44.055 L72.594,43.75125 C70.2315,43.40025 69.03675,42.3 69.03675,40.45275 C69.03675,38.2995 70.90875,36.85275 73.69425,36.85275 C75.4135277,36.8419204 77.0923292,37.3742233 78.49125,38.37375 L77.29875,39.91725 C75.987,39.05325 74.7945,38.6775 73.53,38.6775 C72.1035,38.6775 71.14275,39.33225 71.14275,40.293 C71.14275,41.15925 71.70525,41.58 73.10925,41.78925 L75.2625,42.09525 C77.625,42.44625 78.8625,43.569 78.8625,45.41625 C78.8625,47.547 76.7115,49.1625 73.87875,49.1625 C71.82,49.1625 69.9705,48.55275 68.661,47.40525 L69.9255,45.85725 Z"
              fill="#000000"
            />
            <path
              d="M80.4105,33.6645 C80.4069047,33.283003 80.5553213,32.9157674 80.8229733,32.6438937 C81.0906253,32.3720201 81.4554935,32.217875 81.837,32.2155 C82.3687044,32.194552 82.8692347,32.4662713 83.1413188,32.9235662 C83.4134029,33.3808611 83.4134029,33.9503889 83.1413188,34.4076838 C82.8692347,34.8649787 82.3687044,35.136698 81.837,35.11575 C81.4552881,35.1127801 81.0904257,34.958136 80.8228378,34.6859054 C80.5552498,34.4136748 80.4069042,34.0462065 80.4105,33.6645 L80.4105,33.6645 Z M83.007,48.9465 L80.667,48.9465 L80.667,37.035 L83.007,37.035 L83.007,48.9465 Z"
              fill="#000000"
            />
            <path
              d="M85.23,42.93225 C85.2033544,41.3167935 85.8285349,39.7586992 86.9644096,38.6097003 C88.1002842,37.4607015 89.651094,36.8176637 91.26675,36.8256746 C92.5435648,36.8268531 93.7849591,37.2456558 94.8015,38.01825 L94.8015,37.035 L97.11675,37.035 L97.11675,49.11075 C97.11675,52.2 95.175,53.93025 91.665,53.93025 C89.9937961,53.9434018 88.3454783,53.5413731 86.868,52.76025 L87.7815,50.9355 C89.1315,51.6375 90.33075,51.966 91.59525,51.966 C93.6765,51.966 94.77675,50.98275 94.77675,49.11075 L94.77675,47.7765 C93.7744176,48.6004219 92.5170042,49.0505775 91.2195,49.05 C87.87375,49.05 85.23,46.35 85.23,42.93225 Z M91.50075,47.00475 C92.85075,47.00475 94.005,46.512 94.77675,45.62325 L94.77675,40.24125 C93.9355396,39.3292017 92.7410291,38.8254726 91.50075,38.85975 C89.25075,38.85975 87.52275,40.6395 87.52275,42.93225 C87.52275,45.225 89.25525,47.00475 91.50075,47.00475 Z"
              fill="#000000"
            />
            <path
              d="M99.8775,32.5665 L102.2175,32.05125 L102.2175,38.22975 C103.166495,37.2846364 104.460555,36.7684754 105.7995,36.801 C108.5355,36.801 110.45475,38.69775 110.45475,41.4585 L110.45475,48.9465 L108.11475,48.9465 L108.11475,41.85 C108.11475,39.978 106.9695,38.8305 105.16725,38.8305 C103.980994,38.7905177 102.860934,39.3766057 102.2175,40.374 L102.2175,48.93975 L99.8775,48.93975 L99.8775,32.5665 Z"
              fill="#000000"
            />
            <path
              d="M114.2235,39.0015 L111.6945,39.0015 L111.6945,37.035 L114.2235,37.035 L114.2235,33.993 L116.53875,33.4305 L116.53875,37.0305 L120.04875,37.0305 L120.04875,38.997 L116.55,38.997 L116.55,45.45 C116.55,46.66725 117.04275,47.11275 118.305,47.11275 C118.886878,47.1273258 119.466277,47.0319044 120.01275,46.8315 L120.01275,48.798 C119.292655,49.0220233 118.543837,49.1402578 117.78975,49.149 C115.4745,49.149 114.23475,48.04875 114.23475,45.999 L114.2235,39.0015 Z"
              fill="#000000"
            />
            <path
              d="M122.15475,45.85725 C123.3945,46.8405 124.70625,47.35575 126.03825,47.35575 C127.7235,47.35575 128.8935,46.629 128.8935,45.576 C128.8935,44.7345 128.286,44.24175 126.97425,44.055 L124.82325,43.75125 C122.4585,43.40025 121.275,42.3 121.275,40.45275 C121.275,38.2995 123.147,36.85275 125.93025,36.85275 C127.648195,36.8415428 129.325954,37.3721902 130.725,38.36925 L129.53025,39.91275 C128.22075,39.04875 127.026,38.673 125.76375,38.673 C124.335,38.673 123.3765,39.32775 123.3765,40.2885 C123.3765,41.15475 123.93675,41.5755 125.34075,41.78475 L127.494,42.09075 C129.85875,42.44175 131.094,43.5645 131.094,45.41175 C131.094,47.5425 128.94075,49.158 126.11025,49.158 C124.04925,49.158 122.202,48.54825 120.89025,47.40075 L122.15475,45.85725 Z"
              fill="#000000"
            />
            <path
              d="M28.575,18.675 C31.38975,18.675 35.46225,18.0945 35.46225,14.7465 C35.4706654,14.4881096 35.4472392,14.2296659 35.3925,13.977 L33.71625,6.696 C33.32925,5.094 32.9895,4.36725 30.177,2.961 C27.98775,1.84275 23.2335,0 21.825,0 C20.5155,0 20.12625,1.6965 18.57375,1.6965 C17.07075,1.6965 15.95475,0.4365 14.5485,0.4365 C13.1985,0.4365 12.31875,1.35675 11.63925,3.249 C11.63925,3.249 9.747,8.586 9.504,9.36 C9.46385916,9.50189759 9.44564877,9.64909823 9.45,9.7965 C9.45,11.871 17.62425,18.675 28.575,18.675 M35.89875,16.1055 C36.288,17.94825 36.288,18.14175 36.288,18.38475 C36.288,21.53475 32.7465,23.283 28.09125,23.283 C17.55,23.28075 8.343,17.1225 8.343,13.05 C8.34239181,12.4828126 8.45802021,11.9215171 8.68275,11.40075 C4.89825,11.592 0,12.2715 0,16.587 C0,23.67 16.78275,32.4 30.07125,32.4 C40.25925,32.4 42.82875,27.792 42.82875,24.15375 C42.82875,21.29175 40.35375,18.04275 35.892,16.10325"
              fill="#EE0000"
            />
            <path
              d="M35.892,16.10325 C36.28125,17.946 36.28125,18.1395 36.28125,18.3825 C36.28125,21.5325 32.73975,23.28075 28.0845,23.28075 C17.55,23.28075 8.34299761,17.1225 8.34299761,13.05 C8.34239181,12.4828126 8.45802021,11.9215171 8.68275,11.40075 L9.50625,9.36225 C9.46557648,9.50330773 9.44660928,9.64973447 9.45,9.7965 C9.45,11.871 17.62425,18.675 28.575,18.675 C31.38975,18.675 35.46225,18.0945 35.46225,14.7465 C35.4706654,14.4881096 35.4472392,14.2296659 35.3925,13.977 L35.892,16.10325 Z"
              fill="#000000"
            />
            <path
              d="M130.329,20.7675 C130.329,23.44275 131.93775,24.74325 134.87175,24.74325 C135.775087,24.7207606 136.672795,24.5939187 137.547,24.36525 L137.547,21.26475 C136.988249,21.4418223 136.405122,21.5298988 135.819,21.52575 C134.61075,21.52575 134.163,21.14775 134.163,20.0115 L134.163,15.255 L137.664,15.255 L137.664,12.06 L134.163,12.06 L134.163,8.01 L130.338,8.838 L130.338,12.06 L127.8,12.06 L127.8,15.255 L130.33125,15.255 L130.329,20.7675 Z M118.404,20.8395 C118.404,20.0115 119.23425,19.60875 120.4875,19.60875 C121.253536,19.6132028 122.016349,19.7083656 122.76,19.89225 L122.76,21.501 C122.029149,21.9001512 121.20767,22.1039709 120.375,22.09275 C119.1465,22.09275 118.41075,21.62025 118.41075,20.8395 M119.58075,24.7905 C120.93075,24.7905 122.01975,24.507 123.03675,23.82075 L123.03675,24.579 L126.82125,24.579 L126.82125,16.5555 C126.82125,13.5045 124.76475,11.8305 121.3335,11.8305 C119.4165,11.8305 117.522,12.2805 115.4835,13.203 L116.856,16.02 C118.323,15.4035 119.556,15.0255 120.64275,15.0255 C122.21775,15.0255 123.03225,15.63975 123.03225,16.89525 L123.03225,17.5095 C122.104961,17.2694643 121.150595,17.1499795 120.19275,17.154 C116.973,17.154 115.0335,18.504 115.0335,20.91825 C115.0335,23.11875 116.784,24.79725 119.57625,24.79725 M98.77725,24.58575 L102.8475,24.58575 L102.8475,18.0945 L109.66275,18.0945 L109.66275,24.579 L113.733,24.579 L113.733,8.0145 L109.67175,8.0145 L109.67175,14.37975 L102.8565,14.37975 L102.8565,8.0145 L98.78625,8.0145 L98.77725,24.58575 Z M83.277,18.30825 C83.277,16.50825 84.69675,15.13575 86.5665,15.13575 C87.5407999,15.1148903 88.4871798,15.4619498 89.217,16.10775 L89.217,20.475 C88.5013929,21.1465643 87.5472457,21.504572 86.5665,21.4695 C84.7215,21.4695 83.277,20.097 83.277,18.29925 M89.26425,24.57 L93.051,24.57 L93.051,7.1865 L89.226,8.0145 L89.226,12.72375 C88.2522856,12.1717322 87.1502635,11.8861378 86.031,11.89575 C82.38825,11.89575 79.524,14.7105 79.524,18.30825 C79.5010519,20.0130972 80.1639908,21.6556876 81.3638838,22.867004 C82.5637767,24.0783205 84.2000119,24.7567934 85.905,24.7500643 C87.1120686,24.7557569 88.2892756,24.374919 89.26425,23.66325 L89.26425,24.57 Z M71.8965,14.9625 C73.1025,14.9625 74.1195,15.74325 74.52225,16.94925 L69.3,16.94925 C69.678,15.696 70.62525,14.9625 71.90325,14.9625 M65.43675,18.33075 C65.43675,21.97575 68.418,24.81525 72.24975,24.81525 C74.35575,24.81525 75.89475,24.246 77.481,22.92075 L74.9475,20.67075 C74.35575,21.28725 73.4805,21.618 72.441,21.618 C71.1029548,21.6556867 69.8796675,20.866094 69.363,19.63125 L78.28425,19.63125 L78.28425,18.68625 C78.28425,14.7105 75.61125,11.8485 71.96625,11.8485 C70.2352666,11.8223817 68.5669176,12.495545 67.3387715,13.7156446 C66.1106255,14.9357441 65.4265103,16.5996324 65.44125,18.33075 M58.83525,11.493 C60.18525,11.493 60.94125,12.3435 60.94125,13.36275 C60.94125,14.382 60.183,15.2325 58.83525,15.2325 L54.81225,15.2325 L54.81225,11.493 L58.83525,11.493 Z M50.73525,24.579 L54.8055,24.579 L54.8055,18.5445 L57.90375,18.5445 L61.029,24.579 L65.57175,24.579 L61.92675,17.95275 C63.8218627,17.1820151 65.0580914,15.3365787 65.04975,13.29075 C65.04975,10.3095 62.7075,8.0145 59.19975,8.0145 L50.742,8.0145 L50.73525,24.579 Z"
              fill="#000000"
            />
          </g>
        </g>
      </svg>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="utf-8"?>
      <!-- Generator: Adobe Illustrator 23.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
      <svg
        version="1.1"
        width="6.65em"
        height="1em"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
        x="0px"
        y="0px"
        viewBox="0 0 1616.7 243.1"
        style="enable-background:new 0 0 1616.7 243.1;"
        xml:space="preserve"
      >
        <style type="text/css">
  .st0 {
    fill: #ee0000;
  }
        </style>
        <title>Logo-Red_Hat-OpenShift_Container_Platform-A-Standard-RGB</title>
        <path
          d="M263.4,220.7c-21.2,0-37.9-16.5-37.9-37.5s16.6-37.6,37.9-37.6s38,16.5,38,37.6S284.6,220.7,263.4,220.7z M263.4,155.7
            	c-15.1,0-26.7,11.9-26.7,27.5s11.6,27.4,26.7,27.4c15.1,0,26.8-12,26.8-27.4S278.6,155.7,263.4,155.7z"
        />
        <path
          d="M311.8,166.6H322v5.1c4.5-3.9,10.3-6,16.2-5.9c15,0,26.7,12,26.7,27.2s-11.8,27.4-26.9,27.4c-5.7,0-11.3-1.8-15.9-5.2v25.9
            	h-10.4L311.8,166.6z M322.1,181.2v23.9c3.3,3.9,8.8,6.2,14.8,6.2c10.2,0,17.9-7.8,17.9-18.2s-7.8-18.3-17.9-18.3
            	C330.9,174.8,325.6,177.1,322.1,181.2z"
        />
        <path
          d="M400.5,220.5c-15.6,0-27.8-12-27.8-27.5c0-15.3,11.6-27.2,26.5-27.2c14.6,0,25.6,12.1,25.6,27.7v3H383
            	c1.3,8.8,9,15.3,17.9,15.2c4.9,0.1,9.6-1.5,13.4-4.6l6.7,6.6C415.1,218.2,407.9,220.7,400.5,220.5z M383.1,188.6h31.4
            	c-1.6-8.1-7.8-14.1-15.5-14.1C391,174.5,384.6,180.2,383.1,188.6z"
        />
        <path
          d="M434.7,166.6h10.4v5.3c4.2-4.2,10-6.5,15.9-6.4c12.2,0,20.7,8.4,20.7,20.7v33.3h-10.4V188c0-8.3-5.1-13.4-13.1-13.4
            	c-5.3-0.2-10.3,2.4-13.1,6.9v38.1h-10.4L434.7,166.6z"
        />
        <path
          d="M495,199.8c7.9,7.7,16,11.4,25.1,11.4c10.5,0,17.7-5,17.7-12.2c0-6.4-4.2-9.7-14.8-11.4l-12.2-2
            	c-13.3-2.2-19.9-8.4-19.9-18.9c0-12.7,10.6-20.9,26.8-20.9c10.6,0,20.9,3.5,29.3,9.9l-6,8.3c-7.9-6-15.7-8.9-23.8-8.9
            	c-9.5,0-15.8,4.4-15.8,10.8c0,5.9,3.6,8.7,13,10.3l11.7,1.8c15.4,2.5,22.4,8.8,22.4,20.2c0,13.4-11.7,22.4-29,22.4
            	c-11.7,0-23-4.7-31.2-13.1L495,199.8z"
        />
        <path
          d="M557.4,146.7l10.4-2.3v27.5c4.2-4.2,10-6.5,15.9-6.4c12.2,0,20.7,8.4,20.7,20.7v33.3H594V188c0-8.3-5.1-13.4-13.1-13.4
            	c-5.3-0.2-10.2,2.4-13.1,6.9v38.1h-10.4V146.7z"
        />
        <path
          d="M615.2,151.6c0-3.5,2.8-6.4,6.3-6.4c0,0,0,0,0,0c3.6-0.1,6.6,2.6,6.7,6.2c0.1,3.6-2.6,6.6-6.2,6.7c-0.2,0-0.3,0-0.5,0
            	C618,158,615.2,155.2,615.2,151.6C615.2,151.6,615.2,151.6,615.2,151.6z M626.8,219.5h-10.4v-52.9h10.4V219.5z"
        />
        <path
          d="M646.9,166.6v-8c0-11,6.3-17.1,18-17.1c2.5,0,5,0.3,7.5,0.9v9.1c-2.1-0.7-4.3-1-6.5-0.9c-5.7,0-8.5,2.6-8.5,8.2v7.8h15.1
            	v8.7h-15.1v44.2h-10.4v-44.2h-12.3v-8.8H646.9z"
        />
        <path
          d="M688.2,175.3H677v-8.7h11.2v-13.5l10.3-2.5v16h15.6v8.7h-15.6V204c0,5.4,2.2,7.4,7.8,7.4c2.6,0.1,5.2-0.4,7.6-1.2v8.7
            	c-3.2,1-6.5,1.5-9.9,1.6c-10.3,0-15.8-4.9-15.8-14L688.2,175.3z"
        />
        <path
          d="M803.1,203.3l5.2,5.4c-7.5,7.7-17.8,12.1-28.6,12c-20.7,0.3-37.8-16.2-38.2-36.9s16.2-37.8,36.9-38.2c0.4,0,0.8,0,1.2,0
            	c11.3,0,21.7,4.4,28.8,12l-5.3,5.6c-6-6.6-14.6-10.3-23.5-10.2c-16.8,0-29.6,13.1-29.6,30.2s12.9,30.1,29.9,30.1
            	C789,213.3,797.6,209.6,803.1,203.3z"
        />
        <path
          d="M841.2,166.4c14.8,0,26.5,11.9,26.5,27s-11.7,27.2-26.5,27.2s-26.6-11.9-26.6-27.1S826.3,166.4,841.2,166.4z M860.1,193.4
            	c0-11.3-8.3-20.2-18.9-20.2s-19,8.8-19,20.2s8.3,20.3,19,20.3S860.1,204.8,860.1,193.4L860.1,193.4z"
        />
        <path
          d="M878.4,167.4h7.7v6.1c4-4.8,9.7-7.2,16.4-7.2c11.9,0,20.1,8.2,20.1,20.2v33H915v-31.4c0-9.3-5.6-15-14.6-15
            	c-5.9-0.1-11.4,2.9-14.3,8v38.4h-7.7L878.4,167.4z"
        />
        <path
          d="M939.9,174h-11.2v-6.6h11.2v-13.2l7.6-2v15.2h15.7v6.6h-15.7v31.9c0,5.6,2.3,7.8,8,7.8c2.6,0.1,5.2-0.4,7.6-1.4v6.8
            	c-3,0.9-6,1.4-9.2,1.4c-9,0-14-4.4-14-12.6L939.9,174z"
        />
        <path
          d="M968.6,204.8c0-9.8,8-15.9,20.8-15.9c5.3,0,10.5,1.2,15.3,3.5v-6.9c0-8.3-4.8-12.6-13.8-12.6c-5.1,0-10.1,1.4-16.3,4.6
            	l-2.9-5.9c7.5-3.6,13.6-5.2,20-5.2c13.2,0,20.6,6.4,20.6,18.1v35h-7.5v-5.1c-4.7,4-10.7,6.2-16.8,6
            	C976.4,220.5,968.6,214.1,968.6,204.8z M989.2,214.4c6.2,0,11.3-1.9,15.5-6v-9.8c-4.3-2.9-9-4.2-15.1-4.2c-8.3,0-13.6,4-13.6,10.1
            	C976,210.4,981.4,214.4,989.2,214.4z"
        />
        <path
          d="M1023.7,152.2c0-2.9,2.3-5.2,5.2-5.2c2.8,0,5.2,2.3,5.2,5.1c0,0,0,0.1,0,0.1c0,2.9-2.3,5.2-5.2,5.2
            	C1026.1,157.4,1023.8,155.1,1023.7,152.2z M1032.7,219.5h-7.7v-52.1h7.7V219.5z"
        />
        <path
          d="M1045.9,167.4h7.7v6.1c4-4.8,9.7-7.2,16.4-7.2c11.8,0,20.1,8.2,20.1,20.2v33h-7.6v-31.4c0-9.3-5.6-15-14.6-15
            	c-5.9-0.1-11.4,2.9-14.3,8v38.4h-7.7V167.4z"
        />
        <path
          d="M1127.4,220.5c-14.7,0.2-26.7-11.6-26.8-26.3c0-0.2,0-0.5,0-0.7c0-15,11.3-26.8,25.7-26.8c13.8,0,24.7,11.9,24.7,26.8v2.4
            	h-42.7c1.1,10.3,9.2,17.9,19.6,17.9c5.4,0,10.8-1.8,14.3-4.8l4.8,5.1C1141.3,218.4,1134.4,220.6,1127.4,220.5z M1108.4,189.7h34.8
            	c-1.3-9.3-8.5-16.3-17.2-16.3C1117,173.4,1109.8,180.1,1108.4,189.7L1108.4,189.7z"
        />
        <path
          d="M1161.6,167.4h7.7v7.4c2.9-5.3,8.5-8.6,14.6-8.5c1.7,0,3.3,0.2,4.9,0.7v7.1c-1.7-0.6-3.6-0.9-5.4-0.9
            	c-6.4,0-11.3,3.8-14,10.7v35.7h-7.7L1161.6,167.4z"
        />
        <path
          d="M1221.4,146.7h31.6c14.2,0,23.5,8.3,23.5,21s-9.4,21.1-23.5,21.1h-23.6v30.7h-8L1221.4,146.7z M1229.4,153.9v28h23
            	c9.9,0,16.1-5.4,16.1-14s-6.2-13.9-16.1-13.9L1229.4,153.9z"
        />
        <path d="M1295,219.5h-7.7v-72.8l7.7-1.7V219.5z" />
        <path
          d="M1305.2,204.8c0-9.8,8-15.9,20.8-15.9c5.3,0,10.5,1.2,15.3,3.5v-6.9c0-8.3-4.8-12.6-13.8-12.6c-5.1,0-10.1,1.4-16.3,4.6
            	l-2.9-5.9c7.5-3.6,13.6-5.2,20-5.2c13.2,0,20.6,6.4,20.6,18.1v35h-7.5v-5.1c-4.7,4-10.7,6.2-16.8,6
            	C1313,220.5,1305.2,214.1,1305.2,204.8z M1325.8,214.4c6.2,0,11.3-1.9,15.5-6v-9.8c-4.3-2.9-9-4.2-15.1-4.2c-8.3,0-13.6,4-13.6,10.1
            	C1312.6,210.4,1318,214.4,1325.8,214.4z"
        />
        <path
          d="M1366.1,174h-11.2v-6.6h11.2v-13.2l7.6-2v15.2h15.7v6.6h-15.7v31.9c0,5.6,2.3,7.8,8,7.8c2.6,0.1,5.2-0.4,7.6-1.4v6.8
            	c-3,0.9-6,1.4-9.2,1.4c-9,0-14-4.4-14-12.6L1366.1,174z"
        />
        <path
          d="M1406.1,167.4v-9.9c0-10.2,5.7-15.8,16.1-15.8c2.4-0.1,4.7,0.2,7,0.9v6.9c-2.1-0.7-4.3-1-6.4-1c-6.1,0-9,2.9-9,9.3v9.7h15.5
            	v6.5h-15.5v45.6h-7.6V174h-12.3v-6.6L1406.1,167.4z"
        />
        <path
          d="M1459.1,166.4c14.8,0,26.5,11.9,26.5,27s-11.8,27.1-26.5,27.1s-26.6-11.9-26.6-27.1S1444.2,166.4,1459.1,166.4z M1478,193.4
            	c0-11.3-8.3-20.2-18.9-20.2s-19,8.8-19,20.2s8.3,20.3,19,20.3S1478,204.8,1478,193.4L1478,193.4z"
        />
        <path
          d="M1496.3,167.4h7.7v7.4c2.9-5.3,8.5-8.6,14.6-8.5c1.7,0,3.3,0.2,4.9,0.7v7.1c-1.7-0.6-3.6-0.9-5.4-0.9
            	c-6.4,0-11.3,3.8-14,10.7v35.7h-7.7L1496.3,167.4z"
        />
        <path
          d="M1532.3,167.4h7.7v5.7c3.8-4.4,9.4-6.9,15.3-6.8c6.8-0.2,13.1,3.5,16.4,9.5c3.9-6.1,10.7-9.7,17.9-9.5
            	c11.3,0,19.1,8.2,19.1,20.2v33h-7.6v-31.4c0-9.3-5.2-15-13.5-15c-5.7,0-10.5,2.9-13.8,8.5c0.3,1.6,0.5,3.2,0.5,4.9v33h-7.6v-31.4
            	c0-9.3-5.2-15-13.4-15c-5.6,0-10.1,2.6-13.3,7.6v38.8h-7.7L1532.3,167.4z"
        />
        <path
          class="st0"
          d="M129,85c12.5,0,30.6-2.6,30.6-17.5c0-1.1-0.1-2.3-0.3-3.4l-7.4-32.4c-1.7-7.1-3.2-10.4-15.7-16.6
            	C126.4,10.2,105.3,2,99,2c-5.8,0-7.6,7.5-14.4,7.5c-6.7,0-11.6-5.6-17.9-5.6c-6,0-9.9,4.1-12.9,12.5c0,0-8.4,23.7-9.5,27.2
            	c-0.2,0.6-0.3,1.3-0.2,1.9C44,54.8,80.3,85,129,85 M161.6,73.6c1.7,8.2,1.7,9.1,1.7,10.1c0,14-15.7,21.8-36.4,21.8
            	C80,105.5,39.1,78.1,39.1,60c0-2.5,0.5-5,1.5-7.3C23.8,53.5,2,56.5,2,75.7C2,107.2,76.6,146,135.6,146c45.3,0,56.7-20.5,56.7-36.7
            	C192.3,96.6,181.3,82.2,161.6,73.6"
        />
        <path
          d="M161.5,73.6c1.7,8.2,1.7,9.1,1.7,10.1c0,14-15.7,21.8-36.4,21.8C80,105.5,39.1,78.1,39.1,60c0-2.5,0.5-5,1.5-7.3l3.7-9.1
            	c-0.2,0.6-0.3,1.3-0.2,1.9C44,54.8,80.3,85,129,85c12.5,0,30.6-2.6,30.6-17.5c0-1.1-0.1-2.3-0.3-3.4L161.5,73.6z"
        />
        <path
          d="M581.2,94.3c0,11.9,7.2,17.7,20.2,17.7c4-0.1,8-0.7,11.9-1.7V96.5c-2.5,0.8-5.1,1.2-7.7,1.2c-5.4,0-7.4-1.7-7.4-6.7V69.8
            	h15.6V55.6h-15.6v-18l-17,3.7v14.3H570v14.2h11.2L581.2,94.3z M528.2,94.6c0-3.7,3.7-5.5,9.3-5.5c3.4,0,6.8,0.4,10.1,1.3v7.2
            	c-3.2,1.8-6.9,2.7-10.6,2.6C531.5,100.2,528.3,98.1,528.2,94.6 M533.5,112.2c6,0,10.8-1.3,15.4-4.3v3.4h16.8V75.6
            	c0-13.6-9.1-21-24.4-21c-8.5,0-16.9,2-26,6.1l6.1,12.5c6.5-2.7,12-4.4,16.8-4.4c7,0,10.6,2.7,10.6,8.3v2.7
            	c-4.1-1.1-8.4-1.6-12.6-1.6c-14.3,0-22.9,6-22.9,16.7C513.3,104.8,521,112.2,533.5,112.2 M441,111.3h18.1V82.4h30.3v28.8h18.1V37.6
            	h-18.1v28.3h-30.3V37.6H441L441,111.3z M372.1,83.4c0-8,6.3-14.1,14.6-14.1c4.3-0.1,8.5,1.4,11.8,4.3V93c-3.2,3-7.4,4.6-11.8,4.4
            	C378.5,97.4,372.1,91.3,372.1,83.4 M398.7,111.2h16.8V33.9l-17,3.7v20.9c-4.3-2.5-9.2-3.7-14.2-3.7c-16.2,0-28.9,12.5-28.9,28.5
            	c-0.2,15.6,12.3,28.4,27.9,28.6c0.2,0,0.3,0,0.5,0c5.4,0,10.6-1.7,14.9-4.8V111.2z M321.5,68.5c5.4,0,9.9,3.5,11.7,8.8H310
            	C311.7,71.8,315.9,68.5,321.5,68.5 M292.8,83.5c0,16.2,13.2,28.8,30.3,28.8c9.4,0,16.2-2.5,23.2-8.4l-11.3-10
            	c-2.6,2.7-6.5,4.2-11.1,4.2c-5.9,0.2-11.4-3.3-13.7-8.8h39.6v-4.2c0-17.7-11.9-30.4-28.1-30.4c-15.8-0.2-28.8,12.4-29,28.1
            	C292.8,83,292.8,83.2,292.8,83.5 M263.5,53.1c6,0,9.4,3.8,9.4,8.3s-3.4,8.3-9.4,8.3h-17.9V53.1H263.5z M227.5,111.2h18.1V84.4h13.8
            	l13.9,26.8h20.2l-16.2-29.5c8.4-3.4,13.9-11.6,13.9-20.7c0-13.2-10.4-23.5-26-23.5h-37.6L227.5,111.2z"
        />
      </svg>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>

```

### Stacked tiles large

```html
<div class="pf-c-tile pf-m-display-lg" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <i class="fas fa-bell" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-selected pf-m-display-lg" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <i class="fas fa-bell" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Selected</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-disabled pf-m-display-lg" tabindex="-1">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <i class="fas fa-bell" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Disabled</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<br />
<br />

<div class="pf-c-tile pf-m-display-lg" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="UTF-8"?>
      <svg
        width="1.1em"
        height="1em"
        viewBox="0 0 30 27"
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
      >
        <!-- Generator: Sketch 54 (76480) - https://sketchapp.com -->
        <title>Group 12</title>
        <desc>Created with Sketch.</desc>
        <g stroke="none" stroke-width="1" fill="none">
          <g transform="translate(-351.000000, -422.000000)" fill="#000000">
            <g transform="translate(322.000000, 395.000000)">
              <g transform="translate(29.000000, 27.000000)">
                <g>
                  <path
                    d="M29.3047523,13.6067281 L14.8028311,0.0924998513 L14.6960566,0 L14.5601618,0.0924998513 L0.0873609707,13.6067281 L0,13.689978 L0.0679474216,13.7824778 L5.82406471,21.5709653 L5.88230536,21.6449652 L5.9793731,21.6449652 L10.2794742,20.7199667 L14.5601618,26.4364575 L14.6766431,26.5937073 L14.7931244,26.4364575 L19.0932255,20.6829668 L23.3836198,21.6079653 L23.4806876,21.6079653 L23.5389282,21.5339654 L29.3047523,13.7454779 L29.3726997,13.6529781 L29.3047523,13.6067281 Z M20.9957533,15.1699756 L21.5005056,16.2522239 L18.7826087,19.878218 L17.5789687,19.6192185 L20.9957533,15.1699756 Z M21.1607685,13.7454779 L16.0841254,2.77499554 L23.2186047,11.0999822 L21.1607685,13.7454779 Z M22.3255814,16.4002236 L22.3741153,16.3354737 L22.3741153,16.2614739 L21.5587462,14.5039767 L24.1116279,11.0999822 L24.1698686,11.0999822 L24.1019211,11.0167323 L18.9573306,5.01349194 L28.411729,13.8194778 L26.4703741,16.4002236 L23.1506572,20.8864664 L19.5494439,20.1002177 L22.3255814,16.4002236 Z M12.269363,20.2482175 L14.6669363,23.3747124 L14.7931244,23.5412122 L14.9096057,23.3747124 L17.1227503,20.2482175 L18.3166835,20.516467 L14.6960566,25.3634592 L11.0754297,20.516467 L12.269363,20.2482175 Z M12.871183,19.8227181 L14.6960566,2.88599536 L16.5015167,19.8227181 L14.7542973,22.2924642 L12.871183,19.8227181 Z M13.8418605,3.34849462 L12.1237614,18.8144698 L8.73609707,14.4207268 L13.8418605,3.34849462 Z M6.17350859,11.0999822 L13.3176946,2.77499554 L8.23134479,13.7454779 L6.17350859,11.0999822 Z M10.4347826,4.99499197 L5.29019211,10.9982323 L5.22224469,11.0999822 L5.29019211,11.183232 L7.88190091,14.5502266 L7.06653185,16.3077238 L7.06653185,16.3817237 L7.06653185,16.4464736 L9.79413549,20.1002177 L6.20262892,20.8864664 L0.970677452,13.7732279 L10.4347826,4.99499197 Z M11.8131446,19.6469684 L10.6095046,19.905968 L7.90131446,16.2522239 L8.39635996,15.1699756 L11.8131446,19.6469684 Z M15.5308392,3.34849462 L20.6463094,14.4484768 L17.2683519,18.8422197 L15.5308392,3.34849462 Z"
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-display-lg pf-m-selected" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="UTF-8"?>
      <svg
        width="1.1em"
        height="1em"
        viewBox="0 0 30 27"
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
      >
        <!-- Generator: Sketch 54 (76480) - https://sketchapp.com -->
        <title>Group 12</title>
        <desc>Created with Sketch.</desc>
        <g stroke="none" stroke-width="1" fill="none">
          <g transform="translate(-351.000000, -422.000000)" fill="#000000">
            <g transform="translate(322.000000, 395.000000)">
              <g transform="translate(29.000000, 27.000000)">
                <g>
                  <path
                    d="M29.3047523,13.6067281 L14.8028311,0.0924998513 L14.6960566,0 L14.5601618,0.0924998513 L0.0873609707,13.6067281 L0,13.689978 L0.0679474216,13.7824778 L5.82406471,21.5709653 L5.88230536,21.6449652 L5.9793731,21.6449652 L10.2794742,20.7199667 L14.5601618,26.4364575 L14.6766431,26.5937073 L14.7931244,26.4364575 L19.0932255,20.6829668 L23.3836198,21.6079653 L23.4806876,21.6079653 L23.5389282,21.5339654 L29.3047523,13.7454779 L29.3726997,13.6529781 L29.3047523,13.6067281 Z M20.9957533,15.1699756 L21.5005056,16.2522239 L18.7826087,19.878218 L17.5789687,19.6192185 L20.9957533,15.1699756 Z M21.1607685,13.7454779 L16.0841254,2.77499554 L23.2186047,11.0999822 L21.1607685,13.7454779 Z M22.3255814,16.4002236 L22.3741153,16.3354737 L22.3741153,16.2614739 L21.5587462,14.5039767 L24.1116279,11.0999822 L24.1698686,11.0999822 L24.1019211,11.0167323 L18.9573306,5.01349194 L28.411729,13.8194778 L26.4703741,16.4002236 L23.1506572,20.8864664 L19.5494439,20.1002177 L22.3255814,16.4002236 Z M12.269363,20.2482175 L14.6669363,23.3747124 L14.7931244,23.5412122 L14.9096057,23.3747124 L17.1227503,20.2482175 L18.3166835,20.516467 L14.6960566,25.3634592 L11.0754297,20.516467 L12.269363,20.2482175 Z M12.871183,19.8227181 L14.6960566,2.88599536 L16.5015167,19.8227181 L14.7542973,22.2924642 L12.871183,19.8227181 Z M13.8418605,3.34849462 L12.1237614,18.8144698 L8.73609707,14.4207268 L13.8418605,3.34849462 Z M6.17350859,11.0999822 L13.3176946,2.77499554 L8.23134479,13.7454779 L6.17350859,11.0999822 Z M10.4347826,4.99499197 L5.29019211,10.9982323 L5.22224469,11.0999822 L5.29019211,11.183232 L7.88190091,14.5502266 L7.06653185,16.3077238 L7.06653185,16.3817237 L7.06653185,16.4464736 L9.79413549,20.1002177 L6.20262892,20.8864664 L0.970677452,13.7732279 L10.4347826,4.99499197 Z M11.8131446,19.6469684 L10.6095046,19.905968 L7.90131446,16.2522239 L8.39635996,15.1699756 L11.8131446,19.6469684 Z M15.5308392,3.34849462 L20.6463094,14.4484768 L17.2683519,18.8422197 L15.5308392,3.34849462 Z"
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    </div>
    <div class="pf-c-tile__title">Selected</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-disabled pf-m-display-lg" tabindex="-1">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="UTF-8"?>
      <svg
        width="1.1em"
        height="1em"
        viewBox="0 0 30 27"
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
      >
        <!-- Generator: Sketch 54 (76480) - https://sketchapp.com -->
        <title>Group 12</title>
        <desc>Created with Sketch.</desc>
        <g stroke="none" stroke-width="1" fill="none">
          <g transform="translate(-351.000000, -422.000000)" fill="#000000">
            <g transform="translate(322.000000, 395.000000)">
              <g transform="translate(29.000000, 27.000000)">
                <g>
                  <path
                    d="M29.3047523,13.6067281 L14.8028311,0.0924998513 L14.6960566,0 L14.5601618,0.0924998513 L0.0873609707,13.6067281 L0,13.689978 L0.0679474216,13.7824778 L5.82406471,21.5709653 L5.88230536,21.6449652 L5.9793731,21.6449652 L10.2794742,20.7199667 L14.5601618,26.4364575 L14.6766431,26.5937073 L14.7931244,26.4364575 L19.0932255,20.6829668 L23.3836198,21.6079653 L23.4806876,21.6079653 L23.5389282,21.5339654 L29.3047523,13.7454779 L29.3726997,13.6529781 L29.3047523,13.6067281 Z M20.9957533,15.1699756 L21.5005056,16.2522239 L18.7826087,19.878218 L17.5789687,19.6192185 L20.9957533,15.1699756 Z M21.1607685,13.7454779 L16.0841254,2.77499554 L23.2186047,11.0999822 L21.1607685,13.7454779 Z M22.3255814,16.4002236 L22.3741153,16.3354737 L22.3741153,16.2614739 L21.5587462,14.5039767 L24.1116279,11.0999822 L24.1698686,11.0999822 L24.1019211,11.0167323 L18.9573306,5.01349194 L28.411729,13.8194778 L26.4703741,16.4002236 L23.1506572,20.8864664 L19.5494439,20.1002177 L22.3255814,16.4002236 Z M12.269363,20.2482175 L14.6669363,23.3747124 L14.7931244,23.5412122 L14.9096057,23.3747124 L17.1227503,20.2482175 L18.3166835,20.516467 L14.6960566,25.3634592 L11.0754297,20.516467 L12.269363,20.2482175 Z M12.871183,19.8227181 L14.6960566,2.88599536 L16.5015167,19.8227181 L14.7542973,22.2924642 L12.871183,19.8227181 Z M13.8418605,3.34849462 L12.1237614,18.8144698 L8.73609707,14.4207268 L13.8418605,3.34849462 Z M6.17350859,11.0999822 L13.3176946,2.77499554 L8.23134479,13.7454779 L6.17350859,11.0999822 Z M10.4347826,4.99499197 L5.29019211,10.9982323 L5.22224469,11.0999822 L5.29019211,11.183232 L7.88190091,14.5502266 L7.06653185,16.3077238 L7.06653185,16.3817237 L7.06653185,16.4464736 L9.79413549,20.1002177 L6.20262892,20.8864664 L0.970677452,13.7732279 L10.4347826,4.99499197 Z M11.8131446,19.6469684 L10.6095046,19.905968 L7.90131446,16.2522239 L8.39635996,15.1699756 L11.8131446,19.6469684 Z M15.5308392,3.34849462 L20.6463094,14.4484768 L17.2683519,18.8422197 L15.5308392,3.34849462 Z"
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    </div>
    <div class="pf-c-tile__title">Disabled</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<br />
<br />

<div class="pf-c-tile pf-m-display-lg" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="UTF-8"?>
      <svg
        width="2.59em"
        height="1em"
        viewBox="0 0 140 54"
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
      >
        <title>Logo-Red_Hat-Insights-A-Standard-RGB</title>
        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
          <g fill-rule="nonzero">
            <polygon
              fill="#000000"
              points="50.99625 32.5665 53.45325 32.5665 53.45325 48.9465 50.99625 48.9465"
            />
            <path
              d="M56.51775,37.035 L58.85775,37.035 L58.85775,38.22975 C59.8067449,37.2846364 61.1008052,36.7684754 62.43975,36.801 C65.17575,36.801 67.095,38.69775 67.095,41.4585 L67.095,48.9465 L64.755,48.9465 L64.755,41.85 C64.755,39.978 63.60975,38.8305 61.8075,38.8305 C60.6212439,38.7905177 59.5011836,39.3766057 58.85775,40.374 L58.85775,48.93975 L56.51775,48.93975 L56.51775,37.035 Z"
              fill="#000000"
            />
            <path
              d="M69.9255,45.85725 C71.1675,46.8405 72.477,47.35575 73.81125,47.35575 C75.4965,47.35575 76.6665,46.629 76.6665,45.576 C76.6665,44.7345 76.05675,44.24175 74.74725,44.055 L72.594,43.75125 C70.2315,43.40025 69.03675,42.3 69.03675,40.45275 C69.03675,38.2995 70.90875,36.85275 73.69425,36.85275 C75.4135277,36.8419204 77.0923292,37.3742233 78.49125,38.37375 L77.29875,39.91725 C75.987,39.05325 74.7945,38.6775 73.53,38.6775 C72.1035,38.6775 71.14275,39.33225 71.14275,40.293 C71.14275,41.15925 71.70525,41.58 73.10925,41.78925 L75.2625,42.09525 C77.625,42.44625 78.8625,43.569 78.8625,45.41625 C78.8625,47.547 76.7115,49.1625 73.87875,49.1625 C71.82,49.1625 69.9705,48.55275 68.661,47.40525 L69.9255,45.85725 Z"
              fill="#000000"
            />
            <path
              d="M80.4105,33.6645 C80.4069047,33.283003 80.5553213,32.9157674 80.8229733,32.6438937 C81.0906253,32.3720201 81.4554935,32.217875 81.837,32.2155 C82.3687044,32.194552 82.8692347,32.4662713 83.1413188,32.9235662 C83.4134029,33.3808611 83.4134029,33.9503889 83.1413188,34.4076838 C82.8692347,34.8649787 82.3687044,35.136698 81.837,35.11575 C81.4552881,35.1127801 81.0904257,34.958136 80.8228378,34.6859054 C80.5552498,34.4136748 80.4069042,34.0462065 80.4105,33.6645 L80.4105,33.6645 Z M83.007,48.9465 L80.667,48.9465 L80.667,37.035 L83.007,37.035 L83.007,48.9465 Z"
              fill="#000000"
            />
            <path
              d="M85.23,42.93225 C85.2033544,41.3167935 85.8285349,39.7586992 86.9644096,38.6097003 C88.1002842,37.4607015 89.651094,36.8176637 91.26675,36.8256746 C92.5435648,36.8268531 93.7849591,37.2456558 94.8015,38.01825 L94.8015,37.035 L97.11675,37.035 L97.11675,49.11075 C97.11675,52.2 95.175,53.93025 91.665,53.93025 C89.9937961,53.9434018 88.3454783,53.5413731 86.868,52.76025 L87.7815,50.9355 C89.1315,51.6375 90.33075,51.966 91.59525,51.966 C93.6765,51.966 94.77675,50.98275 94.77675,49.11075 L94.77675,47.7765 C93.7744176,48.6004219 92.5170042,49.0505775 91.2195,49.05 C87.87375,49.05 85.23,46.35 85.23,42.93225 Z M91.50075,47.00475 C92.85075,47.00475 94.005,46.512 94.77675,45.62325 L94.77675,40.24125 C93.9355396,39.3292017 92.7410291,38.8254726 91.50075,38.85975 C89.25075,38.85975 87.52275,40.6395 87.52275,42.93225 C87.52275,45.225 89.25525,47.00475 91.50075,47.00475 Z"
              fill="#000000"
            />
            <path
              d="M99.8775,32.5665 L102.2175,32.05125 L102.2175,38.22975 C103.166495,37.2846364 104.460555,36.7684754 105.7995,36.801 C108.5355,36.801 110.45475,38.69775 110.45475,41.4585 L110.45475,48.9465 L108.11475,48.9465 L108.11475,41.85 C108.11475,39.978 106.9695,38.8305 105.16725,38.8305 C103.980994,38.7905177 102.860934,39.3766057 102.2175,40.374 L102.2175,48.93975 L99.8775,48.93975 L99.8775,32.5665 Z"
              fill="#000000"
            />
            <path
              d="M114.2235,39.0015 L111.6945,39.0015 L111.6945,37.035 L114.2235,37.035 L114.2235,33.993 L116.53875,33.4305 L116.53875,37.0305 L120.04875,37.0305 L120.04875,38.997 L116.55,38.997 L116.55,45.45 C116.55,46.66725 117.04275,47.11275 118.305,47.11275 C118.886878,47.1273258 119.466277,47.0319044 120.01275,46.8315 L120.01275,48.798 C119.292655,49.0220233 118.543837,49.1402578 117.78975,49.149 C115.4745,49.149 114.23475,48.04875 114.23475,45.999 L114.2235,39.0015 Z"
              fill="#000000"
            />
            <path
              d="M122.15475,45.85725 C123.3945,46.8405 124.70625,47.35575 126.03825,47.35575 C127.7235,47.35575 128.8935,46.629 128.8935,45.576 C128.8935,44.7345 128.286,44.24175 126.97425,44.055 L124.82325,43.75125 C122.4585,43.40025 121.275,42.3 121.275,40.45275 C121.275,38.2995 123.147,36.85275 125.93025,36.85275 C127.648195,36.8415428 129.325954,37.3721902 130.725,38.36925 L129.53025,39.91275 C128.22075,39.04875 127.026,38.673 125.76375,38.673 C124.335,38.673 123.3765,39.32775 123.3765,40.2885 C123.3765,41.15475 123.93675,41.5755 125.34075,41.78475 L127.494,42.09075 C129.85875,42.44175 131.094,43.5645 131.094,45.41175 C131.094,47.5425 128.94075,49.158 126.11025,49.158 C124.04925,49.158 122.202,48.54825 120.89025,47.40075 L122.15475,45.85725 Z"
              fill="#000000"
            />
            <path
              d="M28.575,18.675 C31.38975,18.675 35.46225,18.0945 35.46225,14.7465 C35.4706654,14.4881096 35.4472392,14.2296659 35.3925,13.977 L33.71625,6.696 C33.32925,5.094 32.9895,4.36725 30.177,2.961 C27.98775,1.84275 23.2335,0 21.825,0 C20.5155,0 20.12625,1.6965 18.57375,1.6965 C17.07075,1.6965 15.95475,0.4365 14.5485,0.4365 C13.1985,0.4365 12.31875,1.35675 11.63925,3.249 C11.63925,3.249 9.747,8.586 9.504,9.36 C9.46385916,9.50189759 9.44564877,9.64909823 9.45,9.7965 C9.45,11.871 17.62425,18.675 28.575,18.675 M35.89875,16.1055 C36.288,17.94825 36.288,18.14175 36.288,18.38475 C36.288,21.53475 32.7465,23.283 28.09125,23.283 C17.55,23.28075 8.343,17.1225 8.343,13.05 C8.34239181,12.4828126 8.45802021,11.9215171 8.68275,11.40075 C4.89825,11.592 0,12.2715 0,16.587 C0,23.67 16.78275,32.4 30.07125,32.4 C40.25925,32.4 42.82875,27.792 42.82875,24.15375 C42.82875,21.29175 40.35375,18.04275 35.892,16.10325"
              fill="#EE0000"
            />
            <path
              d="M35.892,16.10325 C36.28125,17.946 36.28125,18.1395 36.28125,18.3825 C36.28125,21.5325 32.73975,23.28075 28.0845,23.28075 C17.55,23.28075 8.34299761,17.1225 8.34299761,13.05 C8.34239181,12.4828126 8.45802021,11.9215171 8.68275,11.40075 L9.50625,9.36225 C9.46557648,9.50330773 9.44660928,9.64973447 9.45,9.7965 C9.45,11.871 17.62425,18.675 28.575,18.675 C31.38975,18.675 35.46225,18.0945 35.46225,14.7465 C35.4706654,14.4881096 35.4472392,14.2296659 35.3925,13.977 L35.892,16.10325 Z"
              fill="#000000"
            />
            <path
              d="M130.329,20.7675 C130.329,23.44275 131.93775,24.74325 134.87175,24.74325 C135.775087,24.7207606 136.672795,24.5939187 137.547,24.36525 L137.547,21.26475 C136.988249,21.4418223 136.405122,21.5298988 135.819,21.52575 C134.61075,21.52575 134.163,21.14775 134.163,20.0115 L134.163,15.255 L137.664,15.255 L137.664,12.06 L134.163,12.06 L134.163,8.01 L130.338,8.838 L130.338,12.06 L127.8,12.06 L127.8,15.255 L130.33125,15.255 L130.329,20.7675 Z M118.404,20.8395 C118.404,20.0115 119.23425,19.60875 120.4875,19.60875 C121.253536,19.6132028 122.016349,19.7083656 122.76,19.89225 L122.76,21.501 C122.029149,21.9001512 121.20767,22.1039709 120.375,22.09275 C119.1465,22.09275 118.41075,21.62025 118.41075,20.8395 M119.58075,24.7905 C120.93075,24.7905 122.01975,24.507 123.03675,23.82075 L123.03675,24.579 L126.82125,24.579 L126.82125,16.5555 C126.82125,13.5045 124.76475,11.8305 121.3335,11.8305 C119.4165,11.8305 117.522,12.2805 115.4835,13.203 L116.856,16.02 C118.323,15.4035 119.556,15.0255 120.64275,15.0255 C122.21775,15.0255 123.03225,15.63975 123.03225,16.89525 L123.03225,17.5095 C122.104961,17.2694643 121.150595,17.1499795 120.19275,17.154 C116.973,17.154 115.0335,18.504 115.0335,20.91825 C115.0335,23.11875 116.784,24.79725 119.57625,24.79725 M98.77725,24.58575 L102.8475,24.58575 L102.8475,18.0945 L109.66275,18.0945 L109.66275,24.579 L113.733,24.579 L113.733,8.0145 L109.67175,8.0145 L109.67175,14.37975 L102.8565,14.37975 L102.8565,8.0145 L98.78625,8.0145 L98.77725,24.58575 Z M83.277,18.30825 C83.277,16.50825 84.69675,15.13575 86.5665,15.13575 C87.5407999,15.1148903 88.4871798,15.4619498 89.217,16.10775 L89.217,20.475 C88.5013929,21.1465643 87.5472457,21.504572 86.5665,21.4695 C84.7215,21.4695 83.277,20.097 83.277,18.29925 M89.26425,24.57 L93.051,24.57 L93.051,7.1865 L89.226,8.0145 L89.226,12.72375 C88.2522856,12.1717322 87.1502635,11.8861378 86.031,11.89575 C82.38825,11.89575 79.524,14.7105 79.524,18.30825 C79.5010519,20.0130972 80.1639908,21.6556876 81.3638838,22.867004 C82.5637767,24.0783205 84.2000119,24.7567934 85.905,24.7500643 C87.1120686,24.7557569 88.2892756,24.374919 89.26425,23.66325 L89.26425,24.57 Z M71.8965,14.9625 C73.1025,14.9625 74.1195,15.74325 74.52225,16.94925 L69.3,16.94925 C69.678,15.696 70.62525,14.9625 71.90325,14.9625 M65.43675,18.33075 C65.43675,21.97575 68.418,24.81525 72.24975,24.81525 C74.35575,24.81525 75.89475,24.246 77.481,22.92075 L74.9475,20.67075 C74.35575,21.28725 73.4805,21.618 72.441,21.618 C71.1029548,21.6556867 69.8796675,20.866094 69.363,19.63125 L78.28425,19.63125 L78.28425,18.68625 C78.28425,14.7105 75.61125,11.8485 71.96625,11.8485 C70.2352666,11.8223817 68.5669176,12.495545 67.3387715,13.7156446 C66.1106255,14.9357441 65.4265103,16.5996324 65.44125,18.33075 M58.83525,11.493 C60.18525,11.493 60.94125,12.3435 60.94125,13.36275 C60.94125,14.382 60.183,15.2325 58.83525,15.2325 L54.81225,15.2325 L54.81225,11.493 L58.83525,11.493 Z M50.73525,24.579 L54.8055,24.579 L54.8055,18.5445 L57.90375,18.5445 L61.029,24.579 L65.57175,24.579 L61.92675,17.95275 C63.8218627,17.1820151 65.0580914,15.3365787 65.04975,13.29075 C65.04975,10.3095 62.7075,8.0145 59.19975,8.0145 L50.742,8.0145 L50.73525,24.579 Z"
              fill="#000000"
            />
          </g>
        </g>
      </svg>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>
<div class="pf-c-tile pf-m-display-lg" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <?xml version="1.0" encoding="utf-8"?>
      <!-- Generator: Adobe Illustrator 23.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
      <svg
        version="1.1"
        width="6.65em"
        height="1em"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
        x="0px"
        y="0px"
        viewBox="0 0 1616.7 243.1"
        style="enable-background:new 0 0 1616.7 243.1;"
        xml:space="preserve"
      >
        <style type="text/css">
  .st0 {
    fill: #ee0000;
  }
        </style>
        <title>Logo-Red_Hat-OpenShift_Container_Platform-A-Standard-RGB</title>
        <path
          d="M263.4,220.7c-21.2,0-37.9-16.5-37.9-37.5s16.6-37.6,37.9-37.6s38,16.5,38,37.6S284.6,220.7,263.4,220.7z M263.4,155.7
            	c-15.1,0-26.7,11.9-26.7,27.5s11.6,27.4,26.7,27.4c15.1,0,26.8-12,26.8-27.4S278.6,155.7,263.4,155.7z"
        />
        <path
          d="M311.8,166.6H322v5.1c4.5-3.9,10.3-6,16.2-5.9c15,0,26.7,12,26.7,27.2s-11.8,27.4-26.9,27.4c-5.7,0-11.3-1.8-15.9-5.2v25.9
            	h-10.4L311.8,166.6z M322.1,181.2v23.9c3.3,3.9,8.8,6.2,14.8,6.2c10.2,0,17.9-7.8,17.9-18.2s-7.8-18.3-17.9-18.3
            	C330.9,174.8,325.6,177.1,322.1,181.2z"
        />
        <path
          d="M400.5,220.5c-15.6,0-27.8-12-27.8-27.5c0-15.3,11.6-27.2,26.5-27.2c14.6,0,25.6,12.1,25.6,27.7v3H383
            	c1.3,8.8,9,15.3,17.9,15.2c4.9,0.1,9.6-1.5,13.4-4.6l6.7,6.6C415.1,218.2,407.9,220.7,400.5,220.5z M383.1,188.6h31.4
            	c-1.6-8.1-7.8-14.1-15.5-14.1C391,174.5,384.6,180.2,383.1,188.6z"
        />
        <path
          d="M434.7,166.6h10.4v5.3c4.2-4.2,10-6.5,15.9-6.4c12.2,0,20.7,8.4,20.7,20.7v33.3h-10.4V188c0-8.3-5.1-13.4-13.1-13.4
            	c-5.3-0.2-10.3,2.4-13.1,6.9v38.1h-10.4L434.7,166.6z"
        />
        <path
          d="M495,199.8c7.9,7.7,16,11.4,25.1,11.4c10.5,0,17.7-5,17.7-12.2c0-6.4-4.2-9.7-14.8-11.4l-12.2-2
            	c-13.3-2.2-19.9-8.4-19.9-18.9c0-12.7,10.6-20.9,26.8-20.9c10.6,0,20.9,3.5,29.3,9.9l-6,8.3c-7.9-6-15.7-8.9-23.8-8.9
            	c-9.5,0-15.8,4.4-15.8,10.8c0,5.9,3.6,8.7,13,10.3l11.7,1.8c15.4,2.5,22.4,8.8,22.4,20.2c0,13.4-11.7,22.4-29,22.4
            	c-11.7,0-23-4.7-31.2-13.1L495,199.8z"
        />
        <path
          d="M557.4,146.7l10.4-2.3v27.5c4.2-4.2,10-6.5,15.9-6.4c12.2,0,20.7,8.4,20.7,20.7v33.3H594V188c0-8.3-5.1-13.4-13.1-13.4
            	c-5.3-0.2-10.2,2.4-13.1,6.9v38.1h-10.4V146.7z"
        />
        <path
          d="M615.2,151.6c0-3.5,2.8-6.4,6.3-6.4c0,0,0,0,0,0c3.6-0.1,6.6,2.6,6.7,6.2c0.1,3.6-2.6,6.6-6.2,6.7c-0.2,0-0.3,0-0.5,0
            	C618,158,615.2,155.2,615.2,151.6C615.2,151.6,615.2,151.6,615.2,151.6z M626.8,219.5h-10.4v-52.9h10.4V219.5z"
        />
        <path
          d="M646.9,166.6v-8c0-11,6.3-17.1,18-17.1c2.5,0,5,0.3,7.5,0.9v9.1c-2.1-0.7-4.3-1-6.5-0.9c-5.7,0-8.5,2.6-8.5,8.2v7.8h15.1
            	v8.7h-15.1v44.2h-10.4v-44.2h-12.3v-8.8H646.9z"
        />
        <path
          d="M688.2,175.3H677v-8.7h11.2v-13.5l10.3-2.5v16h15.6v8.7h-15.6V204c0,5.4,2.2,7.4,7.8,7.4c2.6,0.1,5.2-0.4,7.6-1.2v8.7
            	c-3.2,1-6.5,1.5-9.9,1.6c-10.3,0-15.8-4.9-15.8-14L688.2,175.3z"
        />
        <path
          d="M803.1,203.3l5.2,5.4c-7.5,7.7-17.8,12.1-28.6,12c-20.7,0.3-37.8-16.2-38.2-36.9s16.2-37.8,36.9-38.2c0.4,0,0.8,0,1.2,0
            	c11.3,0,21.7,4.4,28.8,12l-5.3,5.6c-6-6.6-14.6-10.3-23.5-10.2c-16.8,0-29.6,13.1-29.6,30.2s12.9,30.1,29.9,30.1
            	C789,213.3,797.6,209.6,803.1,203.3z"
        />
        <path
          d="M841.2,166.4c14.8,0,26.5,11.9,26.5,27s-11.7,27.2-26.5,27.2s-26.6-11.9-26.6-27.1S826.3,166.4,841.2,166.4z M860.1,193.4
            	c0-11.3-8.3-20.2-18.9-20.2s-19,8.8-19,20.2s8.3,20.3,19,20.3S860.1,204.8,860.1,193.4L860.1,193.4z"
        />
        <path
          d="M878.4,167.4h7.7v6.1c4-4.8,9.7-7.2,16.4-7.2c11.9,0,20.1,8.2,20.1,20.2v33H915v-31.4c0-9.3-5.6-15-14.6-15
            	c-5.9-0.1-11.4,2.9-14.3,8v38.4h-7.7L878.4,167.4z"
        />
        <path
          d="M939.9,174h-11.2v-6.6h11.2v-13.2l7.6-2v15.2h15.7v6.6h-15.7v31.9c0,5.6,2.3,7.8,8,7.8c2.6,0.1,5.2-0.4,7.6-1.4v6.8
            	c-3,0.9-6,1.4-9.2,1.4c-9,0-14-4.4-14-12.6L939.9,174z"
        />
        <path
          d="M968.6,204.8c0-9.8,8-15.9,20.8-15.9c5.3,0,10.5,1.2,15.3,3.5v-6.9c0-8.3-4.8-12.6-13.8-12.6c-5.1,0-10.1,1.4-16.3,4.6
            	l-2.9-5.9c7.5-3.6,13.6-5.2,20-5.2c13.2,0,20.6,6.4,20.6,18.1v35h-7.5v-5.1c-4.7,4-10.7,6.2-16.8,6
            	C976.4,220.5,968.6,214.1,968.6,204.8z M989.2,214.4c6.2,0,11.3-1.9,15.5-6v-9.8c-4.3-2.9-9-4.2-15.1-4.2c-8.3,0-13.6,4-13.6,10.1
            	C976,210.4,981.4,214.4,989.2,214.4z"
        />
        <path
          d="M1023.7,152.2c0-2.9,2.3-5.2,5.2-5.2c2.8,0,5.2,2.3,5.2,5.1c0,0,0,0.1,0,0.1c0,2.9-2.3,5.2-5.2,5.2
            	C1026.1,157.4,1023.8,155.1,1023.7,152.2z M1032.7,219.5h-7.7v-52.1h7.7V219.5z"
        />
        <path
          d="M1045.9,167.4h7.7v6.1c4-4.8,9.7-7.2,16.4-7.2c11.8,0,20.1,8.2,20.1,20.2v33h-7.6v-31.4c0-9.3-5.6-15-14.6-15
            	c-5.9-0.1-11.4,2.9-14.3,8v38.4h-7.7V167.4z"
        />
        <path
          d="M1127.4,220.5c-14.7,0.2-26.7-11.6-26.8-26.3c0-0.2,0-0.5,0-0.7c0-15,11.3-26.8,25.7-26.8c13.8,0,24.7,11.9,24.7,26.8v2.4
            	h-42.7c1.1,10.3,9.2,17.9,19.6,17.9c5.4,0,10.8-1.8,14.3-4.8l4.8,5.1C1141.3,218.4,1134.4,220.6,1127.4,220.5z M1108.4,189.7h34.8
            	c-1.3-9.3-8.5-16.3-17.2-16.3C1117,173.4,1109.8,180.1,1108.4,189.7L1108.4,189.7z"
        />
        <path
          d="M1161.6,167.4h7.7v7.4c2.9-5.3,8.5-8.6,14.6-8.5c1.7,0,3.3,0.2,4.9,0.7v7.1c-1.7-0.6-3.6-0.9-5.4-0.9
            	c-6.4,0-11.3,3.8-14,10.7v35.7h-7.7L1161.6,167.4z"
        />
        <path
          d="M1221.4,146.7h31.6c14.2,0,23.5,8.3,23.5,21s-9.4,21.1-23.5,21.1h-23.6v30.7h-8L1221.4,146.7z M1229.4,153.9v28h23
            	c9.9,0,16.1-5.4,16.1-14s-6.2-13.9-16.1-13.9L1229.4,153.9z"
        />
        <path d="M1295,219.5h-7.7v-72.8l7.7-1.7V219.5z" />
        <path
          d="M1305.2,204.8c0-9.8,8-15.9,20.8-15.9c5.3,0,10.5,1.2,15.3,3.5v-6.9c0-8.3-4.8-12.6-13.8-12.6c-5.1,0-10.1,1.4-16.3,4.6
            	l-2.9-5.9c7.5-3.6,13.6-5.2,20-5.2c13.2,0,20.6,6.4,20.6,18.1v35h-7.5v-5.1c-4.7,4-10.7,6.2-16.8,6
            	C1313,220.5,1305.2,214.1,1305.2,204.8z M1325.8,214.4c6.2,0,11.3-1.9,15.5-6v-9.8c-4.3-2.9-9-4.2-15.1-4.2c-8.3,0-13.6,4-13.6,10.1
            	C1312.6,210.4,1318,214.4,1325.8,214.4z"
        />
        <path
          d="M1366.1,174h-11.2v-6.6h11.2v-13.2l7.6-2v15.2h15.7v6.6h-15.7v31.9c0,5.6,2.3,7.8,8,7.8c2.6,0.1,5.2-0.4,7.6-1.4v6.8
            	c-3,0.9-6,1.4-9.2,1.4c-9,0-14-4.4-14-12.6L1366.1,174z"
        />
        <path
          d="M1406.1,167.4v-9.9c0-10.2,5.7-15.8,16.1-15.8c2.4-0.1,4.7,0.2,7,0.9v6.9c-2.1-0.7-4.3-1-6.4-1c-6.1,0-9,2.9-9,9.3v9.7h15.5
            	v6.5h-15.5v45.6h-7.6V174h-12.3v-6.6L1406.1,167.4z"
        />
        <path
          d="M1459.1,166.4c14.8,0,26.5,11.9,26.5,27s-11.8,27.1-26.5,27.1s-26.6-11.9-26.6-27.1S1444.2,166.4,1459.1,166.4z M1478,193.4
            	c0-11.3-8.3-20.2-18.9-20.2s-19,8.8-19,20.2s8.3,20.3,19,20.3S1478,204.8,1478,193.4L1478,193.4z"
        />
        <path
          d="M1496.3,167.4h7.7v7.4c2.9-5.3,8.5-8.6,14.6-8.5c1.7,0,3.3,0.2,4.9,0.7v7.1c-1.7-0.6-3.6-0.9-5.4-0.9
            	c-6.4,0-11.3,3.8-14,10.7v35.7h-7.7L1496.3,167.4z"
        />
        <path
          d="M1532.3,167.4h7.7v5.7c3.8-4.4,9.4-6.9,15.3-6.8c6.8-0.2,13.1,3.5,16.4,9.5c3.9-6.1,10.7-9.7,17.9-9.5
            	c11.3,0,19.1,8.2,19.1,20.2v33h-7.6v-31.4c0-9.3-5.2-15-13.5-15c-5.7,0-10.5,2.9-13.8,8.5c0.3,1.6,0.5,3.2,0.5,4.9v33h-7.6v-31.4
            	c0-9.3-5.2-15-13.4-15c-5.6,0-10.1,2.6-13.3,7.6v38.8h-7.7L1532.3,167.4z"
        />
        <path
          class="st0"
          d="M129,85c12.5,0,30.6-2.6,30.6-17.5c0-1.1-0.1-2.3-0.3-3.4l-7.4-32.4c-1.7-7.1-3.2-10.4-15.7-16.6
            	C126.4,10.2,105.3,2,99,2c-5.8,0-7.6,7.5-14.4,7.5c-6.7,0-11.6-5.6-17.9-5.6c-6,0-9.9,4.1-12.9,12.5c0,0-8.4,23.7-9.5,27.2
            	c-0.2,0.6-0.3,1.3-0.2,1.9C44,54.8,80.3,85,129,85 M161.6,73.6c1.7,8.2,1.7,9.1,1.7,10.1c0,14-15.7,21.8-36.4,21.8
            	C80,105.5,39.1,78.1,39.1,60c0-2.5,0.5-5,1.5-7.3C23.8,53.5,2,56.5,2,75.7C2,107.2,76.6,146,135.6,146c45.3,0,56.7-20.5,56.7-36.7
            	C192.3,96.6,181.3,82.2,161.6,73.6"
        />
        <path
          d="M161.5,73.6c1.7,8.2,1.7,9.1,1.7,10.1c0,14-15.7,21.8-36.4,21.8C80,105.5,39.1,78.1,39.1,60c0-2.5,0.5-5,1.5-7.3l3.7-9.1
            	c-0.2,0.6-0.3,1.3-0.2,1.9C44,54.8,80.3,85,129,85c12.5,0,30.6-2.6,30.6-17.5c0-1.1-0.1-2.3-0.3-3.4L161.5,73.6z"
        />
        <path
          d="M581.2,94.3c0,11.9,7.2,17.7,20.2,17.7c4-0.1,8-0.7,11.9-1.7V96.5c-2.5,0.8-5.1,1.2-7.7,1.2c-5.4,0-7.4-1.7-7.4-6.7V69.8
            	h15.6V55.6h-15.6v-18l-17,3.7v14.3H570v14.2h11.2L581.2,94.3z M528.2,94.6c0-3.7,3.7-5.5,9.3-5.5c3.4,0,6.8,0.4,10.1,1.3v7.2
            	c-3.2,1.8-6.9,2.7-10.6,2.6C531.5,100.2,528.3,98.1,528.2,94.6 M533.5,112.2c6,0,10.8-1.3,15.4-4.3v3.4h16.8V75.6
            	c0-13.6-9.1-21-24.4-21c-8.5,0-16.9,2-26,6.1l6.1,12.5c6.5-2.7,12-4.4,16.8-4.4c7,0,10.6,2.7,10.6,8.3v2.7
            	c-4.1-1.1-8.4-1.6-12.6-1.6c-14.3,0-22.9,6-22.9,16.7C513.3,104.8,521,112.2,533.5,112.2 M441,111.3h18.1V82.4h30.3v28.8h18.1V37.6
            	h-18.1v28.3h-30.3V37.6H441L441,111.3z M372.1,83.4c0-8,6.3-14.1,14.6-14.1c4.3-0.1,8.5,1.4,11.8,4.3V93c-3.2,3-7.4,4.6-11.8,4.4
            	C378.5,97.4,372.1,91.3,372.1,83.4 M398.7,111.2h16.8V33.9l-17,3.7v20.9c-4.3-2.5-9.2-3.7-14.2-3.7c-16.2,0-28.9,12.5-28.9,28.5
            	c-0.2,15.6,12.3,28.4,27.9,28.6c0.2,0,0.3,0,0.5,0c5.4,0,10.6-1.7,14.9-4.8V111.2z M321.5,68.5c5.4,0,9.9,3.5,11.7,8.8H310
            	C311.7,71.8,315.9,68.5,321.5,68.5 M292.8,83.5c0,16.2,13.2,28.8,30.3,28.8c9.4,0,16.2-2.5,23.2-8.4l-11.3-10
            	c-2.6,2.7-6.5,4.2-11.1,4.2c-5.9,0.2-11.4-3.3-13.7-8.8h39.6v-4.2c0-17.7-11.9-30.4-28.1-30.4c-15.8-0.2-28.8,12.4-29,28.1
            	C292.8,83,292.8,83.2,292.8,83.5 M263.5,53.1c6,0,9.4,3.8,9.4,8.3s-3.4,8.3-9.4,8.3h-17.9V53.1H263.5z M227.5,111.2h18.1V84.4h13.8
            	l13.9,26.8h20.2l-16.2-29.5c8.4-3.4,13.9-11.6,13.9-20.7c0-13.2-10.4-23.5-26-23.5h-37.6L227.5,111.2z"
        />
      </svg>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>

```

### Extra content

```html
<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <i class="fas fa-bell" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div
    class="pf-c-tile__body"
  >This is really really long subtext that goes on for so long that it has to wrap to the next line. This is really really long subtext that goes on for so long that it has to wrap to the next line.</div>
</div>
<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <i class="fas fa-bell" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div
    class="pf-c-tile__body"
  >This is really really long subtext that goes on for so long that it has to wrap to the next line.</div>
</div>
<div class="pf-c-tile" tabindex="0">
  <div class="pf-c-tile__header pf-m-stacked">
    <div class="pf-c-tile__icon">
      <i class="fas fa-bell" aria-hidden="true"></i>
    </div>
    <div class="pf-c-tile__title">Default</div>
  </div>
  <div class="pf-c-tile__body">Subtext goes here</div>
</div>

```

## Documentation

### Overview

### Accessibility

| Attribute       | Applied to   | Outcome                                                                               |
| --------------- | ------------ | ------------------------------------------------------------------------------------- |
| `tabindex="0"`  | `.pf-c-tile` | Inserts the tile into the tab order of the page so that it is focusable. **Required** |
| `tabindex="-1"` | `.pf-c-tile` | Removes the tile from keyboard focus when it is disabled.                             |

### Usage

| Class                | Applied to           | Outcome                                            |
| -------------------- | -------------------- | -------------------------------------------------- |
| `.pf-c-tile`         | `<div>`              | Initiates a tile. **Required**                     |
| `.pf-c-tile__header` | `<div>`              | Initiates the tile header.                         |
| `.pf-c-tile__title`  | `<div>`              | Initiates the tile title.                          |
| `.pf-c-tile__icon`   | `<div>`              | Initiates the tile icon or image.                  |
| `.pf-c-tile__body`   | `<div>`              | Initiates the tile body.                           |
| `.pf-m-selected`     | `.pf-c-tile`         | Modifies the tile for the selected state.          |
| `.pf-m-disabled`     | `.pf-c-tile`         | Modifies the tile for the disabled state.          |
| `.pf-m-stacked`      | `.pf-c-tile__header` | Modifies the tile header to be stacked vertically. |
| `.pf-m-display-lg`   | `.pf-c-tile`         | Modifies the tile to have large display styling.   |
