/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInteractionProfileState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int INTERACTIONPROFILE;

    public XrInteractionProfileState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrInteractionProfileState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInteractionProfileState.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrInteractionProfileState.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long interactionProfile() {
        return XrInteractionProfileState.ninteractionProfile(this.address());
    }

    public XrInteractionProfileState type(@NativeType(value="XrStructureType") int value) {
        XrInteractionProfileState.ntype(this.address(), value);
        return this;
    }

    public XrInteractionProfileState type$Default() {
        return this.type(53);
    }

    public XrInteractionProfileState next(@NativeType(value="void *") long value) {
        XrInteractionProfileState.nnext(this.address(), value);
        return this;
    }

    public XrInteractionProfileState interactionProfile(@NativeType(value="XrPath") long value) {
        XrInteractionProfileState.ninteractionProfile(this.address(), value);
        return this;
    }

    public XrInteractionProfileState set(int type, long next, long interactionProfile) {
        this.type(type);
        this.next(next);
        this.interactionProfile(interactionProfile);
        return this;
    }

    public XrInteractionProfileState set(XrInteractionProfileState src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrInteractionProfileState malloc() {
        return (XrInteractionProfileState)XrInteractionProfileState.wrap(XrInteractionProfileState.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrInteractionProfileState calloc() {
        return (XrInteractionProfileState)XrInteractionProfileState.wrap(XrInteractionProfileState.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrInteractionProfileState create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrInteractionProfileState)XrInteractionProfileState.wrap(XrInteractionProfileState.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrInteractionProfileState create(long address) {
        return (XrInteractionProfileState)XrInteractionProfileState.wrap(XrInteractionProfileState.class, (long)address);
    }

    @Nullable
    public static XrInteractionProfileState createSafe(long address) {
        return address == 0L ? null : (XrInteractionProfileState)XrInteractionProfileState.wrap(XrInteractionProfileState.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrInteractionProfileState.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrInteractionProfileState.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrInteractionProfileState.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInteractionProfileState.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrInteractionProfileState.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrInteractionProfileState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrInteractionProfileState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrInteractionProfileState malloc(MemoryStack stack) {
        return (XrInteractionProfileState)XrInteractionProfileState.wrap(XrInteractionProfileState.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrInteractionProfileState calloc(MemoryStack stack) {
        return (XrInteractionProfileState)XrInteractionProfileState.wrap(XrInteractionProfileState.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrInteractionProfileState.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrInteractionProfileState.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long ninteractionProfile(long struct) {
        return UNSAFE.getLong(null, struct + (long)INTERACTIONPROFILE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ninteractionProfile(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)INTERACTIONPROFILE, value);
    }

    static {
        Struct.Layout layout = XrInteractionProfileState.__struct((Struct.Member[])new Struct.Member[]{XrInteractionProfileState.__member((int)4), XrInteractionProfileState.__member((int)POINTER_SIZE), XrInteractionProfileState.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        INTERACTIONPROFILE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrInteractionProfileState, Buffer>
    implements NativeResource {
        private static final XrInteractionProfileState ELEMENT_FACTORY = XrInteractionProfileState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrInteractionProfileState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInteractionProfileState.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrInteractionProfileState.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long interactionProfile() {
            return XrInteractionProfileState.ninteractionProfile(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInteractionProfileState.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(53);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrInteractionProfileState.nnext(this.address(), value);
            return this;
        }

        public Buffer interactionProfile(@NativeType(value="XrPath") long value) {
            XrInteractionProfileState.ninteractionProfile(this.address(), value);
            return this;
        }
    }
}

