#include "lib/math.glsl"
#include "lib/sdf.glsl"

uniform vec4 colour;
uniform vec2 dimensions;
uniform float dt;

in vec2 pos;
out vec4 colour_out;

void main(void)
{
   float d     = sdCircle( pos*dimensions, dimensions.x );
   float alpha = smoothstep(-1.0, 0.0, -d);
   colour_out   = colour;
   colour_out.a *= alpha;
   colour_out.a *= 0.3 + 0.1 * sin( dt * M_PI ) + 0.6*length(pos);
}
