/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;

public class Hk2PluginProperties {
    public static final String PROP_JAVA_PLATFORM = "java_platform";
    public static final String PROP_JAVADOCS = "javadocs";
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    private InstanceProperties ip;
    private static final int DEBUGPORT = 9009;
    private ServerUtilities su;

    public Hk2PluginProperties(Hk2DeploymentManager dm, ServerUtilities su) {
        this.ip = InstanceProperties.getInstanceProperties((String)dm.getUri());
        this.su = su;
    }

    public String getDomainDir() {
        String path = this.ip.getProperty("domainsfolder");
        return null == path ? path : path + File.separator + this.ip.getProperty("domainname");
    }

    public String getInstallRoot() {
        return this.ip.getProperty("installfolder");
    }

    public String getGlassfishRoot() {
        return this.ip.getProperty("homefolder");
    }

    public JavaPlatform getJavaPlatform() {
        String currentJvm = this.ip.getProperty(PROP_JAVA_PLATFORM);
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatform[] installedPlatforms = jpm.getPlatforms(null, new Specification("J2SE", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String platformName = (String)installedPlatforms[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (platformName == null || !platformName.equals(currentJvm)) continue;
            return installedPlatforms[i];
        }
        return jpm.getDefaultPlatform();
    }

    public InstanceProperties getInstanceProperties() {
        return this.ip;
    }

    public static List<URL> tokenizePath(String path) {
        try {
            ArrayList<URL> l = new ArrayList<URL>();
            StringTokenizer tok = new StringTokenizer(path, ":;", true);
            char dosHack = '\u0000';
            int lastDelim = 0;
            int delimCount = 0;
            while (tok.hasMoreTokens()) {
                char c;
                Object s = tok.nextToken();
                if (((String)s).length() == 0) continue;
                if (((String)s).length() == 1 && ((c = ((String)s).charAt(0)) == ':' || c == ';')) {
                    lastDelim = c;
                    ++delimCount;
                    continue;
                }
                if (dosHack != '\u0000') {
                    if (lastDelim == 58 && delimCount == 1 && (((String)s).charAt(0) == '\\' || ((String)s).charAt(0) == '/')) {
                        s = dosHack + ":" + (String)s;
                    } else {
                        l.add(Hk2PluginProperties.fileToUrl(new File(Character.toString(dosHack))));
                    }
                    dosHack = '\u0000';
                }
                delimCount = 0;
                if (((String)s).length() == 1 && ((c = ((String)s).charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    dosHack = c;
                    continue;
                }
                l.add(Hk2PluginProperties.fileToUrl(new File((String)s)));
            }
            if (dosHack != '\u0000') {
                l.add(Hk2PluginProperties.fileToUrl(new File(Character.toString(dosHack))));
            }
            return l;
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return new ArrayList<URL>();
        }
    }

    public static URL fileToUrl(File file) throws MalformedURLException {
        File nfile = FileUtil.normalizeFile((File)file);
        URL url = nfile.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        }
        return url;
    }

    public static String buildPath(List<URL> path) {
        String PATH_SEPARATOR = System.getProperty("path.separator");
        StringBuilder sb = new StringBuilder(path.size() * 16);
        Iterator<URL> i = path.iterator();
        while (i.hasNext()) {
            sb.append(Hk2PluginProperties.urlToString(i.next()));
            if (!i.hasNext()) continue;
            sb.append(PATH_SEPARATOR);
        }
        return sb.toString();
    }

    private static String urlToString(URL url) {
        if ("jar".equals(url.getProtocol())) {
            URL fileURL = FileUtil.getArchiveFile((URL)url);
            if (FileUtil.getArchiveRoot((URL)fileURL).equals(url)) {
                url = fileURL;
            } else {
                return url.toExternalForm();
            }
        }
        if ("file".equals(url.getProtocol())) {
            File f = new File(URI.create(url.toExternalForm()));
            return f.getAbsolutePath();
        }
        return url.toExternalForm();
    }

    public void setJavadocs(List<URL> path) {
        this.ip.setProperty(PROP_JAVADOCS, Hk2PluginProperties.buildPath(path));
    }

    public int getDebugPort() {
        return 9009;
    }
}

