/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.parser;

import com.oracle.js.parser.ErrorManager;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.TokenType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.css.lib.api.FilterableError;
import org.netbeans.modules.javascript2.editor.embedding.JsEmbeddingProvider;
import org.netbeans.modules.javascript2.editor.parser.BaseParserResult;
import org.netbeans.modules.javascript2.editor.parser.JsParserError;
import org.netbeans.modules.javascript2.editor.parser.ParsingErrorFilter;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class JsErrorManager
extends ErrorManager
implements ANTLRErrorListener {
    private static final Logger LOGGER = Logger.getLogger(JsErrorManager.class.getName());
    private static final int MAX_MESSAGE_LENGTH = 100;
    private static final boolean SHOW_BADGES_EMBEDDED = Boolean.getBoolean(JsErrorManager.class.getName() + ".showBadgesEmbedded");
    private static final Comparator<SimpleError> POSITION_COMPARATOR = (o1, o2) -> {
        if (o1.getStartPosition() < o2.getStartPosition()) {
            return -1;
        }
        if (o1.getStartPosition() > o2.getStartPosition()) {
            return 1;
        }
        return 0;
    };
    private static final Pattern ERROR_MESSAGE_PATTERN = Pattern.compile(".*:\\d+:\\d+ (.*)", 32);
    private static final Pattern REPLACE_POINTER_PATTERN = Pattern.compile("(\\n)+.*\\n\\s*\\^\\s*");
    private static final String EXPECTED = "Expected";
    private final Snapshot snapshot;
    private final Language<JsTokenId> language;
    private List<ParserError> parserErrors;
    private List<JsParserError> convertedErrors;
    private static final Map<String, JsTokenId> JS_TEXT_TOKENS = new HashMap<String, JsTokenId>();

    public JsErrorManager(Snapshot snapshot, Language<JsTokenId> language) {
        this.snapshot = snapshot;
        this.language = language;
    }

    Error getMissingCurlyError() {
        if (this.parserErrors == null) {
            return null;
        }
        FileObject file = this.snapshot != null ? this.snapshot.getSource().getFileObject() : null;
        List<FilterableError.SetFilterAction> enableFilterAction = file != null ? ParsingErrorFilter.getEnableFilterAction(file) : Collections.emptyList();
        FilterableError.SetFilterAction disableFilterAction = file != null ? ParsingErrorFilter.getDisableFilterAction(file) : null;
        for (ParserError error : this.parserErrors) {
            if (error.message == null || !error.message.contains("Expected }") && !error.message.contains("but found }")) continue;
            return new JsParserError(error.toSimpleError(this.snapshot, this.language), this.snapshot != null ? this.snapshot.getSource().getFileObject() : null, Severity.ERROR, null, false, false, enableFilterAction, disableFilterAction);
        }
        return null;
    }

    Error getMissingSemicolonError() {
        if (this.parserErrors == null) {
            return null;
        }
        FileObject file = this.snapshot != null ? this.snapshot.getSource().getFileObject() : null;
        List<FilterableError.SetFilterAction> enableFilterAction = file != null ? ParsingErrorFilter.getEnableFilterAction(file) : Collections.emptyList();
        FilterableError.SetFilterAction disableFilterAction = file != null ? ParsingErrorFilter.getDisableFilterAction(file) : null;
        for (ParserError error : this.parserErrors) {
            if (error.message == null || !error.message.contains("Expected ;")) continue;
            return new JsParserError(error.toSimpleError(this.snapshot, this.language), this.snapshot != null ? this.snapshot.getSource().getFileObject() : null, Severity.ERROR, null, false, false, enableFilterAction, disableFilterAction);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.parserErrors == null;
    }

    public void error(ParserException e) {
        this.addParserError(new NashornParserError(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e.getToken()));
    }

    public void error(String message) {
        LOGGER.log(Level.FINE, "Error {0}", message);
        this.addParserError(new NashornParserError(message));
    }

    public void warning(ParserException e) {
        LOGGER.log(Level.FINE, null, (Throwable)e);
    }

    public void warning(String message) {
        LOGGER.log(Level.FINE, "Warning {0}", message);
    }

    public List<? extends FilterableError> getErrors() {
        if (this.convertedErrors == null) {
            if (this.parserErrors == null) {
                this.convertedErrors = Collections.emptyList();
            } else {
                ArrayList<SimpleError> errors = new ArrayList<SimpleError>(this.parserErrors.size());
                for (ParserError error : this.parserErrors) {
                    errors.add(error.toSimpleError(this.snapshot, this.language));
                }
                errors.sort(POSITION_COMPARATOR);
                this.convertedErrors = JsErrorManager.convert(this.snapshot, errors);
            }
        }
        return Collections.unmodifiableList(this.convertedErrors);
    }

    JsErrorManager fillErrors(JsErrorManager original) {
        assert (this.snapshot == original.snapshot) : this.snapshot + ":" + original.snapshot;
        assert (this.language == original.language) : this.language + ":" + original.language;
        this.parserErrors = original.parserErrors != null ? new ArrayList<ParserError>(original.parserErrors) : null;
        this.convertedErrors = null;
        return this;
    }

    private void addParserError(ParserError error) {
        this.convertedErrors = null;
        if (this.parserErrors == null) {
            this.parserErrors = new ArrayList<ParserError>();
        }
        this.parserErrors.add(error);
    }

    private static List<JsParserError> convert(Snapshot snapshot, List<SimpleError> errors) {
        FilterableError.SetFilterAction disableFilterAction;
        ArrayList<JsParserError> ret = new ArrayList<JsParserError>(errors.size());
        FileObject file = snapshot != null ? snapshot.getSource().getFileObject() : null;
        List<FilterableError.SetFilterAction> enableFilterAction = file != null ? ParsingErrorFilter.getEnableFilterAction(file) : Collections.emptyList();
        FilterableError.SetFilterAction setFilterAction = disableFilterAction = file != null ? ParsingErrorFilter.getDisableFilterAction(file) : null;
        if (snapshot != null && BaseParserResult.isEmbedded(snapshot)) {
            int nextCorrect = -1;
            boolean afterGeneratedIdentifier = false;
            for (SimpleError error : errors) {
                boolean showInEditor = true;
                int pos = snapshot.getOriginalOffset(error.getStartPosition());
                if (pos >= 0 && nextCorrect <= error.getStartPosition() && !JsEmbeddingProvider.containsGeneratedIdentifier(error.getMessage())) {
                    TokenSequence ts = LexUtilities.getJsPositionedSequence((Snapshot)snapshot, (int)error.getStartPosition());
                    if (ts != null && ts.movePrevious()) {
                        Token token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts);
                        if (JsEmbeddingProvider.containsGeneratedIdentifier(token.text().toString())) {
                            nextCorrect = JsErrorManager.findNextCorrectOffset((TokenSequence<? extends JsTokenId>)ts, error.getStartPosition());
                            showInEditor = false;
                            afterGeneratedIdentifier = true;
                        } else if (afterGeneratedIdentifier && error.getMessage().contains(EXPECTED)) {
                            String expected = JsErrorManager.getExpected(error.getMessage());
                            if ("eof".equals(expected)) {
                                showInEditor = false;
                            } else {
                                JsTokenId expectedToken = JsErrorManager.getJsTokenFromString(expected);
                                ts.movePrevious();
                                Token previousNonWsToken = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts);
                                if (expectedToken != null && expectedToken == previousNonWsToken.id()) {
                                    showInEditor = false;
                                }
                            }
                        }
                    }
                } else {
                    showInEditor = false;
                }
                ret.add(new JsParserError(error, file, Severity.ERROR, null, SHOW_BADGES_EMBEDDED, showInEditor, enableFilterAction, disableFilterAction));
            }
        } else {
            for (SimpleError error : errors) {
                ret.add(new JsParserError(error, file, Severity.ERROR, null, true, true, enableFilterAction, disableFilterAction));
            }
        }
        return ret;
    }

    private static String getExpected(String errorMessage) {
        int expectedIndex = errorMessage.indexOf(EXPECTED);
        String afterExpected = errorMessage.substring(expectedIndex + 9);
        int indexOfSpace = afterExpected.indexOf(" ");
        return indexOfSpace != -1 ? afterExpected.substring(0, indexOfSpace) : afterExpected;
    }

    public static JsTokenId getJsTokenFromString(String name) {
        return JS_TEXT_TOKENS.get(name);
    }

    private static int findNextCorrectOffset(TokenSequence<? extends JsTokenId> ts, int offset) {
        ts.move(offset);
        if (ts.moveNext()) {
            LexUtilities.findNextIncluding(ts, Collections.singletonList(JsTokenId.BRACKET_LEFT_CURLY));
            LexUtilities.findNextIncluding(ts, Collections.singletonList(JsTokenId.EOL));
        }
        return ts.offset();
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (recognizer instanceof Parser) {
            List stack = ((Parser)recognizer).getRuleInvocationStack();
            Collections.reverse(stack);
        }
        this.addParserError(new AntlrParserError(msg, line, charPositionInLine, offendingSymbol));
    }

    public void reportAmbiguity(Parser parser, DFA dfa, int i, int i1, boolean bln, BitSet bitset, ATNConfigSet atncs) {
    }

    public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitset, ATNConfigSet atncs) {
    }

    public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atncs) {
    }

    static {
        for (JsTokenId jsTokenId : JsTokenId.values()) {
            if (jsTokenId.fixedText() == null) continue;
            JS_TEXT_TOKENS.put(jsTokenId.fixedText(), jsTokenId);
        }
    }

    private static abstract class ParserError {
        final String message;
        final int line;
        final int column;

        ParserError(String message, int line, int column) {
            if (message.length() > 100) {
                int index = message.indexOf(10, 100);
                this.message = message.substring(0, index < 100 && index > 0 ? index : 100);
                LOGGER.log(Level.FINE, "Too long error message {0}", message);
            } else {
                this.message = message;
            }
            this.line = line;
            this.column = column;
        }

        abstract SimpleError toSimpleError(@NonNull Snapshot var1, @NonNull Language<JsTokenId> var2);
    }

    static final class SimpleError {
        private final String message;
        private final boolean lineError;
        private final int startPosition;
        private final int endPosition;

        private SimpleError(String message, boolean lineError, int startPosition, int endPosition) {
            this.message = message;
            this.lineError = lineError;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isLineError() {
            return this.lineError;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }
    }

    private static final class NashornParserError
    extends ParserError {
        final long token;

        NashornParserError(String message, int line, int column, long token) {
            super(message, line, column);
            this.token = token;
        }

        NashornParserError(String message, long token) {
            this(message, -1, -1, token);
        }

        NashornParserError(String message) {
            this(message, -1, -1, -1L);
        }

        @Override
        SimpleError toSimpleError(@NonNull Snapshot snapshot, @NonNull Language<JsTokenId> language) {
            String[] parts;
            String message = this.message;
            int offset = -1;
            Matcher matcher = ERROR_MESSAGE_PATTERN.matcher(message);
            if (matcher.matches()) {
                message = matcher.group(1);
            }
            message = REPLACE_POINTER_PATTERN.matcher(message).replaceAll("");
            if (this.token > 0L) {
                offset = com.oracle.js.parser.Token.descPosition((long)this.token);
                if (com.oracle.js.parser.Token.descType((long)this.token) == TokenType.EOF && snapshot.getOriginalOffset(offset) == -1) {
                    int realOffset = -1;
                    TokenSequence ts = LexUtilities.getPositionedSequence((Snapshot)snapshot, (int)offset, language);
                    while (ts.movePrevious()) {
                        if (snapshot.getOriginalOffset(ts.offset()) <= 0) continue;
                        realOffset = ts.offset() + ts.token().length() - 1;
                        break;
                    }
                    if (realOffset > 0) {
                        offset = realOffset;
                    }
                }
            } else if (this.line == -1 && this.column == -1 && (parts = this.message.split(":")).length > 3) {
                try {
                    offset = Integer.parseInt(parts[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new SimpleError(message, true, offset, offset + 1);
        }
    }

    private static final class AntlrParserError
    extends ParserError {
        final Object token;

        public AntlrParserError(String message, int line, int column, Object token) {
            super(message, line, column);
            this.token = token;
        }

        @Override
        SimpleError toSimpleError(Snapshot snapshot, Language<JsTokenId> language) {
            String message = this.message;
            LineDocument doc = (LineDocument)snapshot.getSource().getDocument(false);
            if (doc == null) {
                LOGGER.log(Level.WARNING, "No document found");
                return new SimpleError(message, false, 0, 0);
            }
            int lineOffset = LineDocumentUtils.getLineStartFromIndex((LineDocument)((LineDocument)snapshot.getSource().getDocument(false)), (int)(this.line - 1));
            int offset = lineOffset + this.column;
            if (offset > -1 && offset < snapshot.getText().length() && snapshot.getOriginalOffset(offset) == -1) {
                int realOffset = -1;
                TokenSequence ts = LexUtilities.getPositionedSequence((Snapshot)snapshot, (int)offset, language);
                while (ts.movePrevious()) {
                    if (snapshot.getOriginalOffset(ts.offset()) <= 0) continue;
                    realOffset = ts.offset() + ts.token().length() - 1;
                    break;
                }
                if (realOffset > 0) {
                    offset = realOffset;
                }
            }
            int endOffset = -1;
            if (offset >= 0) {
                org.antlr.v4.runtime.Token t;
                int len;
                endOffset = offset + 1;
                if (this.token instanceof org.antlr.v4.runtime.Token && (len = (t = (org.antlr.v4.runtime.Token)this.token).getStopIndex() - t.getStartIndex()) > 0) {
                    endOffset = offset + len + 1;
                }
            }
            return new SimpleError(message, false, offset, endOffset);
        }
    }
}

