/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.lsp.server.explorer.TreeNodeRegistry;
import org.netbeans.modules.java.lsp.server.explorer.TreeViewProvider;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class NodePropertiesProvider
implements CommandProvider {
    private static final Logger LOG = Logger.getLogger(NodePropertiesProvider.class.getName());
    private static final String COMMAND_PREFIX = "nbls.";
    private static final String COMMAND_GET_NODE_PROPERTIES = "nbls.node.properties.get";
    private static final String COMMAND_SET_NODE_PROPERTIES = "nbls.node.properties.set";
    private static final String PROP_NAME = "name";
    private static final String PROP_DNAME = "displayName";
    private static final String PROP_HTML_NAME = "htmlName";
    private static final String PROP_SHORT_NAME = "shortName";
    private static final String PROP_PREFERRED = "preferred";
    private static final String PROP_EXPERT = "expert";
    private static final String PROP_HIDDEN = "hidden";
    private static final String PROP_CAN_READ = "read";
    private static final String PROP_CAN_WRITE = "write";
    private static final String PROP_VAL_TYPE = "type";
    private static final String PROP_VALUE = "value";
    private static final String PROPS = "properties";
    private static final Set<String> COMMANDS = new HashSet<String>(Arrays.asList("nbls.node.properties.get", "nbls.node.properties.set"));
    private final Gson gson = new Gson();

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        TreeNodeRegistry r = (TreeNodeRegistry)Lookup.getDefault().lookup(TreeNodeRegistry.class);
        if (r == null) {
            return CompletableFuture.completedFuture(null);
        }
        int nodeId = ((JsonPrimitive)arguments.get(0)).getAsInt();
        TreeViewProvider nodeProvider = r.providerOf(nodeId);
        Node node = null;
        if (nodeProvider != null) {
            node = nodeProvider.findNode(nodeId);
        }
        if (node == null) {
            return CompletableFuture.completedFuture(null);
        }
        boolean getProps = COMMAND_GET_NODE_PROPERTIES.equals(command);
        Node.PropertySet[] propertySets = node.getPropertySets();
        if (getProps) {
            return CompletableFuture.completedFuture(this.getAllPropertiesMap(propertySets));
        }
        if (arguments.size() == 2) {
            Object propJson = arguments.get(1);
            if (propJson instanceof JsonNull) {
                return CompletableFuture.completedFuture(null);
            }
            Map m = (Map)this.gson.fromJson((JsonElement)propJson, Map.class);
            try {
                return CompletableFuture.completedFuture(this.setAllProperties(propertySets, m));
            }
            catch (IllegalArgumentException ex) {
                CompletableFuture<Object> f = new CompletableFuture<Object>();
                f.completeExceptionally(ex);
                return f;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    Map<String, Map<String, ?>> getAllPropertiesMap(Node.PropertySet[] propertySets) {
        HashMap allPropertiesMap = new HashMap();
        for (int i = 0; i < propertySets.length; ++i) {
            HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
            Node.PropertySet ps = propertySets[i];
            propertiesMap.put(PROP_NAME, ps.getName());
            propertiesMap.put(PROP_DNAME, ps.getDisplayName());
            propertiesMap.put(PROP_HTML_NAME, ps.getHtmlDisplayName());
            propertiesMap.put(PROP_SHORT_NAME, ps.getShortDescription());
            propertiesMap.put(PROP_PREFERRED, ps.isPreferred());
            propertiesMap.put(PROP_EXPERT, ps.isExpert());
            propertiesMap.put(PROP_HIDDEN, ps.isHidden());
            propertiesMap.put(PROPS, this.getProperties(ps.getProperties()));
            allPropertiesMap.put(ps.getName(), propertiesMap);
        }
        return allPropertiesMap;
    }

    private Map<String, Object>[] getProperties(Node.Property<?>[] properties) {
        Map[] props = new Map[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            HashMap<String, Object> propMap = new HashMap<String, Object>();
            Node.Property<?> property = properties[i];
            if (!property.canRead()) continue;
            propMap.put(PROP_DNAME, property.getDisplayName());
            propMap.put(PROP_HTML_NAME, property.getHtmlDisplayName());
            propMap.put(PROP_SHORT_NAME, property.getShortDescription());
            propMap.put(PROP_NAME, property.getName());
            propMap.put(PROP_PREFERRED, property.isPreferred());
            propMap.put(PROP_EXPERT, property.isExpert());
            propMap.put(PROP_HIDDEN, property.isHidden());
            propMap.put(PROP_CAN_WRITE, property.canWrite());
            propMap.put(PROP_VAL_TYPE, property.getValueType().getName());
            propMap.put(PROP_VALUE, this.getPropertyValue(property));
            props[i] = propMap;
        }
        return props;
    }

    private Object getPropertyValue(Node.Property<?> prop) {
        try {
            return prop.getValue();
        }
        catch (IllegalAccessException ex) {
            LOG.log(Level.INFO, "getPropertyValue", ex);
        }
        catch (InvocationTargetException ex) {
            LOG.log(Level.INFO, "getPropertyValue", ex);
        }
        return null;
    }

    private Map<String, Map<String, String>> setAllProperties(Node.PropertySet[] propertySets, Map<String, Map<String, ?>> m) {
        HashMap<String, Map<String, String>> errorSet = new HashMap<String, Map<String, String>>();
        HashMap<String, Node.PropertySet> propertySetMap = new HashMap<String, Node.PropertySet>();
        assert (m.size() <= propertySets.length);
        for (Node.PropertySet pset : propertySets) {
            propertySetMap.put(pset.getName(), pset);
        }
        for (Map map : m.values()) {
            String psetName = (String)map.get(PROP_NAME);
            Node.PropertySet p = (Node.PropertySet)propertySetMap.get(psetName);
            if (p != null) {
                Map<String, String> errors = this.setProperties(p.getProperties(), (List)map.get(PROPS));
                if (errors.isEmpty()) continue;
                errorSet.put(p.getName(), errors);
                continue;
            }
            throw new IllegalArgumentException("Property Set " + psetName + " does not exist.");
        }
        return errorSet;
    }

    private Map<String, String> setProperties(Node.Property[] properties, List<Map<String, Object>> props) {
        HashMap<String, Node.Property> names = new HashMap<String, Node.Property>();
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Node.Property p : properties) {
            names.put(p.getName(), p);
        }
        for (Map map : props) {
            String name = (String)map.get(PROP_NAME);
            Node.Property prop = (Node.Property)names.get(name);
            if (prop != null && prop.canWrite()) {
                try {
                    Object oldVal;
                    Object val = map.get(PROP_VALUE);
                    if (Objects.equals(val, oldVal = prop.getValue())) continue;
                    prop.setValue(val);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    errors.put(prop.getName(), ex.getLocalizedMessage());
                    LOG.log(Level.INFO, "setProperties", ex);
                }
                continue;
            }
            throw new IllegalArgumentException("Property " + name + " does not exist.");
        }
        return errors;
    }

    public Set<String> getCommands() {
        return COMMANDS;
    }
}

