/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.ui.models.Bundle;
import org.netbeans.modules.debugger.jpda.ui.models.JPDAWatchRefreshModel;
import org.netbeans.modules.debugger.jpda.ui.models.ValuePropertyEditor;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTableModel;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.PinWatchUISupport;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public final class PinWatchValueProvider
implements PinWatchUISupport.ValueProvider,
PropertyChangeListener {
    private final Map<Watch, ValueListeners> valueListeners = new HashMap<Watch, ValueListeners>();
    private final ContextProvider lookupProvider;
    private final JPDADebuggerImpl debugger;
    private final Action headAction;
    private final WatchRefreshModelImpl refrModel = new WatchRefreshModelImpl();
    private static final RequestProcessor RP = new RequestProcessor(PinWatchValueProvider.class);

    public PinWatchValueProvider(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.debugger = (JPDADebuggerImpl)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)this);
        this.headAction = (Action)lookupProvider.lookupFirst("PinWatchHeadActions", Action.class);
    }

    public String getId() {
        return "org.netbeans.modules.debugger.jpda.PIN_VALUE_PROVIDER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        return vl.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangeListener(Watch watch, PinWatchUISupport.ValueProvider.ValueChangeListener chl) {
        WatchesModel.JPDAWatchEvaluating watchEv;
        ValueListeners vl = new ValueListeners(chl);
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.put(watch, vl);
        }
        vl.watchEv = watchEv = new WatchesModel.JPDAWatchEvaluating(this.refrModel, watch, this.debugger);
        this.updateValueFrom(watchEv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetChangeListener(Watch watch) {
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.remove(watch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEditableValue(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        String valueOnly = vl.valueOnly;
        if (valueOnly == null) {
            return null;
        }
        if (!VariablesTableModel.isReadOnlyVar(vl.watchEv, (JPDADebugger)this.debugger)) {
            return valueOnly;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValue(final Watch watch, final String value) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return false;
        }
        final String lastValue = vl.value;
        final String lastValueOnly = vl.valueOnly;
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    vl.watchEv.setValue(value);
                    vl.watchEv.setEvaluated(null);
                    PinWatchValueProvider.this.updateValueFrom(vl.watchEv);
                }
                catch (InvalidExpressionException ex) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                    vl.value = lastValue;
                    vl.valueOnly = lastValueOnly;
                    vl.listener.valueChanged(watch);
                }
            }
        });
        vl.value = this.getEvaluatingText();
        vl.valueOnly = null;
        return true;
    }

    public Action[] getHeadActions(Watch watch) {
        if (this.headAction == null) {
            return null;
        }
        Pair<ObjectVariable, ValueListeners> varVl = this.getObjectVariable(watch);
        if (varVl == null) {
            return null;
        }
        ObjectVariable expandableVar = (ObjectVariable)varVl.first();
        return new Action[]{new ExpandAction(this.headAction, watch.getExpression(), expandableVar)};
    }

    public Action[] getTailActions(Watch watch) {
        Pair<ObjectVariable, ValueListeners> varVl = this.getObjectVariable(watch);
        if (varVl == null) {
            return null;
        }
        ObjectVariable var = (ObjectVariable)varVl.first();
        if (!ValuePropertyEditor.hasPropertyEditorFor((Variable)var)) {
            return null;
        }
        Object mirror = var.createMirrorObject();
        if (mirror == null) {
            return null;
        }
        ValuePropertyEditor ped = new ValuePropertyEditor(this.lookupProvider);
        ped.setValueWithMirror(var, mirror);
        return new Action[]{null, this.getPropertyEditorAction((PropertyEditor)((Object)ped), var, (ValueListeners)varVl.second(), watch.getExpression())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<ObjectVariable, ValueListeners> getObjectVariable(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        JPDAWatch ew = vl.watchEv.getEvaluatedWatch();
        if (ew == null) {
            return null;
        }
        ObjectVariable ov = null;
        if (ew instanceof ObjectVariable) {
            try {
                Object jdiValue = ew.getClass().getMethod("getJDIValue", new Class[0]).invoke((Object)ew, new Object[0]);
                if (jdiValue != null) {
                    ov = (ObjectVariable)ew;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ov == null) {
            return null;
        }
        return Pair.of(ov, (Object)vl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.debugger.getCurrentCallStackFrame() != null) {
            ArrayList<ValueListeners> vls;
            Map<Watch, ValueListeners> map = this.valueListeners;
            synchronized (map) {
                vls = new ArrayList<ValueListeners>(this.valueListeners.values());
            }
            for (ValueListeners vl : vls) {
                vl.watchEv.setEvaluated(null);
                vl.value = this.getEvaluatingText();
                vl.valueOnly = null;
                vl.listener.valueChanged(vl.watchEv.getWatch());
                this.refrModel.fireTableValueChangedChanged(vl.watchEv, null);
            }
        } else {
            Map<Watch, ValueListeners> map = this.valueListeners;
            synchronized (map) {
                for (Map.Entry<Watch, ValueListeners> wvl : this.valueListeners.entrySet()) {
                    wvl.getValue().value = null;
                    wvl.getValue().valueOnly = null;
                    wvl.getValue().listener.valueChanged(wvl.getKey());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValueFrom(final WatchesModel.JPDAWatchEvaluating watchEv) {
        ValueListeners vl;
        final Watch watch = watchEv.getWatch();
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    String value;
                    watchEv.getValue();
                    JPDAWatch ew = watchEv.getEvaluatedWatch();
                    if (ew == null) {
                        return;
                    }
                    String type = ew.getType();
                    int ti = type.lastIndexOf(46);
                    if (ti > 0) {
                        type = type.substring(ti + 1);
                    }
                    if (ew instanceof ObjectVariable) {
                        try {
                            value = ((ObjectVariable)ew).getToStringValue();
                        }
                        catch (InvalidExpressionException ex) {
                            value = ew.getValue();
                        }
                    } else {
                        value = ew.getValue();
                    }
                    vl.value = (type.isEmpty() ? "" : "(" + type + ") ") + value;
                    vl.valueOnly = value;
                    vl.listener.valueChanged(watch);
                }
            });
        }
    }

    private Action getPropertyEditorAction(final PropertyEditor pe, final ObjectVariable var, final ValueListeners vl, String expression) {
        PropertySupport.ReadWrite property = new PropertySupport.ReadWrite(expression, null, Bundle.PropEditDisplayName(expression), Bundle.PropEditDisplayName(expression)){

            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                return var;
            }

            public void setValue(final Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            vl.watchEv.setFromMirrorObject(val);
                            vl.watchEv.setEvaluated(null);
                            PinWatchValueProvider.this.updateValueFrom(vl.watchEv);
                        }
                        catch (InvalidObjectException ex) {
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getLocalizedMessage(), 0);
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                        }
                    }
                });
                vl.value = PinWatchValueProvider.this.getEvaluatingText();
                vl.valueOnly = null;
            }

            public PropertyEditor getPropertyEditor() {
                return pe;
            }
        };
        PropertyPanel pp = new PropertyPanel((Node.Property)property);
        return pp.getActionMap().get("invokeCustomEditor");
    }

    private final class WatchRefreshModelImpl
    implements JPDAWatchRefreshModel {
        private WatchRefreshModelImpl() {
        }

        @Override
        public boolean isLeaf(Object node) throws UnknownTypeException {
            return true;
        }

        @Override
        public void fireTableValueChangedChanged(Object node, String propertyName) {
            WatchesModel.JPDAWatchEvaluating watchEv = (WatchesModel.JPDAWatchEvaluating)node;
            if (watchEv.isCurrent()) {
                watchEv.setEvaluated(null);
            }
            PinWatchValueProvider.this.updateValueFrom(watchEv);
        }

        @Override
        public void fireChildrenChanged(Object node) {
        }
    }

    private static final class ValueListeners {
        volatile String value = null;
        volatile String valueOnly = null;
        PinWatchUISupport.ValueProvider.ValueChangeListener listener;
        WatchesModel.JPDAWatchEvaluating watchEv;

        ValueListeners(PinWatchUISupport.ValueProvider.ValueChangeListener listener) {
            this.listener = listener;
        }
    }

    private final class ExpandAction
    implements Action {
        private final Action delegate;
        private final String expression;
        private final ObjectVariable var;

        ExpandAction(Action delegate, String expression, ObjectVariable var) {
            this.delegate = delegate;
            this.expression = expression;
            this.var = var;
        }

        @Override
        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.delegate.putValue(key, value);
        }

        @Override
        public void setEnabled(boolean b) {
            this.delegate.setEnabled(b);
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.removePropertyChangeListener(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.putValue("debugger", PinWatchValueProvider.this.debugger);
            this.delegate.putValue("expression", this.expression);
            this.delegate.putValue("variable", this.var);
            this.delegate.actionPerformed(e);
        }
    }
}

