/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.common.Bundle;
import org.netbeans.modules.versioning.util.common.FileViewComponent;
import org.netbeans.modules.versioning.util.common.VCSFileNode;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.awt.MouseUtils;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public abstract class FileTreeView<T extends VCSStatusNode>
implements FileViewComponent<T>,
AncestorListener,
PropertyChangeListener,
MouseListener {
    protected final OutlineView view;
    private final ExplorerManager em;
    private boolean displayed;
    private EditorCookie[] editorCookies;
    private final ViewContainer viewComponent;
    private T[] nodes;
    private final Map<T, TreeFilterNode> nodeMapping = Collections.synchronizedMap(new WeakHashMap());
    private boolean internalTraverse;
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String PATH_SEPARATOR_REGEXP = File.separator.replace("\\", "\\\\");
    private static Image FOLDER_ICON;

    public FileTreeView() {
        this.em = new ExplorerManager();
        this.view = new OutlineView(Bundle.CTL_FileTree_treeColumn_Name());
        this.view.getOutline().setShowHorizontalLines(true);
        this.view.getOutline().setShowVerticalLines(false);
        this.view.getOutline().setRootVisible(false);
        this.view.setVerticalScrollBarPolicy(22);
        this.view.setHorizontalScrollBarPolicy(30);
        this.view.setPopupAllowed(false);
        this.view.getOutline().addMouseListener((MouseListener)this);
        this.view.getOutline().getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.view.getOutline().getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTreeView.this.showPopup(Utils.getPositionForPopup((JTable)FileTreeView.this.view.getOutline()));
            }
        });
        this.view.getOutline().getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), "slideOut");
        this.viewComponent = new ViewContainer(this.em);
        this.viewComponent.add((Component)this.view, "Center");
        this.viewComponent.addAncestorListener(this);
        this.em.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public final void focus() {
        this.view.requestFocusInWindow();
    }

    @Override
    public int getPreferredHeaderHeight() {
        return this.view.getOutline().getTableHeader().getPreferredSize().height;
    }

    @Override
    public JComponent getComponent() {
        return this.viewComponent;
    }

    @Override
    public int getPreferredHeight() {
        return this.view.getOutline().getPreferredSize().height;
    }

    private Node getNodeAt(int rowIndex) {
        Node result = null;
        TreePath path = this.view.getOutline().getOutlineModel().getLayout().getPathForRow(rowIndex);
        if (path != null) {
            result = Visualizer.findNode((Object)path.getLastPathComponent());
        }
        return result;
    }

    @Override
    public void setModel(T[] nodes, EditorCookie[] editorCookies, Object modelData) {
        this.editorCookies = editorCookies;
        this.nodes = nodes;
        this.em.setRootContext((Node)modelData);
        for (T n : nodes) {
            this.view.expandNode(this.toTreeNode(n));
        }
    }

    protected abstract void setDefaultColumnSizes();

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (!this.displayed) {
            this.displayed = true;
            this.setDefaultColumnSizes();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName()) && !this.internalTraverse) {
            T node;
            Node[] selectedNodes = this.em.getSelectedNodes();
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)this.view);
            if (tc != null) {
                tc.setActivatedNodes(selectedNodes);
            }
            if (selectedNodes.length == 1 && (node = this.convertNode(selectedNodes[0])) != null) {
                this.nodeSelected(node);
                return;
            }
            this.nodeSelected(null);
        }
    }

    private void showPopup(final MouseEvent e) {
        int row = this.view.getOutline().rowAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.view.getOutline().getSelectedRows();
            for (int i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.view.getOutline().getSelectionModel().setSelectionInterval(row, row);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPopupMenu menu = FileTreeView.this.getPopup();
                if (menu != null) {
                    menu.show((Component)FileTreeView.this.view.getOutline(), e.getX(), e.getY());
                }
            }
        });
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.getPopup();
        if (menu != null) {
            menu.show((Component)this.view.getOutline(), p.x, p.y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            Action action;
            int row = this.view.getOutline().rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            T n = this.convertNode(this.getNodeAt(this.view.getOutline().convertRowIndexToModel(row)));
            if (n != null && (action = ((VCSStatusNode)((Object)n)).getNodeAction()) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 1001, ""));
                e.consume();
            }
        }
    }

    @Override
    public Object prepareModel(T[] nodes) {
        AbstractNode rootNode;
        HashMap sortedNodes = new HashMap();
        for (T n : nodes) {
            File root = ((VCSFileNode)((VCSStatusNode)((Object)n)).getFileNode()).getRoot();
            if (root == null) continue;
            TreeSet repositorySetups = (TreeSet)sortedNodes.get(root);
            if (repositorySetups == null) {
                repositorySetups = new TreeSet(new PathComparator());
                sortedNodes.put(root, repositorySetups);
            }
            repositorySetups.add(n);
        }
        Class<?> type = nodes.getClass().getComponentType();
        if (sortedNodes.size() == 1) {
            Map.Entry e = sortedNodes.entrySet().iterator().next();
            rootNode = new RepositoryRootNode(this, (File)e.getKey(), (VCSStatusNode[])FileTreeView.toArray((Collection)e.getValue(), type));
            ((TreeViewChildren)rootNode.getChildren()).buildSubNodes(type);
        } else {
            rootNode = new RootNode(sortedNodes);
            ((TreeViewChildren)rootNode.getChildren()).buildSubNodes(type);
        }
        return rootNode;
    }

    protected T convertToAcceptedNode(Node node) {
        Class<?> c = this.nodes.getClass().getComponentType();
        return (T)((Object)(c.isInstance(node) ? (VCSStatusNode)node : null));
    }

    private T convertNode(Node node) {
        if (node instanceof TreeFilterNode) {
            return (T)((Object)((VCSStatusNode)((Object)((TreeFilterNode)node).getOriginal())));
        }
        return this.convertToAcceptedNode(node);
    }

    protected abstract void nodeSelected(T var1);

    protected abstract JPopupMenu getPopup();

    @Override
    public T getSelectedNode() {
        T node = null;
        Node[] selectedNodes = this.em.getSelectedNodes();
        if (selectedNodes.length == 1) {
            node = this.convertNode(selectedNodes[0]);
        }
        return node;
    }

    public final List<Node> getSelectedNodes() {
        Node[] selectedNodes = this.em.getSelectedNodes();
        ArrayList<Node> nodeList = new ArrayList<Node>(selectedNodes.length);
        for (Node n : selectedNodes) {
            T converted = this.convertNode(n);
            if (converted == null) {
                nodeList.add(n);
                continue;
            }
            nodeList.add((Node)converted);
        }
        return nodeList;
    }

    protected final Node createFilterNode(T original) {
        TreeFilterNode<T> n = new TreeFilterNode<T>(original);
        this.nodeMapping.put(original, n);
        return n;
    }

    @Override
    public void setSelectedNode(T toSelect) {
        try {
            this.em.setSelectedNodes(new Node[]{this.toTreeNode(toSelect)});
        }
        catch (PropertyVetoException ex) {
            Logger.getLogger(FileTreeView.class.getName()).log(Level.FINE, null, ex);
        }
    }

    @Override
    public T getNodeAtPosition(int position) {
        for (int i = 0; i < this.view.getOutline().getRowCount(); ++i) {
            Node n = this.getNodeAt(this.view.getOutline().convertRowIndexToModel(i));
            T converted = this.convertNode(n);
            if (converted == null || position-- != 0) continue;
            return converted;
        }
        return null;
    }

    @Override
    public T[] getNeighbouringNodes(T node, int boundary) {
        assert (EventQueue.isDispatchThread());
        LinkedHashSet<T> neighbours = new LinkedHashSet<T>(5);
        neighbours.add(node);
        for (int i = 1; i < boundary; ++i) {
            T prev;
            T next = this.convertNode(this.findShiftNode(this.toTreeNode(node), i, false));
            if (next != null) {
                neighbours.add(next);
            }
            if ((prev = this.convertNode(this.findShiftNode(this.toTreeNode(node), -i, false))) == null) continue;
            neighbours.add(prev);
        }
        return neighbours.toArray((VCSStatusNode[])Array.newInstance(node.getClass(), neighbours.size()));
    }

    @Override
    public T getNextNode(T node) {
        Node nextNode = this.findShiftNode(this.toTreeNode(node), 1, true);
        return this.convertNode(nextNode);
    }

    @Override
    public T getPreviousNode(T node) {
        Node prevNode = this.findShiftNode(this.toTreeNode(node), -1, true);
        return this.convertNode(prevNode);
    }

    @Override
    public boolean hasNextNode(T node) {
        return this.convertNode(this.findShiftNode(this.toTreeNode(node), 1, false)) != null;
    }

    @Override
    public boolean hasPreviousNode(T node) {
        return this.convertNode(this.findShiftNode(this.toTreeNode(node), -1, false)) != null;
    }

    private Node toTreeNode(T n) {
        Node filterNode = (Node)this.nodeMapping.get(n);
        return filterNode == null ? n : filterNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node findShiftNode(Node startingNode, int direction, boolean canExpand) {
        boolean oldVal = this.internalTraverse;
        Node[] selected = this.em.getSelectedNodes();
        try {
            this.internalTraverse = true;
            Node node = startingNode == null ? null : this.findDetailNode(startingNode, direction, this.view, canExpand);
            return node;
        }
        finally {
            try {
                this.em.setSelectedNodes(selected);
            }
            catch (PropertyVetoException propertyVetoException) {}
            this.internalTraverse = oldVal;
        }
    }

    private Node findDetailNode(Node fromNode, int direction, OutlineView outlineView, boolean canExpand) {
        return this.findUp(fromNode, direction, this.convertNode(fromNode) != null || direction < 0 ? direction : 0, outlineView, canExpand);
    }

    private Node findUp(Node node, int dir, int offset, OutlineView outlineView, boolean canExpand) {
        if (node == null) {
            return null;
        }
        Node parent = node.getParentNode();
        Node[] siblings = parent == null ? new Node[]{node} : FileTreeView.getChildren(parent, outlineView, canExpand);
        int nodeIndex = FileTreeView.findChildIndex(node, siblings);
        if (nodeIndex + offset < 0 || nodeIndex + offset >= siblings.length) {
            return this.findUp(parent, dir, dir, outlineView, canExpand);
        }
        int i = nodeIndex + offset;
        if (i >= 0 && i < siblings.length) {
            Node found = this.findDown(siblings[i], siblings, i, dir, outlineView, canExpand);
            return found;
        }
        return this.findUp(parent, dir, offset, outlineView, canExpand);
    }

    private Node findDown(Node node, Node[] siblings, int nodeIndex, int dir, OutlineView outlineView, boolean canExpand) {
        int i;
        Node[] children = FileTreeView.getChildren(node, outlineView, canExpand);
        int n = i = dir > 0 ? 0 : children.length - 1;
        while (i >= 0 && i < children.length) {
            Node found = this.findDown(children[i], children, i, dir, outlineView, canExpand);
            if (found != null) {
                return found;
            }
            i += dir;
        }
        for (i = nodeIndex; i >= 0 && i < siblings.length; i += dir) {
            T converted = this.convertNode(siblings[i]);
            if (converted == null) continue;
            return converted;
        }
        return null;
    }

    private static int findChildIndex(Node selectedNode, Node[] siblings) {
        int pos = -1;
        for (int i = 0; i < siblings.length; ++i) {
            if (siblings[i] != selectedNode) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private static Node[] getChildren(Node n, OutlineView outlineView, boolean canExpand) {
        if (outlineView != null) {
            if (!outlineView.isExpanded(n)) {
                if (canExpand) {
                    outlineView.expandNode(n);
                } else {
                    return n.getChildren().getNodes(true);
                }
            }
            return FileTreeView.getChildrenInDisplayedOrder(n, outlineView);
        }
        return n.getChildren().getNodes(true);
    }

    private static Node[] getChildrenInDisplayedOrder(Node parent, OutlineView outlineView) {
        Outline outline = outlineView.getOutline();
        Node[] unsortedChildren = parent.getChildren().getNodes(true);
        int rows = outlineView.getOutline().getRowCount();
        int start = FileTreeView.findRowIndexInOutline(parent, outline, rows);
        if (start == -1 && parent != ExplorerManager.find((Component)outlineView).getRootContext()) {
            return unsortedChildren;
        }
        LinkedList<Node> children = new LinkedList<Node>();
        for (int j = start + 1; j < rows; ++j) {
            int childModelIndex = outline.convertRowIndexToModel(j);
            if (childModelIndex == -1) continue;
            Object childObject = outline.getModel().getValueAt(childModelIndex, 0);
            Node childNode = Visualizer.findNode((Object)childObject);
            if (childNode.getParentNode() == parent) {
                children.add(childNode);
                continue;
            }
            if (children.size() == unsortedChildren.length) break;
        }
        return children.toArray(new Node[0]);
    }

    private static int findRowIndexInOutline(Node node, Outline outline, int rows) {
        int startRow = Math.max(outline.getSelectedRow(), 0);
        int offset = 0;
        while (startRow + offset < rows || startRow - offset >= 0) {
            int up = startRow + offset + 1;
            int down = startRow - offset;
            if (up < rows && FileTreeView.testNodeInRow(outline, node, up)) {
                return up;
            }
            if (down >= 0 && FileTreeView.testNodeInRow(outline, node, down)) {
                return down;
            }
            ++offset;
        }
        return -1;
    }

    private static boolean testNodeInRow(Outline outline, Node node, int i) {
        Object o;
        Node n;
        int modelIndex = outline.convertRowIndexToModel(i);
        return modelIndex != -1 && (n = Visualizer.findNode((Object)(o = outline.getModel().getValueAt(modelIndex, 0)))) == node;
    }

    private static Image getFolderIcon() {
        if (FOLDER_ICON == null) {
            Image base;
            Icon baseIcon = UIManager.getIcon(ICON_KEY_UIMANAGER);
            if (baseIcon != null) {
                base = ImageUtilities.icon2Image((Icon)baseIcon);
            } else {
                base = (Image)UIManager.get(ICON_KEY_UIMANAGER_NB);
                if (base == null) {
                    base = ImageUtilities.loadImage((String)"org/openide/loaders/defaultFolder.gif");
                }
            }
            FOLDER_ICON = base;
        }
        return FOLDER_ICON;
    }

    private static <T> T[] toArray(Collection<T> list, Class<?> type) {
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    private String getCommonPrefix(T[] nodes) {
        String prefix = "";
        if (nodes.length > 0) {
            prefix = ((VCSFileNode)((VCSStatusNode)((Object)nodes[0])).getFileNode()).getRelativePath();
            int index = prefix.lastIndexOf(File.separator);
            prefix = index == -1 ? "" : prefix.substring(0, index);
        }
        boolean slashNeeded = !prefix.isEmpty();
        for (T n : nodes) {
            String location = ((VCSFileNode)((VCSStatusNode)((Object)n)).getFileNode()).getRelativePath();
            while (!location.startsWith(prefix)) {
                slashNeeded = false;
                int index = prefix.lastIndexOf(File.separator);
                if (index == -1) {
                    prefix = "";
                    continue;
                }
                prefix = prefix.substring(0, index);
            }
        }
        return slashNeeded ? prefix + File.separator : prefix;
    }

    private static class ViewContainer
    extends JPanel
    implements ExplorerManager.Provider {
        private final ExplorerManager em;

        private ViewContainer(ExplorerManager em) {
            this.em = em;
            this.setLayout(new BorderLayout());
        }

        public ExplorerManager getExplorerManager() {
            return this.em;
        }
    }

    private static class PathComparator<T extends VCSStatusNode>
    implements Comparator<T> {
        private PathComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            String[] segments1 = ((VCSFileNode)((VCSStatusNode)((Object)o1)).getFileNode()).getRelativePath().split(PATH_SEPARATOR_REGEXP);
            String[] segments2 = ((VCSFileNode)((VCSStatusNode)((Object)o2)).getFileNode()).getRelativePath().split(PATH_SEPARATOR_REGEXP);
            for (int i = 0; i < Math.min(segments1.length, segments2.length); ++i) {
                String segment1 = segments1[i];
                String segment2 = segments2[i];
                int comp = segment1.compareTo(segment2);
                if (comp == 0) continue;
                if (segment1.startsWith(segment2)) {
                    return segment2.length() - segment1.length();
                }
                if (segment2.startsWith(segment1)) {
                    return segment2.length() - segment1.length();
                }
                return comp;
            }
            return segments2.length - segments1.length;
        }
    }

    private static class RepositoryRootNode
    extends AbstractNode {
        private final File repo;
        final /* synthetic */ FileTreeView this$0;

        private RepositoryRootNode(File repository, T[] nestedNodes) {
            this.this$0 = var1_1;
            super((Children)var1_1.new NodeChildren(new NodeData(new File(repository, var1_1.getCommonPrefix(nestedNodes)), var1_1.getCommonPrefix(nestedNodes), nestedNodes), true), Lookups.fixed((Object[])new Object[]{repository}));
            this.repo = repository;
        }

        public String getName() {
            return this.repo.getName();
        }

        public Image getIcon(int type) {
            return FileTreeView.getFolderIcon();
        }
    }

    private static abstract class TreeViewChildren
    extends Children.Array {
        private TreeViewChildren() {
        }

        abstract void buildSubNodes(Class<?> var1);
    }

    private class RootNode
    extends AbstractNode {
        private RootNode(Map<File, Collection<T>> nodes) {
            super((Children)new RootNodeChildren(nodes));
        }
    }

    private static class TreeFilterNode<T extends Node>
    extends FilterNode {
        public TreeFilterNode(T original) {
            super(original);
        }

        public T getOriginal() {
            return (T)super.getOriginal();
        }
    }

    private static class NodeData<T extends VCSStatusNode> {
        private final File file;
        private final String path;
        private final T[] nestedNodes;

        public NodeData(File file, String path, T[] nested) {
            this.file = file;
            this.path = path;
            this.nestedNodes = nested;
        }
    }

    private class NodeChildren
    extends TreeViewChildren {
        private final T[] nestedNodes;
        private final String path;
        private final boolean top;
        private final File file;

        public NodeChildren(NodeData<T> data, boolean top) {
            this.nestedNodes = data.nestedNodes;
            this.path = data.path;
            this.file = data.file;
            this.top = top;
        }

        @Override
        void buildSubNodes(Class<?> type) {
            ArrayList data = new ArrayList(this.nestedNodes.length);
            String prefix = null;
            ArrayList subNodes = new ArrayList();
            for (Object n : this.nestedNodes) {
                String location = ((VCSFileNode)((VCSStatusNode)((Object)n)).getFileNode()).getRelativePath();
                if (prefix == null) {
                    prefix = this.path + location.substring(this.path.length()).split(PATH_SEPARATOR_REGEXP, 0)[0];
                }
                if (location.equals(prefix)) {
                    if (!subNodes.isEmpty()) {
                        data.add(new NodeData(this.getFile(prefix), prefix, (VCSStatusNode[])FileTreeView.toArray(subNodes, type)));
                        subNodes.clear();
                    }
                    data.add(new NodeData(this.getFile(prefix), prefix, FileTreeView.toArray(Arrays.asList(n), type)));
                    prefix = null;
                    continue;
                }
                if (location.startsWith(prefix)) {
                    subNodes.add(n);
                    continue;
                }
                data.add(new NodeData(this.getFile(prefix), prefix, (VCSStatusNode[])FileTreeView.toArray(subNodes, type)));
                subNodes.clear();
                prefix = this.path + location.substring(this.path.length()).split(PATH_SEPARATOR_REGEXP, 0)[0];
                subNodes.add(n);
            }
            if (!subNodes.isEmpty()) {
                data.add(new NodeData(this.getFile(prefix), prefix, (VCSStatusNode[])FileTreeView.toArray(subNodes, type)));
            }
            this.add(this.createNodes(data, type));
        }

        private Node[] createNodes(List<NodeData<T>> keys, Class<?> type) {
            ArrayList<Node> toCreate = new ArrayList<Node>(keys.size());
            for (NodeData key : keys) {
                Object node;
                if (key.nestedNodes.length == 0) continue;
                if (key.nestedNodes.length == 1 && key.path.equals(((VCSFileNode)((VCSStatusNode)((Object)key.nestedNodes[0])).getFileNode()).getRelativePath())) {
                    node = FileTreeView.this.createFilterNode(key.nestedNodes[0]);
                } else {
                    String name;
                    if (this.top) {
                        name = key.path;
                    } else {
                        String[] segments = key.path.split(PATH_SEPARATOR_REGEXP);
                        name = segments[segments.length - 1];
                    }
                    final Image icon = this.getFolderIcon(key.file);
                    NodeChildren ch = new NodeChildren(new NodeData(key.file, key.path + File.separator, key.nestedNodes), false);
                    node = new AbstractNode((Children)ch, Lookups.fixed((Object[])new Object[]{key.file})){

                        public String getName() {
                            return name;
                        }

                        public Image getIcon(int type) {
                            return icon;
                        }
                    };
                    ch.buildSubNodes(type);
                }
                toCreate.add((Node)node);
            }
            return toCreate.toArray(new Node[0]);
        }

        private Image getFolderIcon(File file) {
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            Icon icon = null;
            if (fo != null) {
                try {
                    ProjectManager.Result res = ProjectManager.getDefault().isProject2(fo);
                    if (res != null) {
                        icon = res.getIcon();
                    }
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(FileTreeView.class.getName()).log(Level.INFO, null, ex);
                }
            }
            return icon == null ? FileTreeView.getFolderIcon() : ImageUtilities.icon2Image(icon);
        }

        private File getFile(String prefix) {
            String p = prefix;
            if (prefix.startsWith(this.path)) {
                p = prefix.substring(this.path.length());
            }
            return new File(this.file, p);
        }
    }

    private class RootNodeChildren
    extends TreeViewChildren {
        private final Map<File, Collection<T>> nestedNodes;

        public RootNodeChildren(Map<File, Collection<T>> setups) {
            this.nestedNodes = setups;
        }

        @Override
        void buildSubNodes(Class<?> type) {
            this.add(this.createNodes(type));
        }

        private Node[] createNodes(Class<?> type) {
            ArrayList<RepositoryRootNode> nodes = new ArrayList<RepositoryRootNode>(this.nestedNodes.size());
            for (Map.Entry e : this.nestedNodes.entrySet()) {
                RepositoryRootNode root = new RepositoryRootNode(FileTreeView.this, e.getKey(), (VCSStatusNode[])FileTreeView.toArray(e.getValue(), type));
                ((TreeViewChildren)root.getChildren()).buildSubNodes(type);
                nodes.add(root);
            }
            return nodes.toArray(new Node[0]);
        }
    }

    protected abstract class AbstractRenderDataProvider
    implements RenderDataProvider {
        protected AbstractRenderDataProvider() {
        }

        public String getDisplayName(Object o) {
            Node n = Visualizer.findNode((Object)o);
            Object value = n.getDisplayName();
            Object leafNode = FileTreeView.this.convertNode(n);
            if (leafNode != null) {
                String htmlDisplayName = DiffUtils.getHtmlDisplayName(leafNode, this.isModified(leafNode), false);
                if ((htmlDisplayName = this.annotateName(leafNode, htmlDisplayName)) != null) {
                    value = "<html>" + htmlDisplayName;
                }
            }
            return value;
        }

        public boolean isHtmlDisplayName(Object o) {
            return true;
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            Color c = null;
            Node n = Visualizer.findNode((Object)o);
            Object leafNode = FileTreeView.this.convertNode(n);
            if (leafNode != null) {
                c = ((VCSStatusNode)((Object)leafNode)).getAnnotatedFontColor();
            }
            return c;
        }

        public String getTooltipText(Object o) {
            Node n = Visualizer.findNode((Object)o);
            File file = (File)n.getLookup().lookup(File.class);
            return file != null ? file.getAbsolutePath() : n.getShortDescription();
        }

        public Icon getIcon(Object o) {
            Node n = Visualizer.findNode((Object)o);
            return new ImageIcon(n.getIcon(1));
        }

        private boolean isModified(T node) {
            int index = Arrays.asList(FileTreeView.this.nodes).indexOf(node);
            EditorCookie editorCookie = index >= 0 && index < FileTreeView.this.editorCookies.length ? FileTreeView.this.editorCookies[index] : null;
            return editorCookie != null ? editorCookie.isModified() : false;
        }

        protected abstract String annotateName(T var1, String var2);
    }
}

