/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.tm4e.core.internal.rule.BeginEndRule;
import org.eclipse.tm4e.core.internal.rule.BeginWhileRule;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.ICompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.IRuleFactoryHelper;
import org.eclipse.tm4e.core.internal.rule.IncludeOnlyRule;
import org.eclipse.tm4e.core.internal.rule.MatchRule;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.types.IRawCaptures;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.internal.types.IRawRepository;
import org.eclipse.tm4e.core.internal.types.IRawRule;
import org.eclipse.tm4e.core.internal.utils.CloneUtils;

public class RuleFactory {
    public static CaptureRule createCaptureRule(IRuleFactoryHelper helper, String name, String contentName, Integer retokenizeCapturedWithRuleId) {
        return (CaptureRule)helper.registerRule(id -> new CaptureRule(id, name, contentName, retokenizeCapturedWithRuleId));
    }

    public static int getCompiledRuleId(IRawRule desc, IRuleFactoryHelper helper, IRawRepository repository) {
        if (desc.getId() == null) {
            helper.registerRule(id -> {
                desc.setId(id);
                if (desc.getMatch() != null) {
                    return new MatchRule(desc.getId(), desc.getName(), desc.getMatch(), RuleFactory.compileCaptures(desc.getCaptures(), helper, repository));
                }
                if (desc.getBegin() == null) {
                    IRawRepository r = repository;
                    if (desc.getRepository() != null) {
                        r = CloneUtils.mergeObjects(repository, desc.getRepository());
                    }
                    return new IncludeOnlyRule(desc.getId(), desc.getName(), desc.getContentName(), RuleFactory._compilePatterns(desc.getPatterns(), helper, r));
                }
                String ruleWhile = desc.getWhile();
                if (ruleWhile != null) {
                    return new BeginWhileRule(desc.getId(), desc.getName(), desc.getContentName(), desc.getBegin(), RuleFactory.compileCaptures(desc.getBeginCaptures() != null ? desc.getBeginCaptures() : desc.getCaptures(), helper, repository), ruleWhile, RuleFactory.compileCaptures(desc.getWhileCaptures() != null ? desc.getWhileCaptures() : desc.getCaptures(), helper, repository), RuleFactory._compilePatterns(desc.getPatterns(), helper, repository));
                }
                return new BeginEndRule(desc.getId(), desc.getName(), desc.getContentName(), desc.getBegin(), RuleFactory.compileCaptures(desc.getBeginCaptures() != null ? desc.getBeginCaptures() : desc.getCaptures(), helper, repository), desc.getEnd(), RuleFactory.compileCaptures(desc.getEndCaptures() != null ? desc.getEndCaptures() : desc.getCaptures(), helper, repository), desc.isApplyEndPatternLast(), RuleFactory._compilePatterns(desc.getPatterns(), helper, repository));
            });
        }
        return desc.getId();
    }

    private static List<CaptureRule> compileCaptures(IRawCaptures captures, IRuleFactoryHelper helper, IRawRepository repository) {
        ArrayList<CaptureRule> r = new ArrayList<CaptureRule>();
        if (captures != null) {
            int numericCaptureId;
            int maximumCaptureId = 0;
            for (String captureId : captures) {
                numericCaptureId = RuleFactory.parseInt(captureId, 10);
                if (numericCaptureId <= maximumCaptureId) continue;
                maximumCaptureId = numericCaptureId;
            }
            for (int i = 0; i <= maximumCaptureId; ++i) {
                r.add(null);
            }
            for (String captureId : captures) {
                numericCaptureId = RuleFactory.parseInt(captureId, 10);
                Integer retokenizeCapturedWithRuleId = null;
                IRawRule rule = captures.getCapture(captureId);
                if (rule.getPatterns() != null) {
                    retokenizeCapturedWithRuleId = RuleFactory.getCompiledRuleId(captures.getCapture(captureId), helper, repository);
                }
                r.set(numericCaptureId, RuleFactory.createCaptureRule(helper, rule.getName(), rule.getContentName(), retokenizeCapturedWithRuleId));
            }
        }
        return r;
    }

    private static int parseInt(String string, int base) {
        try {
            return Integer.parseInt(string, base);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    private static ICompilePatternsResult _compilePatterns(Collection<IRawRule> patterns, IRuleFactoryHelper helper, IRawRepository repository) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        if (patterns != null) {
            for (IRawRule pattern : patterns) {
                Rule br;
                int patternId = -1;
                if (pattern.getInclude() != null) {
                    if (pattern.getInclude().charAt(0) == '#') {
                        IRawRule localIncludedRule = repository.getProp(pattern.getInclude().substring(1));
                        if (localIncludedRule != null) {
                            patternId = RuleFactory.getCompiledRuleId(localIncludedRule, helper, repository);
                        }
                    } else if (pattern.getInclude().equals("$base") || pattern.getInclude().equals("$self")) {
                        patternId = RuleFactory.getCompiledRuleId(repository.getProp(pattern.getInclude()), helper, repository);
                    } else {
                        String externalGrammarName = null;
                        String externalGrammarInclude = null;
                        int sharpIndex = pattern.getInclude().indexOf(35);
                        if (sharpIndex >= 0) {
                            externalGrammarName = pattern.getInclude().substring(0, sharpIndex);
                            externalGrammarInclude = pattern.getInclude().substring(sharpIndex + 1);
                        } else {
                            externalGrammarName = pattern.getInclude();
                        }
                        IRawGrammar externalGrammar = helper.getExternalGrammar(externalGrammarName, repository);
                        if (externalGrammar != null) {
                            if (externalGrammarInclude != null) {
                                IRawRule externalIncludedRule = externalGrammar.getRepository().getProp(externalGrammarInclude);
                                if (externalIncludedRule != null) {
                                    patternId = RuleFactory.getCompiledRuleId(externalIncludedRule, helper, externalGrammar.getRepository());
                                }
                            } else {
                                patternId = RuleFactory.getCompiledRuleId(externalGrammar.getRepository().getSelf(), helper, externalGrammar.getRepository());
                            }
                        }
                    }
                } else {
                    patternId = RuleFactory.getCompiledRuleId(pattern, helper, repository);
                }
                if (patternId == -1) continue;
                Rule rule = helper.getRule(patternId);
                boolean skipRule = false;
                if (rule instanceof IncludeOnlyRule) {
                    IncludeOnlyRule ior = (IncludeOnlyRule)rule;
                    if (ior.hasMissingPatterns && ior.patterns.length == 0) {
                        skipRule = true;
                    }
                } else if (rule instanceof BeginEndRule) {
                    br = (BeginEndRule)rule;
                    if (br.hasMissingPatterns && br.patterns.length == 0) {
                        skipRule = true;
                    }
                } else if (rule instanceof BeginWhileRule) {
                    br = (BeginWhileRule)rule;
                    if (((BeginWhileRule)br).hasMissingPatterns && ((BeginWhileRule)br).patterns.length == 0) {
                        skipRule = true;
                    }
                }
                if (skipRule) continue;
                r.add(patternId);
            }
        }
        return new ICompilePatternsResult(r, (patterns != null ? patterns.size() : 0) != r.size());
    }
}

