/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListAllowedDomainLicenseTypesRequest
extends BmcRequest<Void> {
    private String currentLicenseTypeName;
    private String opcRequestId;

    public String getCurrentLicenseTypeName() {
        return this.currentLicenseTypeName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().currentLicenseTypeName(this.currentLicenseTypeName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",currentLicenseTypeName=").append(String.valueOf(this.currentLicenseTypeName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAllowedDomainLicenseTypesRequest)) {
            return false;
        }
        ListAllowedDomainLicenseTypesRequest other = (ListAllowedDomainLicenseTypesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.currentLicenseTypeName, other.currentLicenseTypeName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.currentLicenseTypeName == null ? 43 : this.currentLicenseTypeName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAllowedDomainLicenseTypesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String currentLicenseTypeName = null;
        private String opcRequestId = null;

        public Builder currentLicenseTypeName(String currentLicenseTypeName) {
            this.currentLicenseTypeName = currentLicenseTypeName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAllowedDomainLicenseTypesRequest o) {
            this.currentLicenseTypeName(o.getCurrentLicenseTypeName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAllowedDomainLicenseTypesRequest build() {
            ListAllowedDomainLicenseTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAllowedDomainLicenseTypesRequest buildWithoutInvocationCallback() {
            ListAllowedDomainLicenseTypesRequest request = new ListAllowedDomainLicenseTypesRequest();
            request.currentLicenseTypeName = this.currentLicenseTypeName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

