/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc;

import java.awt.EventQueue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.phpdoc.Bundle;
import org.netbeans.modules.php.phpdoc.ui.PhpDocPreferences;
import org.netbeans.modules.php.phpdoc.ui.PhpDocPreferencesValidator;
import org.netbeans.modules.php.phpdoc.ui.options.PhpDocOptions;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class PhpDocScript {
    private static final Logger LOGGER = Logger.getLogger(PhpDocScript.class.getName());
    public static final String SCRIPT_NAME = "phpdoc";
    public static final String SCRIPT_NAME_LONG = "phpdoc" + FileUtils.getScriptExtension((boolean)true);
    public static final String SCRIPT_NAME_PHAR = "phpDocumentor.phar";
    public static final String OPTIONS_ID = "PhpDoc";
    public static final String OPTIONS_SUB_PATH = "FrameworksAndTools/PhpDoc";
    private static final String PARAM_CONFIG = "--config";
    private static final boolean IS_WINDOWS = Utilities.isWindows();
    private final String phpDocPath;

    private PhpDocScript(String phpDocPath) {
        this.phpDocPath = phpDocPath;
    }

    public static PhpDocScript getDefault() throws InvalidPhpExecutableException {
        String phpDocPath = PhpDocOptions.getInstance().getPhpDoc();
        String error = PhpDocScript.validate(phpDocPath);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new PhpDocScript(phpDocPath);
    }

    @CheckForNull
    public static PhpDocScript getForPhpModule(PhpModule phpModule, boolean showCustomizer) throws InvalidPhpExecutableException {
        String message = PhpDocScript.validatePhpModule(phpModule);
        if (message != null) {
            if (showCustomizer) {
                UiUtils.invalidScriptProvided((PhpModule)phpModule, (String)"Documentation", (String)message);
            }
            return null;
        }
        if (!PhpDocPreferences.isEnabled(phpModule)) {
            return null;
        }
        return PhpDocScript.getDefault();
    }

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/PhpDoc";
    }

    @CheckForNull
    public static String validate(String phpDocPath) {
        return PhpExecutableValidator.validateCommand((String)phpDocPath, (String)NbBundle.getMessage(PhpDocScript.class, (String)"LBL_PhpDocScript"));
    }

    @CheckForNull
    private static String validatePhpModule(PhpModule phpModule) {
        ValidationResult result = new PhpDocPreferencesValidator().validatePhpModule(phpModule).getResult();
        return PhpDocScript.validateResult(result);
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return result.getFirstError().getMessage();
        }
        return result.getFirstWarning().getMessage();
    }

    public void generateDocumentation(PhpModule phpModule) {
        assert (!EventQueue.isDispatchThread());
        String phpDocTarget = PhpDocPreferences.getPhpDocTarget(phpModule, true);
        if (phpDocTarget == null) {
            return;
        }
        String sanitizedPhpDocTarget = this.sanitizePath(phpDocTarget);
        Future result = new PhpExecutable(this.phpDocPath).optionsSubcategory(OPTIONS_SUB_PATH).displayName(Bundle.PhpDocScript_run_title(phpModule.getDisplayName())).additionalParameters(this.getAllParameters(sanitizedPhpDocTarget, phpModule)).run(this.getExecutionDescriptor(sanitizedPhpDocTarget));
        try {
            File index;
            if (result != null && (Integer)result.get() == 0 && (index = new File(phpDocTarget, "index.html")).isFile()) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(Utilities.toURI((File)index).toURL());
            }
        }
        catch (CancellationException index) {
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)OPTIONS_SUB_PATH);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
    }

    private ExecutionDescriptor getExecutionDescriptor(String sanitizedPhpDocTarget) {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.frontWindow(false).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)new ErrorFileLineConvertorFactory(sanitizedPhpDocTarget)).optionsPath(PhpDocScript.getOptionsPath());
    }

    private String sanitizePath(String path) {
        if (IS_WINDOWS) {
            return path.replace(File.separatorChar, '/');
        }
        return path;
    }

    private List<String> getAllParameters(String sanitizedPhpDocTarget, PhpModule phpModule) {
        String configurationPath;
        ArrayList<String> params = new ArrayList<String>(this.getDefaultParameters(sanitizedPhpDocTarget, phpModule));
        if (PhpDocPreferences.isConfigurationEnabled(phpModule) && !StringUtils.isEmpty((String)(configurationPath = PhpDocPreferences.getPhpDocConfigurationPath(phpModule)))) {
            params.add(PARAM_CONFIG);
            params.add(this.sanitizePath(PhpDocPreferences.getPhpDocConfigurationPath(phpModule)));
        }
        return params;
    }

    private List<String> getDefaultParameters(String sanitizedPhpDocTarget, PhpModule phpModule) {
        return Arrays.asList("run", "--ansi", "--directory", this.sanitizePath(FileUtil.toFile((FileObject)phpModule.getSourceDirectory()).getAbsolutePath()), "--target", sanitizedPhpDocTarget, "--title", PhpDocPreferences.getPhpDocTitle(phpModule));
    }

    private class ErrorFileLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        private final String docTarget;

        public ErrorFileLineConvertorFactory(String docTarget) {
            this.docTarget = docTarget;
        }

        public LineConvertor newLineConvertor() {
            Pattern pattern = Pattern.compile("(.*)(" + Pattern.quote(this.docTarget) + "/?errors\\.html)(.*)");
            return new ErrorFileLineConvertor(pattern);
        }
    }

    private class ErrorFileOutputListener
    implements OutputListener {
        private final URL url;

        public ErrorFileOutputListener(URL url) {
            this.url = url;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.url);
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private class ErrorFileLineConvertor
    implements LineConvertor {
        private final Pattern pattern;

        public ErrorFileLineConvertor(Pattern pattern) {
            this.pattern = pattern;
        }

        public List<ConvertedLine> convert(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.matches()) {
                try {
                    URL url = new URL("file://" + matcher.group(2));
                    LinkedList<ConvertedLine> lines = new LinkedList<ConvertedLine>();
                    if (!matcher.group(1).trim().isEmpty()) {
                        lines.add(ConvertedLine.forText((String)matcher.group(1), null));
                    }
                    lines.add(ConvertedLine.forText((String)matcher.group(2), (OutputListener)new ErrorFileOutputListener(url)));
                    if (!matcher.group(3).trim().isEmpty()) {
                        lines.add(ConvertedLine.forText((String)matcher.group(3), null));
                    }
                    return lines;
                }
                catch (MalformedURLException ex) {
                    LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
                }
            }
            return null;
        }
    }
}

