/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.execute.DefaultReplaceTokenProvider;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.NbGlobalActionGoalProvider;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Writer;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public final class ActionToGoalUtils {
    private static final String FO_ATTR_CUSTOM_MAPP = "customActionMappings";
    public static ContextAccessor ACCESSOR;

    private ActionToGoalUtils() {
    }

    @NonNull
    public static List<? extends MavenActionsProvider> actionProviders(@NonNull Project project) {
        ArrayList providers = new ArrayList();
        providers.addAll(project.getLookup().lookupAll(MavenActionsProvider.class));
        providers.addAll(Lookup.getDefault().lookupAll(MavenActionsProvider.class));
        return providers;
    }

    public static RunConfig createRunConfig(String action, NbMavenProjectImpl project, Lookup lookup) {
        return ActionToGoalUtils.createRunConfig(action, project, null, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunConfig createRunConfig(String action, NbMavenProjectImpl project, ProjectConfiguration c, Lookup lookup) {
        M2ConfigProvider configs = (M2ConfigProvider)project.getLookup().lookup(M2ConfigProvider.class);
        M2Configuration requested = c instanceof M2Configuration ? (M2Configuration)c : configs.getActiveConfiguration();
        RunConfig rc = requested.createConfigForDefaultAction(action, project, lookup);
        if (rc == null) {
            M2Configuration save = configs.setLocalConfiguration(requested);
            try {
                for (MavenActionsProvider mavenActionsProvider : ActionToGoalUtils.actionProviders(project)) {
                    if (!mavenActionsProvider.isActionEnable(action, project, lookup) || (rc = mavenActionsProvider.createConfigForDefaultAction(action, project, lookup)) == null) continue;
                    break;
                }
            }
            finally {
                configs.setLocalConfiguration(save);
            }
        }
        if (rc != null) {
            if (rc instanceof ModelRunConfig && ((ModelRunConfig)rc).isFallback()) {
                return rc;
            }
            ArrayList<String> acts = new ArrayList<String>();
            acts.addAll(rc.getActivatedProfiles());
            acts.addAll(requested.getActivatedProfiles());
            rc.setActivatedProfiles(acts);
            HashMap<String, String> props = new HashMap<String, String>(rc.getProperties());
            props.putAll(requested.getProperties());
            rc.addProperties(props);
        }
        return rc;
    }

    public static boolean isActionEnable(String action, NbMavenProjectImpl project, Lookup lookup) {
        return ActionToGoalUtils.isActionEnable(action, project, null, lookup);
    }

    public static boolean isDisabledMapping(NetbeansActionMapping am) {
        return am == null || am.getGoals().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActionEnable(String action, NbMavenProjectImpl project, ProjectConfiguration c, Lookup lookup) {
        String goal;
        Build bld;
        PackagingProvider packProv = new PackagingProvider(project);
        M2ConfigProvider configs = (M2ConfigProvider)project.getLookup().lookup(M2ConfigProvider.class);
        M2Configuration active = configs.getActiveConfiguration();
        M2Configuration useConfiguration = c instanceof M2Configuration ? (M2Configuration)c : active;
        NetbeansActionMapping m = ActionToGoalUtils.findEnabledAction(useConfiguration, action, project, packProv, lookup);
        if (m != null) {
            return !ActionToGoalUtils.isDisabledMapping(m);
        }
        m = ActionToGoalUtils.findEnabledAction(configs.getDefaultConfig(), action, project, packProv, lookup);
        if (m != null) {
            return !ActionToGoalUtils.isDisabledMapping(m);
        }
        if (("build".equals(action) || "rebuild".equals(action)) && (bld = project.getOriginalMavenProject().getBuild()) != null && (goal = bld.getDefaultGoal()) != null && goal.trim().length() > 0) {
            return true;
        }
        M2Configuration save = configs.setLocalConfiguration(useConfiguration);
        try {
            for (MavenActionsProvider mavenActionsProvider : ActionToGoalUtils.actionProviders(project)) {
                m = ActionToGoalUtils.findEnabledAction(mavenActionsProvider, action, project, packProv, lookup);
                if (m == null) continue;
                boolean bl = !ActionToGoalUtils.isDisabledMapping(m);
                return bl;
            }
        }
        finally {
            configs.setLocalConfiguration(save);
        }
        return false;
    }

    private static NetbeansActionMapping findEnabledAction(MavenActionsProvider activeConfiguration, String action, NbMavenProjectImpl project, PackagingProvider packProv, Lookup lookup) {
        boolean enabled;
        NetbeansActionMapping mapping = activeConfiguration.getMappingForAction(action, project);
        if (activeConfiguration instanceof AbstractMavenActionsProvider ? (enabled = ((AbstractMavenActionsProvider)activeConfiguration).isActionEnable(action, packProv.getPackaging())) : activeConfiguration.isActionEnable(action, project, lookup)) {
            return mapping;
        }
        return null;
    }

    public static NetbeansActionMapping getActiveMapping(String action, Project project, M2Configuration configuration) {
        NetbeansActionMapping na = null;
        if (configuration != null && (na = configuration.getMappingForAction(action, project)) == null) {
            na = configuration.getProfileMappingForAction(action, project, Collections.emptyMap(), null);
        }
        if (na == null) {
            na = ActionToGoalUtils.getDefaultMapping(action, project);
        }
        return na;
    }

    public static NetbeansActionMapping[] getActiveCustomMappings(NbMavenProjectImpl project) {
        return ActionToGoalUtils.getActiveCustomMappingsImpl(project, false);
    }

    public static NetbeansActionMapping[] getActiveCustomMappingsForFile(NbMavenProjectImpl project) {
        return ActionToGoalUtils.getActiveCustomMappingsImpl(project, true);
    }

    private static NetbeansActionMapping[] getActiveCustomMappingsImpl(NbMavenProjectImpl project, boolean forFiles) {
        M2ConfigProvider configs = (M2ConfigProvider)project.getLookup().lookup(M2ConfigProvider.class);
        ArrayList<NetbeansActionMapping> toRet = new ArrayList<NetbeansActionMapping>();
        ArrayList<String> names = new ArrayList<String>();
        for (NetbeansActionMapping map : configs.getActiveConfiguration().getCustomMappings()) {
            toRet.add(map);
            names.add(map.getActionName());
        }
        for (NetbeansActionMapping map : configs.getDefaultConfig().getCustomMappings()) {
            if (names.contains(map.getActionName())) continue;
            toRet.add(map);
            names.add(map.getActionName());
        }
        String prjPack = project.getProjectWatcher().getPackagingType();
        for (NetbeansActionMapping map : ((NbGlobalActionGoalProvider)Lookup.getDefault().lookup(NbGlobalActionGoalProvider.class)).getCustomMappings()) {
            if (names.contains(map.getActionName()) || !map.getPackagings().isEmpty() && !map.getPackagings().contains(prjPack.trim()) && !map.getPackagings().contains("*")) continue;
            toRet.add(map);
        }
        Iterator it = toRet.iterator();
        while (it.hasNext()) {
            NetbeansActionMapping map = (NetbeansActionMapping)it.next();
            boolean hasFiles = false;
            block4: for (Map.Entry<String, String> ent : map.getProperties().entrySet()) {
                for (String s : DefaultReplaceTokenProvider.fileBasedProperties) {
                    hasFiles = ent.getValue().contains(s);
                    if (hasFiles) break block4;
                }
            }
            if (forFiles == hasFiles) continue;
            it.remove();
        }
        return toRet.toArray(new NetbeansActionMapping[0]);
    }

    public static NetbeansActionMapping getDefaultMapping(String action, Project project) {
        MavenActionsProvider add;
        NetbeansActionMapping na = null;
        Iterator<? extends MavenActionsProvider> iterator = ActionToGoalUtils.actionProviders(project).iterator();
        while (iterator.hasNext() && (na = (add = iterator.next()).getMappingForAction(action, project)) == null) {
        }
        return na;
    }

    public static ActionToGoalMapping readMappingsFromFileAttributes(FileObject fo) {
        String string = (String)fo.getAttribute(FO_ATTR_CUSTOM_MAPP);
        ActionToGoalMapping mapp = null;
        if (string != null) {
            NetbeansBuildActionXpp3Reader reader = new NetbeansBuildActionXpp3Reader();
            try {
                mapp = reader.read(new StringReader(string));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (XmlPullParserException ex) {
                ex.printStackTrace();
            }
        }
        if (mapp == null) {
            mapp = new ActionToGoalMapping();
        }
        return mapp;
    }

    public static void writeMappingsToFileAttributes(FileObject fo, ActionToGoalMapping mapp) {
        NetbeansBuildActionXpp3Writer writer = new NetbeansBuildActionXpp3Writer();
        StringWriter string = new StringWriter();
        boolean error = false;
        try {
            writer.write(string, mapp);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            error = true;
        }
        if (!error) {
            try {
                fo.setAttribute(FO_ATTR_CUSTOM_MAPP, (Object)string.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static File resolveProjectExecutionBasedir(NetbeansActionMapping mapp, Project prj) {
        File base = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        if (mapp.getBasedir() != null) {
            base = FileUtilities.resolveFilePath(base, mapp.getBasedir());
        }
        return base;
    }

    static {
        block3: {
            ACCESSOR = null;
            Class<ExecutionContext> c = ExecutionContext.class;
            try {
                Class.forName(c.getName(), true, c.getClassLoader());
            }
            catch (Exception ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)ex);
            }
        }
        assert (ACCESSOR != null);
    }

    private static class PackagingProvider {
        private String packaging;
        private final NbMavenProjectImpl project;

        public PackagingProvider(NbMavenProjectImpl project) {
            this.project = project;
        }

        String getPackaging() {
            if (this.packaging == null) {
                this.packaging = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getPackagingType();
            }
            return this.packaging;
        }
    }

    public static abstract class ContextAccessor {
        public abstract ExecutionContext createContext(InputOutput var1, ProgressHandle var2);
    }
}

