/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv.impl;

import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.SecurityTokenReference;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.secconv.WSSCVersion;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SecurityContextTokenInfoImpl
implements SecurityContextTokenInfo {
    String identifier = null;
    String extId = null;
    String instance = null;
    byte[] secret = null;
    Map<String, byte[]> secretMap = new HashMap<String, byte[]>();
    Date creationTime = null;
    Date expirationTime = null;

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getExternalId() {
        return this.extId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.extId = externalId;
    }

    @Override
    public String getInstance() {
        return this.instance;
    }

    @Override
    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Override
    public byte[] getSecret() {
        byte[] newSecret = new byte[this.secret.length];
        System.arraycopy(this.secret, 0, newSecret, 0, this.secret.length);
        return newSecret;
    }

    @Override
    public byte[] getInstanceSecret(String instance) {
        return this.secretMap.get(instance);
    }

    @Override
    public void addInstance(String instance, byte[] key) {
        byte[] newKey = new byte[key.length];
        System.arraycopy(key, 0, newKey, 0, key.length);
        if (instance == null) {
            this.secret = newKey;
        } else {
            this.secretMap.put(instance, newKey);
        }
    }

    @Override
    public Date getCreationTime() {
        return new Date(this.creationTime.getTime());
    }

    @Override
    public void setCreationTime(Date creationTime) {
        this.creationTime = new Date(creationTime.getTime());
    }

    @Override
    public Date getExpirationTime() {
        return new Date(this.expirationTime.getTime());
    }

    @Override
    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = new Date(expirationTime.getTime());
    }

    @Override
    public Set getInstanceKeys() {
        return this.secretMap.keySet();
    }

    @Override
    public IssuedTokenContext getIssuedTokenContext() {
        IssuedTokenContextImpl itc = new IssuedTokenContextImpl();
        itc.setCreationTime(this.getCreationTime());
        itc.setExpirationTime(this.getExpirationTime());
        itc.setProofKey(this.getSecret());
        itc.setSecurityContextTokenInfo(this);
        URI uri = URI.create(this.getIdentifier());
        SecurityContextToken token = WSTrustElementFactory.newInstance(WSSCVersion.WSSC_10).createSecurityContextToken(uri, null, this.getExternalId());
        itc.setSecurityToken(token);
        com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference attachedReference = this.createSecurityTokenReference(token.getWsuId(), false);
        com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference unattachedRef = this.createSecurityTokenReference(token.getIdentifier().toString(), true);
        itc.setAttachedSecurityTokenReference(attachedReference);
        itc.setUnAttachedSecurityTokenReference(unattachedRef);
        return itc;
    }

    private com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference createSecurityTokenReference(String id, boolean unattached) {
        String uri = unattached ? id : "#" + id;
        DirectReference ref = WSTrustElementFactory.newInstance(WSSCVersion.WSSC_10).createDirectReference("http://schemas.xmlsoap.org/ws/2005/02/sc/sct", uri);
        return WSTrustElementFactory.newInstance(WSSCVersion.WSSC_10).createSecurityTokenReference(ref);
    }

    @Override
    public IssuedTokenContext getIssuedTokenContext(SecurityTokenReference reference) {
        return null;
    }
}

