/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.apigen.ui.customizer;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.apigen.ApiGenProvider;
import org.netbeans.modules.php.apigen.ui.ApiGenPreferences;
import org.netbeans.modules.php.apigen.ui.customizer.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

final class ApiGenPanel
extends JPanel {
    private static final long serialVersionUID = -1547854687946312L;
    private static final String SEPARATOR = ",";
    private final PhpModule phpModule;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel accessLevelLabel;
    private JCheckBox accessLevelPrivateCheckBox;
    private JCheckBox accessLevelProtectedCheckBox;
    private JCheckBox accessLevelPublicCheckBox;
    private JLabel charsetsInfoLabel;
    private JLabel charsetsLabel;
    private JTextField charsetsTextField;
    private JButton configButton;
    private ButtonGroup configButtonGroup;
    private JLabel configLabel;
    private JRadioButton configRadioButton;
    private JTextField configTextField;
    private JCheckBox deprecatedCheckBox;
    private JCheckBox downloadCheckBox;
    private JLabel excludesInfoLabel;
    private JLabel excludesLabel;
    private JTextField excludesTextField;
    private JCheckBox internalCheckBox;
    private JRadioButton noConfigRadioButton;
    private JCheckBox phpCheckBox;
    private JCheckBox sourceCodeCheckBox;
    private JButton targetButton;
    private JLabel targetLabel;
    private JTextField targetTextField;
    private JLabel titleLabel;
    private JTextField titleTextField;
    private JCheckBox todoCheckBox;
    private JCheckBox treeCheckBox;

    ApiGenPanel(PhpModule phpModule) {
        assert (EventQueue.isDispatchThread());
        assert (phpModule != null);
        this.phpModule = phpModule;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.charsetsInfoLabel.setText(Bundle.ApiGenPanel_info_csv());
        this.excludesInfoLabel.setText(Bundle.ApiGenPanel_info_csv());
        this.internalCheckBox.setToolTipText(Bundle.ApiGenPanel_internal_toolTip());
        this.phpCheckBox.setToolTipText(Bundle.ApiGenPanel_php_toolTip());
        this.treeCheckBox.setToolTipText(Bundle.ApiGenPanel_tree_toolTip());
        this.deprecatedCheckBox.setToolTipText(Bundle.ApiGenPanel_deprecated_toolTip());
        this.todoCheckBox.setToolTipText(Bundle.ApiGenPanel_todo_toolTip());
        this.downloadCheckBox.setToolTipText(Bundle.ApiGenPanel_download_toolTip());
        this.sourceCodeCheckBox.setToolTipText(Bundle.ApiGenPanel_sourceCode_toolTip());
        this.configRadioButton.setSelected(ApiGenPreferences.getBoolean(this.phpModule, ApiGenPreferences.HAS_CONFIG));
        this.targetTextField.setText(ApiGenPreferences.getTarget(this.phpModule, false));
        this.titleTextField.setText(ApiGenPreferences.get(this.phpModule, ApiGenPreferences.TITLE));
        this.configTextField.setText(ApiGenPreferences.get(this.phpModule, ApiGenPreferences.CONFIG));
        this.charsetsTextField.setText(StringUtils.implode(ApiGenPreferences.getMore(this.phpModule, ApiGenPreferences.CHARSETS), (String)SEPARATOR));
        this.excludesTextField.setText(StringUtils.implode(ApiGenPreferences.getMore(this.phpModule, ApiGenPreferences.EXCLUDES), (String)SEPARATOR));
        HashSet<String> accessLevels = new HashSet<String>(ApiGenPreferences.getMore(this.phpModule, ApiGenPreferences.ACCESS_LEVELS));
        this.accessLevelPublicCheckBox.setSelected(accessLevels.contains("public"));
        this.accessLevelProtectedCheckBox.setSelected(accessLevels.contains("protected"));
        this.accessLevelPrivateCheckBox.setSelected(accessLevels.contains("private"));
        this.internalCheckBox.setSelected(ApiGenPreferences.getBoolean(this.phpModule, ApiGenPreferences.INTERNAL));
        this.phpCheckBox.setSelected(ApiGenPreferences.getBoolean(this.phpModule, ApiGenPreferences.PHP));
        this.treeCheckBox.setSelected(ApiGenPreferences.getBoolean(this.phpModule, ApiGenPreferences.TREE));
        this.deprecatedCheckBox.setSelected(ApiGenPreferences.getBoolean(this.phpModule, ApiGenPreferences.DEPRECATED));
        this.todoCheckBox.setSelected(ApiGenPreferences.getBoolean(this.phpModule, ApiGenPreferences.TODO));
        this.downloadCheckBox.setSelected(ApiGenPreferences.getBoolean(this.phpModule, ApiGenPreferences.DOWNLOAD));
        this.sourceCodeCheckBox.setSelected(ApiGenPreferences.getBoolean(this.phpModule, ApiGenPreferences.SOURCE_CODE));
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        DefaultActionListener defaultActionListener = new DefaultActionListener();
        this.configRadioButton.addItemListener(new ConfigItemListener());
        this.targetTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.titleTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.configTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.charsetsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.excludesTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.accessLevelPublicCheckBox.addActionListener(defaultActionListener);
        this.accessLevelProtectedCheckBox.addActionListener(defaultActionListener);
        this.accessLevelPrivateCheckBox.addActionListener(defaultActionListener);
        this.configEnabled(this.configRadioButton.isSelected());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private boolean hasConfig() {
        return this.configRadioButton.isSelected();
    }

    private String getTarget() {
        return this.targetTextField.getText().trim();
    }

    private String getTitle() {
        return this.titleTextField.getText().trim();
    }

    private String getConfig() {
        return this.configTextField.getText().trim();
    }

    private List<String> getCharsets() {
        String charsets = this.charsetsTextField.getText().trim();
        if (StringUtils.hasText((String)charsets)) {
            return StringUtils.explode((String)charsets, (String)SEPARATOR);
        }
        return Collections.emptyList();
    }

    private List<String> getExcludes() {
        String excludes = this.excludesTextField.getText().trim();
        if (StringUtils.hasText((String)excludes)) {
            return StringUtils.explode((String)excludes, (String)SEPARATOR);
        }
        return Collections.emptyList();
    }

    private List<String> getAccessLevels() {
        ArrayList<String> levels = new ArrayList<String>(3);
        if (this.accessLevelPublicCheckBox.isSelected()) {
            levels.add("public");
        }
        if (this.accessLevelProtectedCheckBox.isSelected()) {
            levels.add("protected");
        }
        if (this.accessLevelPrivateCheckBox.isSelected()) {
            levels.add("private");
        }
        return levels;
    }

    private boolean getInternal() {
        return this.internalCheckBox.isSelected();
    }

    private boolean getPhp() {
        return this.phpCheckBox.isSelected();
    }

    private boolean getTree() {
        return this.treeCheckBox.isSelected();
    }

    private boolean getDeprecated() {
        return this.deprecatedCheckBox.isSelected();
    }

    private boolean getTodo() {
        return this.todoCheckBox.isSelected();
    }

    private boolean getDownload() {
        return this.downloadCheckBox.isSelected();
    }

    private boolean getSourceCode() {
        return this.sourceCodeCheckBox.isSelected();
    }

    void configEnabled(boolean enabled) {
        this.targetLabel.setEnabled(!enabled);
        this.targetTextField.setEnabled(!enabled);
        this.targetButton.setEnabled(!enabled);
        this.titleLabel.setEnabled(!enabled);
        this.titleTextField.setEnabled(!enabled);
        this.charsetsLabel.setEnabled(!enabled);
        this.charsetsTextField.setEnabled(!enabled);
        this.charsetsInfoLabel.setEnabled(!enabled);
        this.excludesLabel.setEnabled(!enabled);
        this.excludesTextField.setEnabled(!enabled);
        this.excludesInfoLabel.setEnabled(!enabled);
        this.accessLevelLabel.setEnabled(!enabled);
        this.accessLevelPublicCheckBox.setEnabled(!enabled);
        this.accessLevelProtectedCheckBox.setEnabled(!enabled);
        this.accessLevelPrivateCheckBox.setEnabled(!enabled);
        this.internalCheckBox.setEnabled(!enabled);
        this.phpCheckBox.setEnabled(!enabled);
        this.treeCheckBox.setEnabled(!enabled);
        this.deprecatedCheckBox.setEnabled(!enabled);
        this.todoCheckBox.setEnabled(!enabled);
        this.downloadCheckBox.setEnabled(!enabled);
        this.sourceCodeCheckBox.setEnabled(!enabled);
        this.configLabel.setEnabled(enabled);
        this.configTextField.setEnabled(enabled);
        this.configButton.setEnabled(enabled);
    }

    boolean isValidData() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        if (this.hasConfig()) {
            return this.validateConfigFile(true);
        }
        return this.validateManualConfig(true);
    }

    public String getWarningMessage() {
        if (this.hasConfig()) {
            return this.validateConfigFile(false);
        }
        return this.validateManualConfig(false);
    }

    private String validateConfigFile(boolean forErrors) {
        String config = this.getConfig();
        if (forErrors) {
            return FileUtils.validateFile((String)config, (boolean)false);
        }
        File configFile = new File(config);
        if (!configFile.getName().endsWith(".neon")) {
            return Bundle.ApiGenPanel_warn_configNotNeon();
        }
        return null;
    }

    private String validateManualConfig(boolean forErrors) {
        String target = this.getTarget();
        if (forErrors) {
            if (StringUtils.hasText((String)target)) {
                File targetDir = new File(target);
                if (targetDir.exists()) {
                    return FileUtils.validateDirectory((String)target, (boolean)true);
                }
                if (!targetDir.isAbsolute()) {
                    return Bundle.ApiGenPanel_error_relativeTarget();
                }
            }
            if (!StringUtils.hasText((String)this.getTitle())) {
                return Bundle.ApiGenPanel_error_invalidTitle();
            }
            if (this.getCharsets().isEmpty()) {
                return Bundle.ApiGenPanel_error_invalidCharsets();
            }
            if (!(this.accessLevelPublicCheckBox.isSelected() || this.accessLevelProtectedCheckBox.isSelected() || this.accessLevelPrivateCheckBox.isSelected())) {
                return Bundle.ApiGenPanel_error_invalidAccessLevels();
            }
            return null;
        }
        String defaultCharset = ApiGenPreferences.CHARSETS.getDefaultValue(this.phpModule);
        if (this.getCharsets().indexOf(defaultCharset) == -1) {
            return Bundle.ApiGenPanel_warn_missingCharset(defaultCharset);
        }
        if (!StringUtils.hasText((String)target)) {
            return Bundle.ApiGenPanel_warn_nbWillAskForDir();
        }
        if (!new File(target).exists()) {
            return Bundle.ApiGenPanel_warn_targetDirWillBeCreated();
        }
        return null;
    }

    public void storeData() {
        ApiGenPreferences.putBoolean(this.phpModule, ApiGenPreferences.HAS_CONFIG, this.hasConfig());
        ApiGenPreferences.putTarget(this.phpModule, this.getTarget());
        ApiGenPreferences.put(this.phpModule, ApiGenPreferences.TITLE, this.getTitle());
        ApiGenPreferences.put(this.phpModule, ApiGenPreferences.CONFIG, this.getConfig());
        ApiGenPreferences.putMore(this.phpModule, ApiGenPreferences.CHARSETS, this.getCharsets());
        ApiGenPreferences.putMore(this.phpModule, ApiGenPreferences.EXCLUDES, this.getExcludes());
        ApiGenPreferences.putMore(this.phpModule, ApiGenPreferences.ACCESS_LEVELS, this.getAccessLevels());
        ApiGenPreferences.putBoolean(this.phpModule, ApiGenPreferences.INTERNAL, this.getInternal());
        ApiGenPreferences.putBoolean(this.phpModule, ApiGenPreferences.PHP, this.getPhp());
        ApiGenPreferences.putBoolean(this.phpModule, ApiGenPreferences.TREE, this.getTree());
        ApiGenPreferences.putBoolean(this.phpModule, ApiGenPreferences.DEPRECATED, this.getDeprecated());
        ApiGenPreferences.putBoolean(this.phpModule, ApiGenPreferences.TODO, this.getTodo());
        ApiGenPreferences.putBoolean(this.phpModule, ApiGenPreferences.DOWNLOAD, this.getDownload());
        ApiGenPreferences.putBoolean(this.phpModule, ApiGenPreferences.SOURCE_CODE, this.getSourceCode());
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.configButtonGroup = new ButtonGroup();
        this.noConfigRadioButton = new JRadioButton();
        this.targetLabel = new JLabel();
        this.targetTextField = new JTextField();
        this.targetButton = new JButton();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.charsetsLabel = new JLabel();
        this.charsetsTextField = new JTextField();
        this.charsetsInfoLabel = new JLabel();
        this.excludesLabel = new JLabel();
        this.excludesTextField = new JTextField();
        this.excludesInfoLabel = new JLabel();
        this.accessLevelLabel = new JLabel();
        this.accessLevelPublicCheckBox = new JCheckBox();
        this.accessLevelProtectedCheckBox = new JCheckBox();
        this.accessLevelPrivateCheckBox = new JCheckBox();
        this.internalCheckBox = new JCheckBox();
        this.phpCheckBox = new JCheckBox();
        this.treeCheckBox = new JCheckBox();
        this.deprecatedCheckBox = new JCheckBox();
        this.todoCheckBox = new JCheckBox();
        this.downloadCheckBox = new JCheckBox();
        this.sourceCodeCheckBox = new JCheckBox();
        this.configRadioButton = new JRadioButton();
        this.configLabel = new JLabel();
        this.configTextField = new JTextField();
        this.configButton = new JButton();
        this.configButtonGroup.add(this.noConfigRadioButton);
        this.noConfigRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.noConfigRadioButton, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.noConfigRadioButton.text"));
        this.targetLabel.setLabelFor(this.targetTextField);
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.targetLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.targetButton, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.targetButton.text"));
        this.targetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ApiGenPanel.this.targetButtonActionPerformed(evt);
            }
        });
        this.titleLabel.setLabelFor(this.titleTextField);
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.titleLabel.text"));
        this.charsetsLabel.setLabelFor(this.charsetsTextField);
        Mnemonics.setLocalizedText((JLabel)this.charsetsLabel, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.charsetsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.charsetsInfoLabel, (String)"INFO");
        Mnemonics.setLocalizedText((JLabel)this.excludesLabel, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.excludesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.excludesInfoLabel, (String)"INFO");
        this.accessLevelLabel.setLabelFor(this.accessLevelPublicCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.accessLevelLabel, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.accessLevelLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.accessLevelPublicCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.accessLevelPublicCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.accessLevelProtectedCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.accessLevelProtectedCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.accessLevelPrivateCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.accessLevelPrivateCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.internalCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.internalCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.phpCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.treeCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.treeCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.deprecatedCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.deprecatedCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.todoCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.todoCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.downloadCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.downloadCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.sourceCodeCheckBox, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.sourceCodeCheckBox.text"));
        this.configButtonGroup.add(this.configRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.configRadioButton, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.configRadioButton.text"));
        this.configLabel.setLabelFor(this.configTextField);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.configLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configButton, (String)NbBundle.getMessage(ApiGenPanel.class, (String)"ApiGenPanel.configButton.text"));
        this.configButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ApiGenPanel.this.configButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(116, 116, 116).addComponent(this.targetTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetButton)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.configLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noConfigRadioButton).addComponent(this.configRadioButton)).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.targetLabel).addComponent(this.titleLabel).addComponent(this.charsetsLabel).addComponent(this.excludesLabel).addComponent(this.accessLevelLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.accessLevelPublicCheckBox).addComponent(this.internalCheckBox).addComponent(this.phpCheckBox).addComponent(this.treeCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.accessLevelProtectedCheckBox).addComponent(this.deprecatedCheckBox).addComponent(this.todoCheckBox).addComponent(this.downloadCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.accessLevelPrivateCheckBox).addComponent(this.sourceCodeCheckBox))).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.charsetsTextField).addComponent(this.excludesTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.excludesInfoLabel).addComponent(this.charsetsInfoLabel)).addGap(0, 242, Short.MAX_VALUE)).addComponent(this.titleTextField))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.noConfigRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetLabel).addComponent(this.targetTextField, -2, -1, -2).addComponent(this.targetButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.charsetsLabel).addComponent(this.charsetsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.charsetsInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.excludesTextField, -2, -1, -2).addComponent(this.excludesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludesInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accessLevelPublicCheckBox).addComponent(this.accessLevelProtectedCheckBox).addComponent(this.accessLevelPrivateCheckBox).addComponent(this.accessLevelLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.internalCheckBox).addComponent(this.deprecatedCheckBox).addComponent(this.sourceCodeCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpCheckBox).addComponent(this.todoCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.treeCheckBox).addComponent(this.downloadCheckBox)).addGap(18, 18, 18).addComponent(this.configRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configLabel).addComponent(this.configTextField, -2, -1, -2).addComponent(this.configButton)).addContainerGap(16, Short.MAX_VALUE)));
    }

    private void targetButtonActionPerformed(ActionEvent evt) {
        File target = new FileChooserBuilder(ApiGenProvider.lastDirFor(this.phpModule)).setTitle(Bundle.ApiGenPanel_target_title()).setDirectoriesOnly(true).setFileHiding(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).showOpenDialog();
        if (target != null) {
            target = FileUtil.normalizeFile((File)target);
            this.targetTextField.setText(target.getAbsolutePath());
        }
    }

    private void configButtonActionPerformed(ActionEvent evt) {
        File config = new FileChooserBuilder(ApiGenProvider.lastDirFor(this.phpModule)).setTitle(Bundle.ApiGenPanel_config_title()).setFilesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).showOpenDialog();
        if (config != null) {
            config = FileUtil.normalizeFile((File)config);
            this.configTextField.setText(config.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            ApiGenPanel.this.fireChange();
        }
    }

    private final class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ApiGenPanel.this.fireChange();
        }
    }

    private final class ConfigItemListener
    implements ItemListener {
        private ConfigItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ApiGenPanel.this.configEnabled(e.getStateChange() == 1);
            ApiGenPanel.this.fireChange();
        }
    }
}

