/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelProvider;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttributeType;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagType;
import org.netbeans.modules.html.editor.lib.api.model.NamedCharRef;
import org.netbeans.modules.html.editor.lib.dtd.DTD;

public class Html4ModelProvider
implements HtmlModelProvider {
    private static final Map<HtmlVersion, Collection<HtmlTag>> ALL_TAGS_MAP = new EnumMap<HtmlVersion, Collection<HtmlTag>>(HtmlVersion.class);

    private static synchronized Collection<HtmlTag> getAllTags(HtmlVersion version) {
        Collection<HtmlTag> value = ALL_TAGS_MAP.get((Object)version);
        if (value == null) {
            DTD dtd = version.getDTD();
            assert (dtd != null);
            List all = dtd.getElementList("");
            value = new ArrayList<HtmlTag>();
            for (DTD.Element e : all) {
                value.add(DTD2HtmlTag.getTagForElement(dtd, e));
            }
            ALL_TAGS_MAP.put(version, value);
        }
        return value;
    }

    @Override
    public HtmlModel getModel(HtmlVersion version) {
        switch (version) {
            case HTML32: 
            case HTML40_FRAMESET: 
            case HTML40_STRICT: 
            case HTML40_TRANSATIONAL: 
            case HTML41_FRAMESET: 
            case HTML41_STRICT: 
            case HTML41_TRANSATIONAL: 
            case XHTML10_FRAMESET: 
            case XHTML10_STICT: 
            case XHTML10_TRANSATIONAL: 
            case XHTML11: {
                return new Html4Model(version);
            }
        }
        return null;
    }

    private static class DTD2HtmlTag {
        private static final Logger LOGGER = Logger.getLogger(DTD2HtmlTag.class.getName());
        private static HashMap<DTD.Element, HtmlTag> MAP = new HashMap();
        private static HashMap<DTD.Attribute, HtmlTagAttribute> ATTRS_MAP = new HashMap();

        private DTD2HtmlTag() {
        }

        private static synchronized HtmlTag getTagForElement(DTD dtd, DTD.Element elementName) {
            HtmlTag impl = MAP.get(elementName);
            if (impl == null) {
                impl = new DTDElement2HtmlTagAdapter(dtd, elementName);
                MAP.put(elementName, impl);
            }
            return impl;
        }

        private static Collection<HtmlTag> convert(DTD dtd, Collection<DTD.Element> elements) {
            ArrayList<HtmlTag> converted = new ArrayList<HtmlTag>();
            for (DTD.Element element : elements) {
                assert (element != null);
                converted.add(DTD2HtmlTag.getTagForElement(dtd, element));
            }
            return converted;
        }

        private static synchronized HtmlTagAttribute getHtmlTagAttribute(DTD.Attribute attribute) {
            HtmlTagAttribute attr = ATTRS_MAP.get(attribute);
            if (attr == null) {
                attr = new Attribute2HtmlTagAttribute(attribute);
                ATTRS_MAP.put(attribute, attr);
            }
            return attr;
        }

        private static class DTDElement2HtmlTagAdapter
        implements HtmlTag {
            private DTD.Element element;
            private DTD dtd;
            private Collection<HtmlTagAttribute> attrs;
            private Collection<HtmlTag> children;

            private DTDElement2HtmlTagAdapter(DTD dtd, DTD.Element element) {
                this.dtd = dtd;
                this.element = element;
                this.attrs = this.wrap(element.getAttributeList(null));
            }

            private Collection<HtmlTagAttribute> wrap(Collection<DTD.Attribute> attrNames) {
                if (attrNames == null) {
                    return Collections.emptyList();
                }
                LinkedList<HtmlTagAttribute> attributes = new LinkedList<HtmlTagAttribute>();
                for (DTD.Attribute an : attrNames) {
                    HtmlTagAttribute hta = DTD2HtmlTag.getHtmlTagAttribute(an);
                    if (hta != null) {
                        attributes.add(hta);
                        continue;
                    }
                    LOGGER.info("Unknown attribute " + an + " requested.");
                }
                return attributes;
            }

            @Override
            public String getName() {
                return this.element.getName();
            }

            @Override
            public Collection<HtmlTagAttribute> getAttributes() {
                return this.attrs;
            }

            @Override
            public boolean isEmpty() {
                return this.element.isEmpty();
            }

            @Override
            public boolean hasOptionalOpenTag() {
                return this.element.hasOptionalStart();
            }

            @Override
            public boolean hasOptionalEndTag() {
                return this.element.hasOptionalEnd();
            }

            @Override
            public HtmlTagAttribute getAttribute(String name) {
                DTD.Attribute attr = this.element.getAttribute(name);
                if (attr == null) {
                    return null;
                }
                return DTD2HtmlTag.getHtmlTagAttribute(attr);
            }

            @Override
            public HtmlTagType getTagClass() {
                return HtmlTagType.HTML;
            }

            @Override
            public synchronized Collection<HtmlTag> getChildren() {
                if (this.children == null) {
                    DTD.Element bodyElement;
                    HashSet<DTD.Element> set = new HashSet<DTD.Element>();
                    for (DTD.Element el : this.element.getContentModel().getIncludes()) {
                        if (el == null) continue;
                        set.add(el);
                    }
                    for (DTD.Element el : this.element.getContentModel().getExcludes()) {
                        if (el == null) continue;
                        set.remove(el);
                    }
                    for (DTD.Element el : this.element.getContentModel().getContent().getPossibleElements()) {
                        if (el == null) continue;
                        set.add(el);
                    }
                    if (this.element.getName().equalsIgnoreCase("HTML") && (bodyElement = this.dtd.getElement("BODY")) != null) {
                        set.add(bodyElement);
                    }
                    this.children = DTD2HtmlTag.convert(this.dtd, set);
                }
                return this.children;
            }

            @Override
            public HelpItem getHelp() {
                return null;
            }
        }

        private static class Attribute2HtmlTagAttribute
        implements HtmlTagAttribute {
            private DTD.Attribute attr;

            public Attribute2HtmlTagAttribute(DTD.Attribute attr) {
                this.attr = attr;
            }

            @Override
            public String getName() {
                return this.attr.getName();
            }

            @Override
            public boolean isRequired() {
                return this.attr.isRequired();
            }

            @Override
            public HtmlTagAttributeType getType() {
                switch (this.attr.getType()) {
                    case 0: {
                        return HtmlTagAttributeType.BOOLEAN;
                    }
                    case 1: {
                        return HtmlTagAttributeType.SET;
                    }
                    case 2: {
                        return HtmlTagAttributeType.GENERIC;
                    }
                }
                return HtmlTagAttributeType.GENERIC;
            }

            @Override
            public Collection<String> getPossibleValues() {
                List values = this.attr.getValueList(null);
                if (values == null) {
                    return Collections.emptyList();
                }
                LinkedList<String> res = new LinkedList<String>();
                for (DTD.Value v : values) {
                    res.add(v.getName());
                }
                return res;
            }

            @Override
            public HelpItem getHelp() {
                return null;
            }
        }
    }

    private static class Html4Model
    implements HtmlModel {
        private HtmlVersion version;

        public Html4Model(HtmlVersion version) {
            this.version = version;
        }

        @Override
        public Collection<HtmlTag> getAllTags() {
            return Html4ModelProvider.getAllTags(this.version);
        }

        @Override
        public HtmlTag getTag(String tagName) {
            DTD.Element element = this.version.getDTD().getElement(tagName);
            if (element == null) {
                return null;
            }
            return DTD2HtmlTag.getTagForElement(this.version.getDTD(), element);
        }

        public Collection<NamedCharRef> getNamedCharacterReferences() {
            return this.version.getDTD().getCharRefList("");
        }

        @Override
        public String getModelId() {
            return "html4model";
        }
    }
}

