/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AcdAvmResourceStats
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="provisionedCpus")
    private final Float provisionedCpus;
    @JsonProperty(value="usedCpus")
    private final Float usedCpus;
    @JsonProperty(value="reservedCpus")
    private final Float reservedCpus;
    @JsonProperty(value="reclaimableCpus")
    private final Float reclaimableCpus;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "provisionedCpus", "usedCpus", "reservedCpus", "reclaimableCpus"})
    public AcdAvmResourceStats(String id, String displayName, Float provisionedCpus, Float usedCpus, Float reservedCpus, Float reclaimableCpus) {
        this.id = id;
        this.displayName = displayName;
        this.provisionedCpus = provisionedCpus;
        this.usedCpus = usedCpus;
        this.reservedCpus = reservedCpus;
        this.reclaimableCpus = reclaimableCpus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Float getProvisionedCpus() {
        return this.provisionedCpus;
    }

    public Float getUsedCpus() {
        return this.usedCpus;
    }

    public Float getReservedCpus() {
        return this.reservedCpus;
    }

    public Float getReclaimableCpus() {
        return this.reclaimableCpus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AcdAvmResourceStats(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", provisionedCpus=").append(String.valueOf(this.provisionedCpus));
        sb.append(", usedCpus=").append(String.valueOf(this.usedCpus));
        sb.append(", reservedCpus=").append(String.valueOf(this.reservedCpus));
        sb.append(", reclaimableCpus=").append(String.valueOf(this.reclaimableCpus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AcdAvmResourceStats)) {
            return false;
        }
        AcdAvmResourceStats other = (AcdAvmResourceStats)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.provisionedCpus, other.provisionedCpus) && Objects.equals(this.usedCpus, other.usedCpus) && Objects.equals(this.reservedCpus, other.reservedCpus) && Objects.equals(this.reclaimableCpus, other.reclaimableCpus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.provisionedCpus == null ? 43 : this.provisionedCpus.hashCode());
        result = result * 59 + (this.usedCpus == null ? 43 : this.usedCpus.hashCode());
        result = result * 59 + (this.reservedCpus == null ? 43 : this.reservedCpus.hashCode());
        result = result * 59 + (this.reclaimableCpus == null ? 43 : this.reclaimableCpus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="provisionedCpus")
        private Float provisionedCpus;
        @JsonProperty(value="usedCpus")
        private Float usedCpus;
        @JsonProperty(value="reservedCpus")
        private Float reservedCpus;
        @JsonProperty(value="reclaimableCpus")
        private Float reclaimableCpus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder provisionedCpus(Float provisionedCpus) {
            this.provisionedCpus = provisionedCpus;
            this.__explicitlySet__.add("provisionedCpus");
            return this;
        }

        public Builder usedCpus(Float usedCpus) {
            this.usedCpus = usedCpus;
            this.__explicitlySet__.add("usedCpus");
            return this;
        }

        public Builder reservedCpus(Float reservedCpus) {
            this.reservedCpus = reservedCpus;
            this.__explicitlySet__.add("reservedCpus");
            return this;
        }

        public Builder reclaimableCpus(Float reclaimableCpus) {
            this.reclaimableCpus = reclaimableCpus;
            this.__explicitlySet__.add("reclaimableCpus");
            return this;
        }

        public AcdAvmResourceStats build() {
            AcdAvmResourceStats model = new AcdAvmResourceStats(this.id, this.displayName, this.provisionedCpus, this.usedCpus, this.reservedCpus, this.reclaimableCpus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AcdAvmResourceStats model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("provisionedCpus")) {
                this.provisionedCpus(model.getProvisionedCpus());
            }
            if (model.wasPropertyExplicitlySet("usedCpus")) {
                this.usedCpus(model.getUsedCpus());
            }
            if (model.wasPropertyExplicitlySet("reservedCpus")) {
                this.reservedCpus(model.getReservedCpus());
            }
            if (model.wasPropertyExplicitlySet("reclaimableCpus")) {
                this.reclaimableCpus(model.getReclaimableCpus());
            }
            return this;
        }
    }
}

