/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.utils;

import java.util.regex.Pattern;

public class SpringWebFrameworkUtils {
    private static final char[] INVALID_CHARS = new char[]{'<', '>', '*', '\\', ':', '\"', '/', '%', '|', '?'};

    public static boolean isDispatcherServletConfigFilenameValid(String name) {
        boolean isNameValid = true;
        for (char c : INVALID_CHARS) {
            if (name.indexOf(c) == -1) continue;
            isNameValid = false;
            break;
        }
        return isNameValid;
    }

    public static boolean isDispatcherMappingPatternValid(String pattern) {
        if (pattern.startsWith("*.")) {
            String p = pattern.substring(2);
            return Pattern.matches("\\w+", p);
        }
        if (pattern.length() > 3 && pattern.endsWith("/*") && pattern.startsWith("/") && !pattern.contains(" ")) {
            return true;
        }
        return pattern.matches("/");
    }

    public static String instantiateDispatcherMapping(String dispatcherMapping, String page) {
        String result = dispatcherMapping.equals("/") ? page : dispatcherMapping.replace("*", page);
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String getSimpleDispatcherURL(String fullDispatcherURL) {
        int lastSlash = fullDispatcherURL.lastIndexOf(47);
        if (lastSlash >= 0) {
            return fullDispatcherURL.substring(lastSlash + 1);
        }
        return fullDispatcherURL;
    }
}

