/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class FinalModifierHintError
extends HintErrorRule {
    private FileObject fileObject;
    private Set<TypeConstantElement> inheritedClassConstants = Collections.emptySet();
    private String classSignatureForInheritedClassConstants = "";

    public String getDisplayName() {
        return Bundle.FinalModifierHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            for (ConstantDeclaration constant : checkVisitor.getIncorrectFinalPrivateConstants()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                OffsetRange finalRange = this.getFinalRange(constant, phpParseResult);
                if (finalRange == OffsetRange.NONE) continue;
                this.addHint(finalRange, Bundle.FinalModifierHintError_finalPrivateConstants_desc(), hints, this.createFixes(finalRange, context.doc));
            }
            this.checkOverridingFinalConstants(fileScope, phpParseResult, hints);
        }
    }

    private OffsetRange getFinalRange(ConstantDeclaration incorrectConstant, PHPParseResult parserResult) {
        int startOffset = incorrectConstant.getStartOffset();
        TokenHierarchy th = parserResult.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return OffsetRange.NONE;
        }
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(th, startOffset);
        if (ts == null) {
            return OffsetRange.NONE;
        }
        ts.move(startOffset);
        if (ts.moveNext()) {
            Token<? extends PHPTokenId> nextFinalToken = LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_FINAL));
            if (nextFinalToken == null) {
                return OffsetRange.NONE;
            }
            int finalStart = ts.offset();
            int finalEnd = finalStart + "final".length();
            return new OffsetRange(finalStart, finalEnd);
        }
        return OffsetRange.NONE;
    }

    private List<HintFix> createFixes(OffsetRange finalRange, BaseDocument document) {
        List<HintFix> fixes = Collections.emptyList();
        if (finalRange != OffsetRange.NONE) {
            fixes = Collections.singletonList(new Fix(new OffsetRange(finalRange.getStart(), finalRange.getEnd() + 1), document));
        }
        return fixes;
    }

    private void checkOverridingFinalConstants(FileScope fileScope, PHPParseResult phpParseResult, List<Hint> hints) {
        Collection<? extends ClassScope> allClasses = ModelUtils.getDeclaredClasses(fileScope);
        ArrayList<ClassConstantElement> finalConstants = new ArrayList<ClassConstantElement>();
        for (ClassScope classScope : allClasses) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Collection<? extends ClassConstantElement> declaredConstants = classScope.getDeclaredConstants();
            for (ClassConstantElement classConstantElement : declaredConstants) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ElementFilter constantNameFilter = ElementFilter.forName(NameKind.exact(classConstantElement.getName()));
                Set<TypeConstantElement> overridenConstants = constantNameFilter.filter(this.getInheritedClassConstants(phpParseResult, classConstantElement));
                for (TypeConstantElement overridenConstant : overridenConstants) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    if (!overridenConstant.getPhpModifiers().isFinal()) continue;
                    finalConstants.add(classConstantElement);
                }
            }
        }
        for (ClassConstantElement classConstantElement : finalConstants) {
            this.addHint(classConstantElement.getNameRange(), Bundle.FinalModifierHintError_overridingFinalConstant_desc(classConstantElement.getName()), hints, Collections.emptyList());
        }
    }

    private Set<TypeConstantElement> getInheritedClassConstants(ParserResult info, ClassConstantElement constant) {
        Scope inScope = constant.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = typeScope.getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedClassConstants)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedClassConstants = index.getInheritedTypeConstants(typeScope);
        }
        this.classSignatureForInheritedClassConstants = signature;
        return Collections.unmodifiableSet(this.inheritedClassConstants);
    }

    private void addHint(OffsetRange offsetRange, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, offsetRange, fixes, 500));
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<ConstantDeclaration> incorrectFinalPrivateConstants = new ArrayList<ConstantDeclaration>();

        private CheckVisitor() {
        }

        @Override
        public void visit(ConstantDeclaration node) {
            int modifier;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!node.isGlobal() && BodyDeclaration.Modifier.isFinal(modifier = node.getModifier()) && BodyDeclaration.Modifier.isPrivate(modifier)) {
                this.incorrectFinalPrivateConstants.add(node);
            }
            super.visit(node);
        }

        public List<ConstantDeclaration> getIncorrectFinalPrivateConstants() {
            return Collections.unmodifiableList(this.incorrectFinalPrivateConstants);
        }
    }

    private static final class Fix
    implements HintFix {
        private final OffsetRange finalModifierRange;
        private final BaseDocument document;

        private Fix(OffsetRange finalModifierRange, BaseDocument document) {
            this.finalModifierRange = finalModifierRange;
            this.document = document;
        }

        public String getDescription() {
            return Bundle.IncorrectFinalHintError_Fix_Description();
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.document);
            edits.replace(this.finalModifierRange.getStart(), this.finalModifierRange.getLength(), "", true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

