/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.repository;

import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.replication.util.ExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lorg/opensearch/replication/repository/RestoreContext;", "Ljava/io/Closeable;", "restoreUUID", "", "shard", "Lorg/opensearch/index/shard/IndexShard;", "indexCommitRef", "Lorg/opensearch/common/concurrent/GatedCloseable;", "Lorg/apache/lucene/index/IndexCommit;", "metadataSnapshot", "Lorg/opensearch/index/store/Store$MetadataSnapshot;", "replayOperationsFrom", "", "(Ljava/lang/String;Lorg/opensearch/index/shard/IndexShard;Lorg/opensearch/common/concurrent/GatedCloseable;Lorg/opensearch/index/store/Store$MetadataSnapshot;J)V", "currentFiles", "Ljava/util/LinkedHashMap;", "Lorg/apache/lucene/store/IndexInput;", "Lkotlin/collections/LinkedHashMap;", "getIndexCommitRef", "()Lorg/opensearch/common/concurrent/GatedCloseable;", "getMetadataSnapshot", "()Lorg/opensearch/index/store/Store$MetadataSnapshot;", "getReplayOperationsFrom", "()J", "getRestoreUUID", "()Ljava/lang/String;", "getShard", "()Lorg/opensearch/index/shard/IndexShard;", "close", "", "openInput", "store", "Lorg/opensearch/index/store/Store;", "fileName", "Companion", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nRestoreContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestoreContext.kt\norg/opensearch/replication/repository/RestoreContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1855#2,2:60\n*S KotlinDebug\n*F\n+ 1 RestoreContext.kt\norg/opensearch/replication/repository/RestoreContext\n*L\n51#1:60,2\n*E\n"})
public final class RestoreContext
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String restoreUUID;
    @NotNull
    private final IndexShard shard;
    @NotNull
    private final GatedCloseable<IndexCommit> indexCommitRef;
    @NotNull
    private final Store.MetadataSnapshot metadataSnapshot;
    private final long replayOperationsFrom;
    @NotNull
    private final LinkedHashMap<String, IndexInput> currentFiles;
    private static final int INITIAL_FILE_CACHE_CAPACITY = 20;

    public RestoreContext(@NotNull String restoreUUID, @NotNull IndexShard shard, @NotNull GatedCloseable<IndexCommit> indexCommitRef, @NotNull Store.MetadataSnapshot metadataSnapshot, long replayOperationsFrom) {
        Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
        Intrinsics.checkNotNullParameter((Object)shard, (String)"shard");
        Intrinsics.checkNotNullParameter(indexCommitRef, (String)"indexCommitRef");
        Intrinsics.checkNotNullParameter((Object)metadataSnapshot, (String)"metadataSnapshot");
        this.restoreUUID = restoreUUID;
        this.shard = shard;
        this.indexCommitRef = indexCommitRef;
        this.metadataSnapshot = metadataSnapshot;
        this.replayOperationsFrom = replayOperationsFrom;
        this.currentFiles = new LinkedHashMap(20);
    }

    @NotNull
    public final String getRestoreUUID() {
        return this.restoreUUID;
    }

    @NotNull
    public final IndexShard getShard() {
        return this.shard;
    }

    @NotNull
    public final GatedCloseable<IndexCommit> getIndexCommitRef() {
        return this.indexCommitRef;
    }

    @NotNull
    public final Store.MetadataSnapshot getMetadataSnapshot() {
        return this.metadataSnapshot;
    }

    public final long getReplayOperationsFrom() {
        return this.replayOperationsFrom;
    }

    @NotNull
    public final IndexInput openInput(@NotNull Store store, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Ref.ObjectRef currentIndexInput = new Ref.ObjectRef();
        currentIndexInput.element = ((Map)this.currentFiles).getOrDefault(fileName, null);
        if (currentIndexInput.element != null) {
            IndexInput indexInput = ((IndexInput)currentIndexInput.element).clone();
            Intrinsics.checkNotNullExpressionValue((Object)indexInput, (String)"currentIndexInput.clone()");
            return indexInput;
        }
        ExtensionsKt.performOp$default(store, (Function0)new Function0<Unit>((Ref.ObjectRef<IndexInput>)currentIndexInput, store, fileName){
            final /* synthetic */ Ref.ObjectRef<IndexInput> $currentIndexInput;
            final /* synthetic */ Store $store;
            final /* synthetic */ String $fileName;
            {
                this.$currentIndexInput = $currentIndexInput;
                this.$store = $store;
                this.$fileName = $fileName;
                super(0);
            }

            public final void invoke() {
                this.$currentIndexInput.element = this.$store.directory().openInput(this.$fileName, IOContext.READONCE);
            }
        }, null, 2, null);
        Map map = this.currentFiles;
        Object object = currentIndexInput.element;
        Intrinsics.checkNotNull((Object)object);
        map.put(fileName, object);
        Object object2 = currentIndexInput.element;
        Intrinsics.checkNotNull((Object)object2);
        IndexInput indexInput = ((IndexInput)object2).clone();
        Intrinsics.checkNotNullExpressionValue((Object)indexInput, (String)"currentIndexInput!!.clone()");
        return indexInput;
    }

    @Override
    public void close() {
        Set<Map.Entry<String, IndexInput>> set = this.currentFiles.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"currentFiles.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((IndexInput)it.getValue()).close();
        }
        this.currentFiles.clear();
        this.indexCommitRef.close();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/replication/repository/RestoreContext$Companion;", "", "()V", "INITIAL_FILE_CACHE_CAPACITY", "", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

