/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.opensearch.analysis.common.CharMatcher;
import org.opensearch.analysis.common.NGramTokenizerFactory;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenizerFactory;

public class EdgeNGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final CharMatcher matcher;

    EdgeNGramTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings, name);
        this.minGram = settings.getAsInt("min_gram", Integer.valueOf(1));
        this.maxGram = settings.getAsInt("max_gram", Integer.valueOf(2));
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings);
    }

    public Tokenizer create() {
        if (this.matcher == null) {
            return new EdgeNGramTokenizer(this.minGram, this.maxGram);
        }
        return new EdgeNGramTokenizer(this.minGram, this.maxGram){

            protected boolean isTokenChar(int chr) {
                return EdgeNGramTokenizerFactory.this.matcher.isTokenChar(chr);
            }
        };
    }
}

