/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene;

import com.google.common.collect.ImmutableMap;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.function.BiFunction;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.analysis.NestedAnalyzer;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprByteValue;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDatetimeValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.opensearch.data.type.OpenSearchDateType;

public abstract class LuceneQuery {
    private final Map<FunctionName, BiFunction<LiteralExpression, ReferenceExpression, ExprValue>> castMap = ImmutableMap.builder().put((Object)BuiltinFunctionName.CAST_TO_STRING.getName(), (expr, ref) -> {
        if (!expr.type().equals((Object)ExprCoreType.STRING)) {
            return new ExprStringValue(String.valueOf(expr.valueOf().value()));
        }
        return expr.valueOf();
    }).put((Object)BuiltinFunctionName.CAST_TO_BYTE.getName(), (expr, ref) -> {
        if (ExprCoreType.numberTypes().contains(expr.type())) {
            return new ExprByteValue((Number)expr.valueOf().byteValue());
        }
        if (expr.type().equals((Object)ExprCoreType.BOOLEAN)) {
            return new ExprByteValue((Number)(expr.valueOf().booleanValue() != false ? 1 : 0));
        }
        return new ExprByteValue((Number)Byte.valueOf(expr.valueOf().stringValue()));
    }).put((Object)BuiltinFunctionName.CAST_TO_SHORT.getName(), (expr, ref) -> {
        if (ExprCoreType.numberTypes().contains(expr.type())) {
            return new ExprShortValue((Number)expr.valueOf().shortValue());
        }
        if (expr.type().equals((Object)ExprCoreType.BOOLEAN)) {
            return new ExprShortValue((Number)(expr.valueOf().booleanValue() != false ? 1 : 0));
        }
        return new ExprShortValue((Number)Short.valueOf(expr.valueOf().stringValue()));
    }).put((Object)BuiltinFunctionName.CAST_TO_INT.getName(), (expr, ref) -> {
        if (ExprCoreType.numberTypes().contains(expr.type())) {
            return new ExprIntegerValue((Number)expr.valueOf().integerValue());
        }
        if (expr.type().equals((Object)ExprCoreType.BOOLEAN)) {
            return new ExprIntegerValue((Number)(expr.valueOf().booleanValue() != false ? 1 : 0));
        }
        return new ExprIntegerValue((Number)Integer.valueOf(expr.valueOf().stringValue()));
    }).put((Object)BuiltinFunctionName.CAST_TO_LONG.getName(), (expr, ref) -> {
        if (ExprCoreType.numberTypes().contains(expr.type())) {
            return new ExprLongValue((Number)expr.valueOf().longValue());
        }
        if (expr.type().equals((Object)ExprCoreType.BOOLEAN)) {
            return new ExprLongValue((Number)(expr.valueOf().booleanValue() != false ? 1 : 0));
        }
        return new ExprLongValue((Number)Long.valueOf(expr.valueOf().stringValue()));
    }).put((Object)BuiltinFunctionName.CAST_TO_FLOAT.getName(), (expr, ref) -> {
        if (ExprCoreType.numberTypes().contains(expr.type())) {
            return new ExprFloatValue((Number)expr.valueOf().floatValue());
        }
        if (expr.type().equals((Object)ExprCoreType.BOOLEAN)) {
            return new ExprFloatValue((Number)(expr.valueOf().booleanValue() != false ? 1 : 0));
        }
        return new ExprFloatValue((Number)Float.valueOf(expr.valueOf().stringValue()));
    }).put((Object)BuiltinFunctionName.CAST_TO_DOUBLE.getName(), (expr, ref) -> {
        if (ExprCoreType.numberTypes().contains(expr.type())) {
            return new ExprDoubleValue((Number)expr.valueOf().doubleValue());
        }
        if (expr.type().equals((Object)ExprCoreType.BOOLEAN)) {
            return new ExprDoubleValue((Number)(expr.valueOf().booleanValue() != false ? 1 : 0));
        }
        return new ExprDoubleValue((Number)Double.valueOf(expr.valueOf().stringValue()));
    }).put((Object)BuiltinFunctionName.CAST_TO_BOOLEAN.getName(), (expr, ref) -> {
        if (ExprCoreType.numberTypes().contains(expr.type())) {
            return expr.valueOf().doubleValue() != 0.0 ? ExprBooleanValue.of((Boolean)true) : ExprBooleanValue.of((Boolean)false);
        }
        if (expr.type().equals((Object)ExprCoreType.STRING)) {
            return ExprBooleanValue.of((Boolean)Boolean.valueOf(expr.valueOf().stringValue()));
        }
        return expr.valueOf();
    }).put((Object)BuiltinFunctionName.CAST_TO_DATE.getName(), (expr, ref) -> {
        if (expr.type().equals((Object)ExprCoreType.STRING)) {
            ZonedDateTime zonedDateTime = this.getParsedDateTime((LiteralExpression)expr, (ReferenceExpression)ref);
            if (zonedDateTime != null) {
                return new ExprDateValue(zonedDateTime.toLocalDate());
            }
            return new ExprDateValue(expr.valueOf().stringValue());
        }
        return new ExprDateValue(expr.valueOf().dateValue());
    }).put((Object)BuiltinFunctionName.CAST_TO_TIME.getName(), (expr, ref) -> {
        if (expr.type().equals((Object)ExprCoreType.STRING)) {
            ZonedDateTime zonedDateTime = this.getParsedDateTime((LiteralExpression)expr, (ReferenceExpression)ref);
            if (zonedDateTime != null) {
                return new ExprTimeValue(zonedDateTime.toLocalTime());
            }
            return new ExprTimeValue(expr.valueOf().stringValue());
        }
        return new ExprTimeValue(expr.valueOf().timeValue());
    }).put((Object)BuiltinFunctionName.CAST_TO_DATETIME.getName(), (expr, ref) -> {
        if (expr.type().equals((Object)ExprCoreType.STRING)) {
            return new ExprDatetimeValue(expr.valueOf().stringValue());
        }
        return new ExprDatetimeValue(expr.valueOf().datetimeValue());
    }).put((Object)BuiltinFunctionName.CAST_TO_TIMESTAMP.getName(), (expr, ref) -> {
        if (expr.type().equals((Object)ExprCoreType.STRING)) {
            ZonedDateTime zonedDateTime = this.getParsedDateTime((LiteralExpression)expr, (ReferenceExpression)ref);
            if (zonedDateTime != null) {
                return new ExprTimestampValue(zonedDateTime.toInstant());
            }
            return new ExprTimestampValue(expr.valueOf().stringValue());
        }
        return new ExprTimestampValue(expr.valueOf().timestampValue());
    }).build();

    public boolean canSupport(FunctionExpression func) {
        return func.getArguments().size() == 2 && func.getArguments().get(0) instanceof ReferenceExpression && (func.getArguments().get(1) instanceof LiteralExpression || this.literalExpressionWrappedByCast(func)) || this.isMultiParameterQuery(func);
    }

    public boolean isNestedPredicate(FunctionExpression func) {
        return NestedAnalyzer.isNestedFunction((Expression)((Expression)func.getArguments().get(0)));
    }

    private boolean isMultiParameterQuery(FunctionExpression func) {
        for (Expression expr : func.getArguments()) {
            if (expr instanceof NamedArgumentExpression) continue;
            return false;
        }
        return true;
    }

    private boolean literalExpressionWrappedByCast(FunctionExpression func) {
        if (func.getArguments().get(1) instanceof FunctionExpression) {
            FunctionExpression expr = (FunctionExpression)func.getArguments().get(1);
            return this.castMap.containsKey(expr.getFunctionName()) && expr.getArguments().get(0) instanceof LiteralExpression;
        }
        return false;
    }

    public QueryBuilder build(FunctionExpression func) {
        ReferenceExpression ref = (ReferenceExpression)func.getArguments().get(0);
        Expression expr = (Expression)func.getArguments().get(1);
        ExprValue literalValue = expr instanceof LiteralExpression ? expr.valueOf() : this.cast((FunctionExpression)expr, ref);
        return this.doBuild(ref.getAttr(), ref.type(), literalValue);
    }

    private ExprValue cast(FunctionExpression castFunction, ReferenceExpression ref) {
        return this.castMap.get(castFunction.getFunctionName()).apply((LiteralExpression)castFunction.getArguments().get(0), ref);
    }

    private ZonedDateTime getParsedDateTime(LiteralExpression expr, ReferenceExpression ref) {
        if (ref.type() instanceof OpenSearchDateType) {
            return ((OpenSearchDateType)ref.type()).getParsedDateTime(expr.valueOf().stringValue());
        }
        return null;
    }

    protected QueryBuilder doBuild(String fieldName, ExprType fieldType, ExprValue literal) {
        throw new UnsupportedOperationException("Subclass doesn't implement this and build method either");
    }

    protected Object value(ExprValue literal, ExprType fieldType) {
        if (fieldType instanceof OpenSearchDateType) {
            OpenSearchDateType openSearchDateType = (OpenSearchDateType)fieldType;
            if (literal.type().equals((Object)ExprCoreType.TIMESTAMP)) {
                return openSearchDateType.hasNoFormatter() ? Long.valueOf(literal.timestampValue().toEpochMilli()) : openSearchDateType.getFormattedDate(literal.timestampValue());
            }
            if (literal.type().equals((Object)ExprCoreType.DATE)) {
                return openSearchDateType.hasNoFormatter() ? literal.value() : openSearchDateType.getFormattedDate(literal.dateValue());
            }
            if (literal.type().equals((Object)ExprCoreType.TIME)) {
                return openSearchDateType.hasNoFormatter() ? literal.value() : openSearchDateType.getFormattedDate(literal.timeValue());
            }
        }
        return literal.value();
    }
}

