/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.client.AdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;

public class DetectorIndices {
    private static final Logger log = LogManager.getLogger(DetectorIndices.class);
    private final AdminClient client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public DetectorIndices(AdminClient client, ClusterService clusterService, ThreadPool threadPool) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public static String detectorMappings() throws IOException {
        return new String(Objects.requireNonNull(DetectorIndices.class.getClassLoader().getResourceAsStream("mappings/detectors.json")).readAllBytes(), Charset.defaultCharset());
    }

    public void initDetectorIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        if (!this.detectorIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opensearch-sap-detectors-config").mapping(DetectorIndices.detectorMappings()).settings(Settings.builder().put("index.hidden", true).build());
            this.client.indices().create(indexRequest, actionListener);
        }
    }

    public boolean detectorIndexExists() {
        ClusterState clusterState = this.clusterService.state();
        return clusterState.getRoutingTable().hasIndex(".opensearch-sap-detectors-config");
    }

    public ClusterIndexHealth detectorIndexHealth() {
        ClusterIndexHealth indexHealth = null;
        if (this.detectorIndexExists()) {
            IndexRoutingTable indexRoutingTable = this.clusterService.state().routingTable().index(".opensearch-sap-detectors-config");
            IndexMetadata indexMetadata = this.clusterService.state().metadata().index(".opensearch-sap-detectors-config");
            indexHealth = new ClusterIndexHealth(indexMetadata, indexRoutingTable);
        }
        return indexHealth;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }
}

