/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer;

import io.netty.handler.codec.http.HttpMethod;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalhostConnectionUtil {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final Logger LOG = LogManager.getLogger(LocalhostConnectionUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disablePA() throws InterruptedException {
        String PA_CONFIG_PATH = "/_plugins/_performanceanalyzer/cluster/config";
        String PA_DISABLE_PAYLOAD = "{\"enabled\": false}";
        for (int retryCount = 5; retryCount > 0; --retryCount) {
            HttpURLConnection connection = null;
            try {
                connection = LocalhostConnectionUtil.createHTTPConnection(PA_CONFIG_PATH, HttpMethod.POST);
                DataOutputStream stream = new DataOutputStream(connection.getOutputStream());
                stream.writeBytes(PA_DISABLE_PAYLOAD);
                stream.flush();
                stream.close();
                LOG.info("PA Disable Response: " + connection.getResponseCode() + " " + connection.getResponseMessage());
                if (connection.getResponseCode() == 200) {
                    return;
                }
            }
            catch (Exception e) {
                LOG.error("PA Disable Request failed: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            Thread.sleep((int)(60000.0 * (Math.random() * 2.0) + 100.0));
        }
        throw new RuntimeException("Failed to disable PA after 5 attempts");
    }

    private static HttpURLConnection createHTTPConnection(String path, HttpMethod httpMethod) {
        try {
            String endPoint = "http://localhost:9200" + path;
            URL endpointUrl = new URL(endPoint);
            HttpURLConnection connection = (HttpURLConnection)endpointUrl.openConnection();
            connection.setRequestMethod(httpMethod.toString());
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            return connection;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create OpenSearch Connection: " + e.getMessage(), e);
        }
    }
}

