/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.net.tasks;

import java.util.Map;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.net.NetClient;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.messages.UnicastIntentMsg;
import org.opensearch.performanceanalyzer.rca.net.NodeStateManager;
import org.opensearch.performanceanalyzer.rca.net.SubscriptionManager;
import org.opensearch.performanceanalyzer.rca.net.tasks.SubscriptionTxTask;

public class UnicastSubscriptionTxTask
extends SubscriptionTxTask {
    private final InstanceDetails destinationInstance;

    public UnicastSubscriptionTxTask(NetClient netClient, UnicastIntentMsg intentMsg, SubscriptionManager subscriptionManager, NodeStateManager nodeStateManager, AppContext appContext) {
        super(netClient, intentMsg, subscriptionManager, nodeStateManager, appContext);
        this.destinationInstance = intentMsg.getUnicastDestinationInstance();
    }

    @Override
    public void run() {
        String requesterVertex = this.intentMsg.getRequesterGraphNode();
        String destinationVertex = this.intentMsg.getDestinationGraphNode();
        Map<String, String> tags = this.intentMsg.getRcaConfTags();
        this.sendSubscribeRequest(this.destinationInstance, requesterVertex, destinationVertex, tags);
    }
}

