/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.samplers;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.commons.stats.collectors.SampleAggregator;
import org.opensearch.performanceanalyzer.commons.stats.emitters.ISampler;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.metricsdb.MetricsDB;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;

public class MetricsDBFileSampler
implements ISampler {
    private static final Logger LOG = LogManager.getLogger(MetricsDBFileSampler.class);
    private static final Path targetDirectoryPath;
    private static final DirectoryStream.Filter<Path> metricsdbFilter;
    private static final DirectoryStream.Filter<Path> metricsdbTarFilter;
    private final AppContext appContext;

    public MetricsDBFileSampler(AppContext appContext) {
        Objects.requireNonNull(appContext);
        this.appContext = appContext;
    }

    public void sample(SampleAggregator sampleCollector) {
        int numUncompressedMetricsdbFiles = 0;
        long sizeUncompressedMetricsdbFiles = 0L;
        int numMetricsdbFiles = 0;
        long sizeMetricsdbFiles = 0L;
        try (DirectoryStream<Path> metricsdbStream = Files.newDirectoryStream(targetDirectoryPath, metricsdbFilter);
             DirectoryStream<Path> metricsdbTarStream = Files.newDirectoryStream(targetDirectoryPath, metricsdbTarFilter);){
            for (Path entry : metricsdbStream) {
                sizeUncompressedMetricsdbFiles += Files.size(entry);
                ++numUncompressedMetricsdbFiles;
            }
            for (Path entry : metricsdbTarStream) {
                sizeMetricsdbFiles += Files.size(entry);
                ++numMetricsdbFiles;
            }
        }
        catch (IOException e) {
            LOG.warn("Issue accessing metricsdb entries in {}", (Object)targetDirectoryPath);
            return;
        }
        sampleCollector.updateStat((MeasurementSet)ReaderMetrics.METRICSDB_NUM_FILES, (Number)(numMetricsdbFiles += numUncompressedMetricsdbFiles));
        sampleCollector.updateStat((MeasurementSet)ReaderMetrics.METRICSDB_SIZE_FILES, (Number)(sizeMetricsdbFiles += sizeUncompressedMetricsdbFiles));
        sampleCollector.updateStat((MeasurementSet)ReaderMetrics.METRICSDB_NUM_UNCOMPRESSED_FILES, (Number)numUncompressedMetricsdbFiles);
        sampleCollector.updateStat((MeasurementSet)ReaderMetrics.METRICSDB_SIZE_UNCOMPRESSED_FILES, (Number)sizeUncompressedMetricsdbFiles);
    }

    static {
        String metricsdbPrefix = MetricsDB.getFilePrefix();
        targetDirectoryPath = Paths.get(metricsdbPrefix, new String[0]).getParent();
        String metricsdbPattern = "regex:" + metricsdbPrefix + "\\d+";
        String metricsdbTarPattern = "regex:" + metricsdbPrefix.substring(0, metricsdbPrefix.length() - 1) + ".tar.\\d+-\\d+-\\d+-\\d+-\\d+.gz";
        PathMatcher metricsdbMatcher = FileSystems.getDefault().getPathMatcher(metricsdbPattern);
        PathMatcher metricsdbTarMatcher = FileSystems.getDefault().getPathMatcher(metricsdbTarPattern);
        metricsdbFilter = metricsdbMatcher::matches;
        metricsdbTarFilter = metricsdbTarMatcher::matches;
    }
}

