/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import org.tribuo.DataSource;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.OutputInfo;
import org.tribuo.VariableIDInfo;
import org.tribuo.hash.HashedFeatureMap;
import org.tribuo.hash.Hasher;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.util.Merger;

public class ImmutableDataset<T extends Output<T>>
extends Dataset<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ImmutableDataset.class.getName());
    protected ImmutableOutputInfo<T> outputIDInfo;
    protected ImmutableFeatureMap featureIDMap;
    protected final boolean dropInvalidExamples;
    private DatasetProvenance provenance = null;

    protected ImmutableDataset(DataProvenance description, OutputFactory<T> outputFactory) {
        super(description, outputFactory);
        this.dropInvalidExamples = false;
    }

    public ImmutableDataset(DataSource<T> dataSource, Model<T> model, boolean dropInvalidExamples) {
        this(dataSource, (DataProvenance)dataSource.getProvenance(), dataSource.getOutputFactory(), model.getFeatureIDMap(), model.getOutputIDInfo(), dropInvalidExamples);
    }

    public ImmutableDataset(DataSource<T> dataSource, FeatureMap featureIDMap, OutputInfo<T> outputIDInfo, boolean dropInvalidExamples) {
        this(dataSource, (DataProvenance)dataSource.getProvenance(), dataSource.getOutputFactory(), featureIDMap, outputIDInfo, dropInvalidExamples);
    }

    public ImmutableDataset(Iterable<Example<T>> dataSource, DataProvenance description, OutputFactory<T> outputFactory, FeatureMap featureIDMap, OutputInfo<T> outputIDInfo, boolean dropInvalidExamples) {
        this(dataSource, description, outputFactory, new ImmutableFeatureMap(featureIDMap), outputIDInfo.generateImmutableOutputInfo(), dropInvalidExamples);
    }

    public ImmutableDataset(Iterable<Example<T>> dataSource, DataProvenance description, OutputFactory<T> outputFactory, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, boolean dropInvalidExamples) {
        super(description, outputFactory);
        this.featureIDMap = featureIDMap;
        this.outputIDInfo = outputIDInfo;
        this.dropInvalidExamples = dropInvalidExamples;
        for (Example<T> ex : dataSource) {
            this.add(ex);
        }
    }

    protected ImmutableDataset(DataProvenance description, OutputFactory<T> outputFactory, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo) {
        super(description, outputFactory);
        this.featureIDMap = featureIDMap;
        this.outputIDInfo = outputIDInfo;
        this.dropInvalidExamples = false;
    }

    protected void add(Example<T> ex) {
        if (!ex.validateExample()) {
            if (this.dropInvalidExamples) {
                logger.severe("Dropping invalid Example: " + ex.toString());
                return;
            }
            throw new IllegalArgumentException("Example had duplicate features, invalid features or no features.");
        }
        this.innerAdd(ex);
    }

    private void unsafeAdd(Example<T> ex) {
        this.data.add(ex);
    }

    protected void add(Example<T> ex, Merger merger) {
        ex.reduceByName(merger);
        this.innerAdd(ex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void innerAdd(Example<T> ex) {
        ArrayList<Feature> featuresToRemove = new ArrayList<Feature>();
        for (Feature f : ex) {
            VariableIDInfo info = this.featureIDMap.get(f.getName());
            if (info != null) continue;
            featuresToRemove.add(f);
        }
        ex.removeFeatures(featuresToRemove);
        if (ex.size() == 0) {
            if (!this.dropInvalidExamples) throw new IllegalArgumentException("This Dataset does not know any of the Features in this Example.");
            logger.severe("Dropping invalid Example: " + ex.toString() + ", invalid features - " + featuresToRemove);
            return;
        } else {
            ex.canonicalize(this.featureIDMap);
            this.data.add(ex);
        }
    }

    @Override
    public Set<T> getOutputs() {
        return this.outputIDInfo.getDomain();
    }

    @Override
    public ImmutableFeatureMap getFeatureIDMap() {
        return this.featureIDMap;
    }

    @Override
    public ImmutableFeatureMap getFeatureMap() {
        return this.featureIDMap;
    }

    @Override
    public ImmutableOutputInfo<T> getOutputIDInfo() {
        return this.outputIDInfo;
    }

    @Override
    public ImmutableOutputInfo<T> getOutputInfo() {
        return this.outputIDInfo;
    }

    public boolean getDropInvalidExamples() {
        return this.dropInvalidExamples;
    }

    @Override
    public String toString() {
        return String.format("ImmutableDataset(source=%s,dropInvalidExamples=%b)", this.sourceProvenance, this.dropInvalidExamples);
    }

    public synchronized DatasetProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = this.cacheProvenance();
        }
        return this.provenance;
    }

    private DatasetProvenance cacheProvenance() {
        return new DatasetProvenance(this.sourceProvenance, (ListProvenance<ObjectProvenance>)new ListProvenance(), this);
    }

    public static <T extends Output<T>> ImmutableDataset<T> copyDataset(Dataset<T> dataset) {
        ImmutableDataset copy = new ImmutableDataset((DataProvenance)dataset.getProvenance(), dataset.outputFactory, dataset.getFeatureIDMap(), dataset.getOutputIDInfo());
        for (Example<T> e : dataset) {
            super.unsafeAdd(e.copy());
        }
        return copy;
    }

    public static <T extends Output<T>> ImmutableDataset<T> copyDataset(Dataset<T> dataset, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo) {
        ImmutableDataset<T> copy = new ImmutableDataset<T>((DataProvenance)dataset.getProvenance(), dataset.outputFactory, featureIDMap, outputIDInfo);
        for (Example<T> e : dataset) {
            copy.add(e.copy());
        }
        return copy;
    }

    public static <T extends Output<T>> ImmutableDataset<T> copyDataset(Dataset<T> dataset, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, Merger merger) {
        ImmutableDataset<T> copy = new ImmutableDataset<T>((DataProvenance)dataset.getProvenance(), dataset.outputFactory, featureIDMap, outputIDInfo);
        for (Example<T> e : dataset) {
            copy.add(e.copy(), merger);
        }
        return copy;
    }

    public static <T extends Output<T>> ImmutableDataset<T> hashFeatureMap(Dataset<T> dataset, Hasher hasher) {
        HashedFeatureMap featureIDMap = HashedFeatureMap.generateHashedFeatureMap(dataset.getFeatureMap(), hasher);
        ImmutableDataset copy = new ImmutableDataset((DataProvenance)dataset.getProvenance(), dataset.outputFactory, featureIDMap, dataset.getOutputIDInfo());
        for (Example<T> e : dataset) {
            super.unsafeAdd(e);
        }
        return copy;
    }
}

