/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.output;

import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.Point;
import java.util.ArrayList;
import java.util.List;

public class Rectangle
implements BoundingBox {
    private static final long serialVersionUID = 1L;
    private List<Point> corners;
    private double width;
    private double height;

    public Rectangle(double x, double y, double width, double height) {
        this(new Point(x, y), width, height);
    }

    public Rectangle(Point point, double width, double height) {
        this.width = width;
        this.height = height;
        this.corners = new ArrayList<Point>(4);
        this.corners.add(point);
        this.corners.add(new Point(point.getX() + width, point.getY()));
        this.corners.add(new Point(point.getX() + width, point.getY() + height));
        this.corners.add(new Point(point.getX(), point.getY() + height));
    }

    @Override
    public Rectangle getBounds() {
        return this;
    }

    @Override
    public Iterable<Point> getPath() {
        return this.corners;
    }

    @Override
    public Point getPoint() {
        return this.corners.get(0);
    }

    @Override
    public double getIoU(BoundingBox box) {
        Rectangle rect = box.getBounds();
        double s1 = (this.width + 1.0) * (this.height + 1.0);
        double s2 = (rect.getWidth() + 1.0) * (rect.getHeight() + 1.0);
        double sumArea = s1 + s2;
        double left = Math.max(this.getX(), rect.getX());
        double top = Math.max(this.getY(), rect.getY());
        double right = Math.min(this.getX() + this.getWidth(), rect.getX() + rect.getWidth());
        double bottom = Math.min(this.getY() + this.getHeight(), rect.getY() + rect.getHeight());
        if (left > right || top > bottom) {
            return 0.0;
        }
        double intersect = (right - left + 1.0) * (bottom - top + 1.0);
        return intersect / (sumArea - intersect);
    }

    public double getX() {
        return this.getPoint().getX();
    }

    public double getY() {
        return this.getPoint().getY();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public String toString() {
        double x = this.getX();
        double y = this.getY();
        return String.format("{\"x\"=%.3f, \"y\"=%.3f, \"width\"=%.3f, \"height\"=%.3f}", x, y, this.width, this.height);
    }
}

