/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.joda.time.Instant;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.common.UUIDs;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.ResourceType;

@ExperimentalApi
public class QueryGroup
extends AbstractDiffable<QueryGroup>
implements ToXContentObject {
    private static final int MAX_CHARS_ALLOWED_IN_NAME = 50;
    private final String name;
    private final String _id;
    private final ResiliencyMode resiliencyMode;
    private final long updatedAtInMillis;
    private final Map<ResourceType, Object> resourceLimits;

    public QueryGroup(String name, ResiliencyMode resiliencyMode, Map<ResourceType, Object> resourceLimits) {
        this(name, UUIDs.randomBase64UUID(), resiliencyMode, resourceLimits, Instant.now().getMillis());
    }

    public QueryGroup(String name, String _id, ResiliencyMode resiliencyMode, Map<ResourceType, Object> resourceLimits, long updatedAt) {
        Objects.requireNonNull(name, "QueryGroup.name can't be null");
        Objects.requireNonNull(resourceLimits, "QueryGroup.resourceLimits can't be null");
        Objects.requireNonNull(resiliencyMode, "QueryGroup.resiliencyMode can't be null");
        Objects.requireNonNull(_id, "QueryGroup._id can't be null");
        if (name.length() > 50) {
            throw new IllegalArgumentException("QueryGroup.name shouldn't be more than 50 chars long");
        }
        if (resourceLimits.isEmpty()) {
            throw new IllegalArgumentException("QueryGroup.resourceLimits should at least have 1 resource limit");
        }
        this.validateResourceLimits(resourceLimits);
        if (!QueryGroup.isValid(updatedAt)) {
            throw new IllegalArgumentException("QueryGroup.updatedAtInMillis is not a valid epoch");
        }
        this.name = name;
        this._id = _id;
        this.resiliencyMode = resiliencyMode;
        this.resourceLimits = resourceLimits;
        this.updatedAtInMillis = updatedAt;
    }

    private static boolean isValid(long updatedAt) {
        long minValidTimestamp = Instant.ofEpochMilli((long)0L).getMillis();
        long currentSeconds = Instant.now().getMillis();
        return minValidTimestamp <= updatedAt && updatedAt <= currentSeconds;
    }

    public QueryGroup(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), ResiliencyMode.fromName(in.readString()), in.readMap(i -> ResourceType.fromName(i.readString()), StreamInput::readGenericValue), in.readLong());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this._id);
        out.writeString(this.resiliencyMode.getName());
        out.writeMap(this.resourceLimits, ResourceType::writeTo, StreamOutput::writeGenericValue);
        out.writeLong(this.updatedAtInMillis);
    }

    private void validateResourceLimits(Map<ResourceType, Object> resourceLimits) {
        for (Map.Entry<ResourceType, Object> resource : resourceLimits.entrySet()) {
            Double threshold = (Double)resource.getValue();
            Objects.requireNonNull(resource.getKey(), "resourceName can't be null");
            Objects.requireNonNull(threshold, "resource limit threshold for" + resource.getKey().getName() + " : can't be null");
            if (Double.compare(threshold, 1.0) <= 0) continue;
            throw new IllegalArgumentException("resource value should be less than 1.0");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("_id", this._id);
        builder.field("name", this.name);
        builder.field("resiliency_mode", this.resiliencyMode.getName());
        builder.field("updatedAt", this.updatedAtInMillis);
        builder.startObject("resourceLimits");
        for (ResourceType resourceType : ResourceType.values()) {
            if (!this.resourceLimits.containsKey((Object)resourceType)) continue;
            builder.field(resourceType.getName(), this.resourceLimits.get((Object)resourceType));
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static QueryGroup fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        Builder builder = QueryGroup.builder();
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Expected START_OBJECT token but found [" + parser.currentName() + "]");
        }
        String fieldName = "";
        HashMap<ResourceType, Object> resourceLimits = new HashMap<ResourceType, Object>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (fieldName.equals("_id")) {
                    builder._id(parser.text());
                    continue;
                }
                if (fieldName.equals("name")) {
                    builder.name(parser.text());
                    continue;
                }
                if (fieldName.equals("resiliency_mode")) {
                    builder.mode(parser.text());
                    continue;
                }
                if (fieldName.equals("updatedAt")) {
                    builder.updatedAt(parser.longValue());
                    continue;
                }
                throw new IllegalArgumentException(fieldName + " is not a valid field in QueryGroup");
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if (!fieldName.equals("resourceLimits")) {
                throw new IllegalArgumentException("QueryGroup.resourceLimits is an object and expected token was {  but found " + String.valueOf(token));
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                resourceLimits.put(ResourceType.fromName(fieldName), parser.doubleValue());
            }
        }
        builder.resourceLimits(resourceLimits);
        return builder.build();
    }

    public static Diff<QueryGroup> readDiff(StreamInput in) throws IOException {
        return QueryGroup.readDiffFrom(QueryGroup::new, in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryGroup that = (QueryGroup)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.resourceLimits, that.resourceLimits) && Objects.equals(this._id, that._id) && this.updatedAtInMillis == that.updatedAtInMillis;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resourceLimits, this.updatedAtInMillis, this._id);
    }

    public String getName() {
        return this.name;
    }

    public ResiliencyMode getResiliencyMode() {
        return this.resiliencyMode;
    }

    public Map<ResourceType, Object> getResourceLimits() {
        return this.resourceLimits;
    }

    public String get_id() {
        return this._id;
    }

    public long getUpdatedAtInMillis() {
        return this.updatedAtInMillis;
    }

    public static Builder builder() {
        return new Builder();
    }

    @ExperimentalApi
    public static enum ResiliencyMode {
        SOFT("soft"),
        ENFORCED("enforced"),
        MONITOR("monitor");

        private final String name;

        private ResiliencyMode(String mode) {
            this.name = mode;
        }

        public String getName() {
            return this.name;
        }

        public static ResiliencyMode fromName(String s) {
            for (ResiliencyMode mode : ResiliencyMode.values()) {
                if (!mode.getName().equalsIgnoreCase(s)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Invalid value for QueryGroupMode: " + s);
        }
    }

    @ExperimentalApi
    public static class Builder {
        private String name;
        private String _id;
        private ResiliencyMode resiliencyMode;
        private long updatedAt;
        private Map<ResourceType, Object> resourceLimits;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder _id(String _id) {
            this._id = _id;
            return this;
        }

        public Builder mode(String mode) {
            this.resiliencyMode = ResiliencyMode.fromName(mode);
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder resourceLimits(Map<ResourceType, Object> resourceLimits) {
            this.resourceLimits = resourceLimits;
            return this;
        }

        public QueryGroup build() {
            return new QueryGroup(this.name, this._id, this.resiliencyMode, this.resourceLimits, this.updatedAt);
        }
    }
}

