/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.network.CloseableChannel;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.transport.NetworkExceptionHelper;
import org.opensearch.common.transport.PortsRange;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.http.BindHttpException;
import org.opensearch.http.CorsHandler;
import org.opensearch.http.DefaultRestChannel;
import org.opensearch.http.DefaultStreamingRestChannel;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpHandlingSettings;
import org.opensearch.http.HttpInfo;
import org.opensearch.http.HttpReadTimeoutException;
import org.opensearch.http.HttpRequest;
import org.opensearch.http.HttpResponse;
import org.opensearch.http.HttpServerChannel;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.HttpStats;
import org.opensearch.http.HttpTracer;
import org.opensearch.http.HttpTransportSettings;
import org.opensearch.http.HttpUtils;
import org.opensearch.http.StreamingHttpChannel;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanBuilder;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.channels.TraceableHttpChannel;
import org.opensearch.telemetry.tracing.channels.TraceableRestChannel;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.BindTransportException;

public abstract class AbstractHttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(AbstractHttpServerTransport.class);
    private static final ActionListener<Void> NO_OP = ActionListener.wrap(() -> {});
    protected final Settings settings;
    public final HttpHandlingSettings handlingSettings;
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ThreadPool threadPool;
    protected final HttpServerTransport.Dispatcher dispatcher;
    protected final CorsHandler corsHandler;
    private final NamedXContentRegistry xContentRegistry;
    protected final PortsRange port;
    protected final ByteSizeValue maxContentLength;
    private final String[] bindHosts;
    private final String[] publishHosts;
    private volatile BoundTransportAddress boundAddress;
    private final AtomicLong totalChannelsAccepted = new AtomicLong();
    private final Set<HttpChannel> httpChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<HttpServerChannel> httpServerChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final HttpTracer httpTracer;
    private final Tracer tracer;

    protected AbstractHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, Tracer telemetryTracer) {
        this.settings = settings;
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.dispatcher = dispatcher;
        this.handlingSettings = HttpHandlingSettings.fromSettings(settings);
        this.corsHandler = CorsHandler.fromSettings(settings);
        List<String> httpBindHost = HttpTransportSettings.SETTING_HTTP_BIND_HOST.get(settings);
        this.bindHosts = (httpBindHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : httpBindHost).toArray(Strings.EMPTY_ARRAY);
        List<String> httpPublishHost = HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings);
        this.publishHosts = (httpPublishHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings) : httpPublishHost).toArray(Strings.EMPTY_ARRAY);
        this.port = HttpTransportSettings.SETTING_HTTP_PORT.get(settings);
        this.maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings);
        this.httpTracer = new HttpTracer(settings, clusterSettings);
        this.tracer = telemetryTracer;
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.getBytes());
    }

    @Override
    public HttpStats stats() {
        return new HttpStats(this.httpChannels.size(), this.totalChannelsAccepted.get());
    }

    protected void bindServer() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", e);
        }
        ArrayList<TransportAddress> boundAddresses = new ArrayList<TransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = AbstractHttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        TransportAddress publishAddress = new TransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        this.boundAddress = new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), publishAddress);
        logger.info("{}", (Object)this.boundAddress);
    }

    private TransportAddress bindAddress(InetAddress hostAddress) {
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = this.port.iterate(portNumber -> {
            try {
                Set<HttpServerChannel> set = this.httpServerChannels;
                synchronized (set) {
                    HttpServerChannel httpServerChannel = this.bind(new InetSocketAddress(hostAddress, portNumber));
                    this.httpServerChannels.add(httpServerChannel);
                    boundSocket.set(httpServerChannel.getLocalAddress());
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to " + NetworkAddress.format((InetAddress)hostAddress, (PortsRange)this.port), (Throwable)lastException.get());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bound http to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)((InetSocketAddress)boundSocket.get())));
        }
        return new TransportAddress((InetSocketAddress)boundSocket.get());
    }

    protected abstract HttpServerChannel bind(InetSocketAddress var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        Set<HttpServerChannel> set = this.httpServerChannels;
        synchronized (set) {
            if (!this.httpServerChannels.isEmpty()) {
                try {
                    CloseableChannel.closeChannels(new ArrayList<HttpServerChannel>(this.httpServerChannels), true);
                }
                catch (Exception e) {
                    logger.warn("exception while closing channels", (Throwable)e);
                }
                finally {
                    this.httpServerChannels.clear();
                }
            }
        }
        try {
            CloseableChannel.closeChannels(new ArrayList<HttpChannel>(this.httpChannels), true);
        }
        catch (Exception e) {
            logger.warn("unexpected exception while closing http channels", (Throwable)e);
        }
        this.httpChannels.clear();
        this.stopInternal();
    }

    protected void doClose() {
    }

    protected abstract void stopInternal();

    static int resolvePublishPort(Settings settings, List<TransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (TransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            HashSet<Integer> ports = new HashSet<Integer>();
            for (TransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = (Integer)ports.iterator().next();
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + String.valueOf(boundAddresses) + " with distinct ports and none of them matched the publish address (" + String.valueOf(publishInetAddress) + "). Please specify a unique port by setting " + HttpTransportSettings.SETTING_HTTP_PORT.getKey() + " or " + HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    public void onException(HttpChannel channel, Exception e) {
        channel.handleException(e);
        if (!this.lifecycle.started()) {
            CloseableChannel.closeChannel(channel);
            return;
        }
        if (NetworkExceptionHelper.isCloseConnectionException((Throwable)e)) {
            logger.trace(() -> new ParameterizedMessage("close connection exception caught while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (NetworkExceptionHelper.isConnectException((Throwable)e)) {
            logger.trace(() -> new ParameterizedMessage("connect exception caught while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (e instanceof HttpReadTimeoutException) {
            logger.trace(() -> new ParameterizedMessage("http read timeout, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (e instanceof CancelledKeyException) {
            logger.trace(() -> new ParameterizedMessage("cancelled key exception caught while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else {
            logger.warn(() -> new ParameterizedMessage("caught exception while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        }
    }

    protected void onServerException(HttpServerChannel channel, Exception e) {
        logger.error((Message)new ParameterizedMessage("exception from http server channel caught on transport layer [channel={}]", (Object)channel), (Throwable)e);
    }

    protected void serverAcceptedChannel(HttpChannel httpChannel) {
        boolean addedOnThisCall = this.httpChannels.add(httpChannel);
        assert (addedOnThisCall) : "Channel should only be added to http channel set once";
        this.totalChannelsAccepted.incrementAndGet();
        httpChannel.addCloseListener((ActionListener<Void>)ActionListener.wrap(() -> this.httpChannels.remove(httpChannel)));
        logger.trace(() -> new ParameterizedMessage("Http channel accepted: {}", (Object)httpChannel));
    }

    public void incomingStream(HttpRequest httpRequest, StreamingHttpChannel httpChannel) {
        this.handleIncomingRequest(httpRequest, httpChannel, httpRequest.getInboundException());
    }

    public void incomingRequest(HttpRequest httpRequest, HttpChannel httpChannel) {
        Span span = this.tracer.startSpan(SpanBuilder.from(httpRequest), AbstractHttpServerTransport.extractHeaders(httpRequest.getHeaders()));
        try (SpanScope httpRequestSpanScope = this.tracer.withSpanInScope(span);){
            HttpChannel traceableHttpChannel = TraceableHttpChannel.create(httpChannel, span, this.tracer);
            this.handleIncomingRequest(httpRequest, traceableHttpChannel, httpRequest.getInboundException());
        }
    }

    void dispatchRequest(RestRequest restRequest, RestChannel channel, Throwable badRequestCause) {
        RestChannel traceableRestChannel = channel;
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            Span span = this.tracer.startSpan(SpanBuilder.from(restRequest));
            try (SpanScope spanScope = this.tracer.withSpanInScope(span);){
                if (channel != null) {
                    traceableRestChannel = TraceableRestChannel.create(channel, span, this.tracer);
                }
                if (badRequestCause != null) {
                    this.dispatcher.dispatchBadRequest(traceableRestChannel, threadContext, badRequestCause);
                } else {
                    this.dispatcher.dispatchRequest(restRequest, traceableRestChannel, threadContext);
                }
            }
        }
    }

    private void handleIncomingRequest(HttpRequest httpRequest, HttpChannel httpChannel, Exception exception) {
        DefaultRestChannel innerChannel;
        RestRequest innerRestRequest;
        HttpResponse earlyResponse;
        if (exception == null && (earlyResponse = this.corsHandler.handleInbound(httpRequest)) != null) {
            httpChannel.sendResponse(earlyResponse, AbstractHttpServerTransport.earlyResponseListener(httpRequest, httpChannel));
            httpRequest.release();
            return;
        }
        Exception badRequestCause = exception;
        try {
            innerRestRequest = RestRequest.request(this.xContentRegistry, httpRequest, httpChannel);
        }
        catch (RestRequest.ContentTypeHeaderException e) {
            badRequestCause = (Exception)ExceptionsHelper.useOrSuppress((Throwable)badRequestCause, (Throwable)e);
            innerRestRequest = this.requestWithoutContentTypeHeader(httpRequest, httpChannel, badRequestCause);
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause = (Exception)ExceptionsHelper.useOrSuppress((Throwable)badRequestCause, (Throwable)e);
            innerRestRequest = RestRequest.requestWithoutParameters(this.xContentRegistry, httpRequest, httpChannel);
        }
        RestRequest restRequest = innerRestRequest;
        HttpTracer trace = this.httpTracer.maybeTraceRequest(restRequest, exception);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try {
            innerChannel = httpChannel instanceof StreamingHttpChannel ? new DefaultStreamingRestChannel((StreamingHttpChannel)httpChannel, httpRequest, restRequest, this.bigArrays, this.handlingSettings, threadContext, this.corsHandler, trace) : new DefaultRestChannel(httpChannel, httpRequest, restRequest, this.bigArrays, this.handlingSettings, threadContext, this.corsHandler, trace);
        }
        catch (IllegalArgumentException e) {
            badRequestCause = (Exception)ExceptionsHelper.useOrSuppress((Throwable)badRequestCause, (Throwable)e);
            RestRequest innerRequest = RestRequest.requestWithoutParameters(this.xContentRegistry, httpRequest, httpChannel);
            innerChannel = httpChannel instanceof StreamingHttpChannel ? new DefaultStreamingRestChannel((StreamingHttpChannel)httpChannel, httpRequest, innerRequest, this.bigArrays, this.handlingSettings, threadContext, this.corsHandler, trace) : new DefaultRestChannel(httpChannel, httpRequest, innerRequest, this.bigArrays, this.handlingSettings, threadContext, this.corsHandler, trace);
        }
        DefaultRestChannel channel = innerChannel;
        this.dispatchRequest(restRequest, channel, badRequestCause);
    }

    private RestRequest requestWithoutContentTypeHeader(HttpRequest httpRequest, HttpChannel httpChannel, Exception badRequestCause) {
        HttpRequest httpRequestWithoutContentType = httpRequest.removeHeader("Content-Type");
        try {
            return RestRequest.request(this.xContentRegistry, httpRequestWithoutContentType, httpChannel);
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause.addSuppressed(e);
            return RestRequest.requestWithoutParameters(this.xContentRegistry, httpRequestWithoutContentType, httpChannel);
        }
    }

    private static ActionListener<Void> earlyResponseListener(HttpRequest request, HttpChannel httpChannel) {
        if (HttpUtils.shouldCloseConnection(request)) {
            return ActionListener.wrap(() -> CloseableChannel.closeChannel(httpChannel));
        }
        return NO_OP;
    }

    private static <Values extends Collection<String>> Map<String, Collection<String>> extractHeaders(Map<String, Values> headers) {
        return headers;
    }
}

