/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.IndexableField;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.DerivedField;
import org.opensearch.index.mapper.DerivedFieldSupportedTypes;
import org.opensearch.index.mapper.DerivedFieldType;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ObjectDerivedFieldType;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.script.Script;

public class DerivedFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "derived";
    protected final IndexAnalyzers indexAnalyzers;
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, c.getIndexAnalyzers(), c.getDateFormatter(), ignoreMalformedByDefault);
    });
    private final String type;
    private final Script script;
    private final String prefilterField;
    private final Map<String, Object> properties;
    private final boolean ignoreMalformed;
    private final boolean defaultIgnoreMalformed;
    private final DateFormatter defaultDateFormatter;
    private final String format;

    private static DerivedFieldMapper toType(FieldMapper in) {
        return (DerivedFieldMapper)in;
    }

    protected DerivedFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder, IndexAnalyzers indexAnalyzers, DateFormatter defaultDateFormatter, boolean ignoreMalformed) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.type = builder.type.getValue();
        this.script = builder.script.getValue();
        this.prefilterField = builder.prefilterField.getValue();
        this.properties = builder.properties.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.format = builder.format.getValue();
        this.indexAnalyzers = indexAnalyzers;
        this.defaultDateFormatter = defaultDateFormatter;
        this.defaultIgnoreMalformed = ignoreMalformed;
    }

    @Override
    public DerivedFieldType fieldType() {
        return (DerivedFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("should not be invoked");
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexAnalyzers, this.defaultDateFormatter, this.defaultIgnoreMalformed).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        this.getMergeBuilder().toXContent(builder, includeDefaults);
        this.multiFields.toXContent(builder, params);
        this.copyTo.toXContent(builder, params);
    }

    public String getType() {
        return this.type;
    }

    public Script getScript() {
        return this.script;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<String> type = ParametrizedFieldMapper.Parameter.stringParam("type", true, m -> DerivedFieldMapper.toType((FieldMapper)m).type, "");
        private final IndexAnalyzers indexAnalyzers;
        private final boolean defaultIgnoreMalformed;
        private final DateFormatter defaultDateFormatter;
        private final ParametrizedFieldMapper.Parameter<Script> script = new ParametrizedFieldMapper.Parameter<Script>("script", true, () -> null, (n, c, o) -> o == null ? null : Script.parse(o), m -> DerivedFieldMapper.toType((FieldMapper)m).script).setSerializerCheck((id, ic, value) -> value != null);
        private final ParametrizedFieldMapper.Parameter<Map<String, Object>> properties = new ParametrizedFieldMapper.Parameter<Map>("properties", true, Collections::emptyMap, (n, c, o) -> Builder.parseProperties(n, o), m -> DerivedFieldMapper.toType((FieldMapper)m).properties);
        private final ParametrizedFieldMapper.Parameter<String> prefilterField = ParametrizedFieldMapper.Parameter.stringParam("prefilter_field", true, m -> DerivedFieldMapper.toType((FieldMapper)m).prefilterField, "");
        private final ParametrizedFieldMapper.Parameter<String> format = ParametrizedFieldMapper.Parameter.stringParam("format", true, m -> DerivedFieldMapper.toType((FieldMapper)m).format, DateFieldMapper.getDefaultDateTimeFormatter().pattern());
        private final ParametrizedFieldMapper.Parameter<Boolean> ignoreMalformed;

        private static Map<String, Object> parseProperties(String name, Object propertiesObject) {
            if (!(propertiesObject instanceof Map)) {
                throw new MapperParsingException("[properties] must be an object, got " + propertiesObject.getClass().getSimpleName() + "[" + String.valueOf(propertiesObject) + "] for field [" + name + "]");
            }
            Map properties = (Map)propertiesObject;
            for (Object value : properties.values()) {
                if (value == null) {
                    throw new MapperParsingException("[properties] values can't be null (field [" + name + "])");
                }
                if (value instanceof String) continue;
                throw new MapperParsingException("[properties] values can only be strings, but got " + value.getClass().getSimpleName() + "[" + String.valueOf(value) + "] for field [" + name + "]");
            }
            return properties;
        }

        public Builder(String name, IndexAnalyzers indexAnalyzers, DateFormatter defaultDateFormatter, boolean defaultIgnoreMalformed) {
            super(name);
            this.indexAnalyzers = indexAnalyzers;
            this.defaultDateFormatter = defaultDateFormatter;
            this.defaultIgnoreMalformed = defaultIgnoreMalformed;
            if (defaultDateFormatter != null) {
                this.format.setValue(defaultDateFormatter.pattern());
            }
            this.ignoreMalformed = ParametrizedFieldMapper.Parameter.boolParam("ignore_malformed", true, m -> DerivedFieldMapper.toType((FieldMapper)m).ignoreMalformed, defaultIgnoreMalformed);
        }

        public Builder(DerivedField derivedField, IndexAnalyzers indexAnalyzers, DateFormatter defaultDateFormatter, boolean defaultIgnoreMalformed) {
            this(derivedField.getName(), indexAnalyzers, defaultDateFormatter, defaultIgnoreMalformed);
            this.type.setValue(derivedField.getType());
            this.script.setValue(derivedField.getScript());
            if (derivedField.getProperties() != null) {
                this.properties.setValue(derivedField.getProperties());
            }
            if (derivedField.getPrefilterField() != null) {
                this.prefilterField.setValue(derivedField.getPrefilterField());
            }
            if (derivedField.getFormat() != null) {
                this.format.setValue(derivedField.getFormat());
            }
            if (derivedField.getIgnoreMalformed()) {
                this.ignoreMalformed.setValue(derivedField.getIgnoreMalformed());
            }
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.type, this.script, this.properties, this.prefilterField, this.format, this.ignoreMalformed);
        }

        @Override
        public DerivedFieldMapper build(Mapper.BuilderContext context) {
            DerivedField derivedField = new DerivedField(this.buildFullName(context), this.type.getValue(), this.script.getValue());
            if (this.properties.isConfigured()) {
                derivedField.setProperties(this.properties.getValue());
            }
            if (this.prefilterField.isConfigured()) {
                derivedField.setPrefilterField(this.prefilterField.getValue());
            }
            if (this.format.isConfigured()) {
                derivedField.setFormat(this.format.getValue());
            }
            if (this.ignoreMalformed.isConfigured()) {
                derivedField.setIgnoreMalformed(this.ignoreMalformed.getValue());
            }
            FieldMapper fieldMapper = DerivedFieldSupportedTypes.getFieldMapperFromType(this.type.getValue(), this.name, context, this.indexAnalyzers);
            Function<Object, IndexableField> fieldFunction = DerivedFieldSupportedTypes.getIndexableFieldGeneratorType(this.type.getValue(), this.name);
            DerivedFieldType ft = this.name.contains(".") ? new ObjectDerivedFieldType(derivedField, fieldMapper, fieldFunction, this.indexAnalyzers) : new DerivedFieldType(derivedField, fieldMapper, fieldFunction, this.indexAnalyzers);
            return new DerivedFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this, this.indexAnalyzers, this.defaultDateFormatter, this.defaultIgnoreMalformed);
        }
    }
}

