/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamOutput;

@PublicApi(since="2.x")
public enum ResourceType {
    CPU("cpu"),
    MEMORY("memory");

    private final String name;

    private ResourceType(String name) {
        this.name = name;
    }

    public static ResourceType fromName(String s) {
        for (ResourceType resourceType : ResourceType.values()) {
            if (!resourceType.getName().equals(s)) continue;
            return resourceType;
        }
        throw new IllegalArgumentException("Unknown resource type: [" + s + "]");
    }

    public static void writeTo(StreamOutput out, ResourceType resourceType) throws IOException {
        out.writeString(resourceType.getName());
    }

    public String getName() {
        return this.name;
    }
}

