/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.common.Booleans;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.RestRequest;

@PublicApi(since="1.0.0")
public class FetchSourceContext
implements Writeable,
ToXContentObject {
    public static final ParseField INCLUDES_FIELD = new ParseField("includes", new String[]{"include"});
    public static final ParseField EXCLUDES_FIELD = new ParseField("excludes", new String[]{"exclude"});
    public static final FetchSourceContext FETCH_SOURCE = new FetchSourceContext(true);
    public static final FetchSourceContext DO_NOT_FETCH_SOURCE = new FetchSourceContext(false);
    private final boolean fetchSource;
    private final String[] includes;
    private final String[] excludes;
    private Function<Map<String, ?>, Map<String, Object>> filter;

    public FetchSourceContext(boolean fetchSource, String[] includes, String[] excludes) {
        this.fetchSource = fetchSource;
        this.includes = includes == null ? Strings.EMPTY_ARRAY : includes;
        this.excludes = excludes == null ? Strings.EMPTY_ARRAY : excludes;
    }

    public FetchSourceContext(boolean fetchSource) {
        this(fetchSource, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    }

    public FetchSourceContext(StreamInput in) throws IOException {
        this.fetchSource = in.readBoolean();
        this.includes = in.readStringArray();
        this.excludes = in.readStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.fetchSource);
        out.writeStringArray(this.includes);
        out.writeStringArray(this.excludes);
    }

    public boolean fetchSource() {
        return this.fetchSource;
    }

    public String[] includes() {
        return this.includes;
    }

    public String[] excludes() {
        return this.excludes;
    }

    public static FetchSourceContext parseFromRestRequest(RestRequest request) {
        String sExcludes;
        String sIncludes;
        Boolean fetchSource = null;
        String[] sourceExcludes = null;
        String[] sourceIncludes = null;
        String source = request.param("_source");
        if (source != null) {
            if (Booleans.isTrue((String)source)) {
                fetchSource = true;
            } else if (Booleans.isFalse((String)source)) {
                fetchSource = false;
            } else {
                sourceIncludes = Strings.splitStringByCommaToArray((String)source);
            }
        }
        if ((sIncludes = request.param("_source_includes")) != null) {
            sourceIncludes = Strings.splitStringByCommaToArray((String)sIncludes);
        }
        if ((sExcludes = request.param("_source_excludes")) != null) {
            sourceExcludes = Strings.splitStringByCommaToArray((String)sExcludes);
        }
        if (fetchSource != null || sourceIncludes != null || sourceExcludes != null) {
            return new FetchSourceContext(fetchSource == null ? true : fetchSource, sourceIncludes, sourceExcludes);
        }
        return null;
    }

    public static FetchSourceContext fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        boolean fetchSource = true;
        String[] includes = Strings.EMPTY_ARRAY;
        String[] excludes = Strings.EMPTY_ARRAY;
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            fetchSource = parser.booleanValue();
        } else if (token == XContentParser.Token.VALUE_STRING) {
            includes = new String[]{parser.text()};
        } else if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<String> list = new ArrayList<String>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                list.add(parser.text());
            }
            includes = list.toArray(new String[list.size()]);
        } else if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (INCLUDES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        ArrayList<String> includesList = new ArrayList<String>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                includesList.add(parser.text());
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", new Object[]{parser.getTokenLocation()});
                        }
                        includes = includesList.toArray(new String[includesList.size()]);
                        continue;
                    }
                    if (EXCLUDES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        ArrayList<String> excludesList = new ArrayList<String>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                excludesList.add(parser.text());
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", new Object[]{parser.getTokenLocation()});
                        }
                        excludes = excludesList.toArray(new String[excludesList.size()]);
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", new Object[]{parser.getTokenLocation()});
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if (INCLUDES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        includes = new String[]{parser.text()};
                        continue;
                    }
                    if (EXCLUDES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        excludes = new String[]{parser.text()};
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", new Object[]{parser.getTokenLocation()});
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", new Object[]{parser.getTokenLocation()});
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "Expected one of [" + String.valueOf(XContentParser.Token.VALUE_BOOLEAN) + ", " + String.valueOf(XContentParser.Token.START_OBJECT) + "] but found [" + String.valueOf(token) + "]", new Object[]{parser.getTokenLocation()});
        }
        return new FetchSourceContext(fetchSource, includes, excludes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fetchSource) {
            builder.startObject();
            builder.array(INCLUDES_FIELD.getPreferredName(), this.includes);
            builder.array(EXCLUDES_FIELD.getPreferredName(), this.excludes);
            builder.endObject();
        } else {
            builder.value(false);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchSourceContext that = (FetchSourceContext)o;
        if (this.fetchSource != that.fetchSource) {
            return false;
        }
        if (!Arrays.equals(this.excludes, that.excludes)) {
            return false;
        }
        return Arrays.equals(this.includes, that.includes);
    }

    public int hashCode() {
        int result = this.fetchSource ? 1 : 0;
        result = 31 * result + (this.includes != null ? Arrays.hashCode(this.includes) : 0);
        result = 31 * result + (this.excludes != null ? Arrays.hashCode(this.excludes) : 0);
        return result;
    }

    public Function<Map<String, ?>, Map<String, Object>> getFilter() {
        if (this.filter == null) {
            this.filter = XContentMapValues.filter(this.includes, this.excludes);
        }
        return this.filter;
    }
}

