/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.model.Entity;

public class EntityTaskProfile
implements ToXContentObject,
Writeable {
    public static final String RCF_TOTAL_UPDATES_FIELD = "rcf_total_updates";
    public static final String THRESHOLD_MODEL_TRAINED_FIELD = "threshold_model_trained";
    public static final String THRESHOLD_MODEL_TRAINING_DATA_SIZE_FIELD = "threshold_model_training_data_size";
    public static final String MODEL_SIZE_IN_BYTES = "model_size_in_bytes";
    public static final String NODE_ID_FIELD = "node_id";
    public static final String ENTITY_FIELD = "entity";
    public static final String TASK_ID_FIELD = "task_id";
    public static final String TASK_TYPE_FIELD = "task_type";
    private Long rcfTotalUpdates;
    private Boolean thresholdModelTrained;
    private Integer thresholdModelTrainingDataSize;
    private Long modelSizeInBytes;
    private String nodeId;
    private Entity entity;
    private String taskId;
    private String taskType;

    public EntityTaskProfile(Long rcfTotalUpdates, Boolean thresholdModelTrained, Integer thresholdModelTrainingDataSize, Long modelSizeInBytes, String nodeId, Entity entity, String taskId, String adTaskType) {
        this.rcfTotalUpdates = rcfTotalUpdates;
        this.thresholdModelTrained = thresholdModelTrained;
        this.thresholdModelTrainingDataSize = thresholdModelTrainingDataSize;
        this.modelSizeInBytes = modelSizeInBytes;
        this.nodeId = nodeId;
        this.entity = entity;
        this.taskId = taskId;
        this.taskType = adTaskType;
    }

    public static EntityTaskProfile parse(XContentParser parser) throws IOException {
        Long rcfTotalUpdates = null;
        Boolean thresholdModelTrained = null;
        Integer thresholdModelTrainingDataSize = null;
        Long modelSizeInBytes = null;
        String nodeId = null;
        Entity entity = null;
        String taskId = null;
        String taskType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block20: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "rcf_total_updates": {
                    rcfTotalUpdates = parser.longValue();
                    continue block20;
                }
                case "threshold_model_trained": {
                    thresholdModelTrained = parser.booleanValue();
                    continue block20;
                }
                case "threshold_model_training_data_size": {
                    thresholdModelTrainingDataSize = parser.intValue();
                    continue block20;
                }
                case "model_size_in_bytes": {
                    modelSizeInBytes = parser.longValue();
                    continue block20;
                }
                case "node_id": {
                    nodeId = parser.text();
                    continue block20;
                }
                case "entity": {
                    entity = Entity.parse(parser);
                    continue block20;
                }
                case "task_id": {
                    taskId = parser.text();
                    continue block20;
                }
                case "task_type": {
                    taskType = parser.text();
                    continue block20;
                }
            }
            parser.skipChildren();
        }
        return new EntityTaskProfile(rcfTotalUpdates, thresholdModelTrained, thresholdModelTrainingDataSize, modelSizeInBytes, nodeId, entity, taskId, taskType);
    }

    public EntityTaskProfile(StreamInput input) throws IOException {
        this.rcfTotalUpdates = input.readOptionalLong();
        this.thresholdModelTrained = input.readOptionalBoolean();
        this.thresholdModelTrainingDataSize = input.readOptionalInt();
        this.modelSizeInBytes = input.readOptionalLong();
        this.nodeId = input.readOptionalString();
        this.entity = input.readBoolean() ? new Entity(input) : null;
        this.taskId = input.readOptionalString();
        this.taskType = input.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalLong(this.rcfTotalUpdates);
        out.writeOptionalBoolean(this.thresholdModelTrained);
        out.writeOptionalInt(this.thresholdModelTrainingDataSize);
        out.writeOptionalLong(this.modelSizeInBytes);
        out.writeOptionalString(this.nodeId);
        if (this.entity != null) {
            out.writeBoolean(true);
            this.entity.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.taskType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.rcfTotalUpdates != null) {
            xContentBuilder.field(RCF_TOTAL_UPDATES_FIELD, this.rcfTotalUpdates);
        }
        if (this.thresholdModelTrained != null) {
            xContentBuilder.field(THRESHOLD_MODEL_TRAINED_FIELD, this.thresholdModelTrained);
        }
        if (this.thresholdModelTrainingDataSize != null) {
            xContentBuilder.field(THRESHOLD_MODEL_TRAINING_DATA_SIZE_FIELD, this.thresholdModelTrainingDataSize);
        }
        if (this.modelSizeInBytes != null) {
            xContentBuilder.field(MODEL_SIZE_IN_BYTES, this.modelSizeInBytes);
        }
        if (this.nodeId != null) {
            xContentBuilder.field(NODE_ID_FIELD, this.nodeId);
        }
        if (this.entity != null) {
            xContentBuilder.field(ENTITY_FIELD, (ToXContent)this.entity);
        }
        if (this.taskId != null) {
            xContentBuilder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.taskType != null) {
            xContentBuilder.field(TASK_TYPE_FIELD, this.taskType);
        }
        return xContentBuilder.endObject();
    }

    public Long getRcfTotalUpdates() {
        return this.rcfTotalUpdates;
    }

    public void setRcfTotalUpdates(Long rcfTotalUpdates) {
        this.rcfTotalUpdates = rcfTotalUpdates;
    }

    public Boolean getThresholdModelTrained() {
        return this.thresholdModelTrained;
    }

    public void setThresholdModelTrained(Boolean thresholdModelTrained) {
        this.thresholdModelTrained = thresholdModelTrained;
    }

    public Integer getThresholdModelTrainingDataSize() {
        return this.thresholdModelTrainingDataSize;
    }

    public void setThresholdModelTrainingDataSize(Integer thresholdModelTrainingDataSize) {
        this.thresholdModelTrainingDataSize = thresholdModelTrainingDataSize;
    }

    public Long getModelSizeInBytes() {
        return this.modelSizeInBytes;
    }

    public void setModelSizeInBytes(Long modelSizeInBytes) {
        this.modelSizeInBytes = modelSizeInBytes;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getAdTaskType() {
        return this.taskType;
    }

    public void setAdTaskType(String adTaskType) {
        this.taskType = adTaskType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTaskProfile that = (EntityTaskProfile)o;
        return Objects.equals(this.rcfTotalUpdates, that.rcfTotalUpdates) && Objects.equals(this.thresholdModelTrained, that.thresholdModelTrained) && Objects.equals(this.thresholdModelTrainingDataSize, that.thresholdModelTrainingDataSize) && Objects.equals(this.modelSizeInBytes, that.modelSizeInBytes) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.taskType, that.taskType) && Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hash(this.rcfTotalUpdates, this.thresholdModelTrained, this.thresholdModelTrainingDataSize, this.modelSizeInBytes, this.nodeId, this.entity, this.taskId, this.taskType);
    }
}

