/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import java.io.IOException;
import java.time.Clock;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.rest.handler.AggregationPrep;
import org.opensearch.timeseries.util.SecurityClientUtil;

public class IntervalCalculation {
    private final Logger logger = LogManager.getLogger(IntervalCalculation.class);
    private final AggregationPrep aggregationPrep;
    private final Client client;
    private final SecurityClientUtil clientUtil;
    private final User user;
    private final AnalysisType context;
    private final Clock clock;
    private final Map<String, Object> topEntity;
    private final long endMillis;

    public IntervalCalculation(Config config, TimeValue requestTimeout, Client client, SecurityClientUtil clientUtil, User user, AnalysisType context, Clock clock, SearchFeatureDao searchFeatureDao, long latestTime, Map<String, Object> topEntity) {
        this.aggregationPrep = new AggregationPrep(searchFeatureDao, requestTimeout, config);
        this.client = client;
        this.clientUtil = clientUtil;
        this.user = user;
        this.context = context;
        this.clock = clock;
        this.topEntity = topEntity;
        this.endMillis = latestTime;
    }

    public void findInterval(ActionListener<IntervalTimeConfiguration> listener) {
        ActionListener minimumIntervalListener = ActionListener.wrap(minInterval -> {
            if (minInterval == null) {
                listener.onResponse(null);
            } else {
                this.getBucketAggregates((IntervalTimeConfiguration)minInterval, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        LongBounds longBounds = this.aggregationPrep.getTimeRangeBounds(new IntervalTimeConfiguration(1L, ChronoUnit.MINUTES), this.endMillis);
        this.findMinimumInterval(longBounds, (ActionListener<IntervalTimeConfiguration>)minimumIntervalListener);
    }

    private void getBucketAggregates(IntervalTimeConfiguration minimumInterval, ActionListener<IntervalTimeConfiguration> listener) throws IOException {
        try {
            LongBounds timeStampBounds = this.aggregationPrep.getTimeRangeBounds(minimumInterval, this.endMillis);
            SearchRequest searchRequest = this.aggregationPrep.createSearchRequest(minimumInterval, timeStampBounds, this.topEntity);
            ActionListener intervalListener = ActionListener.wrap(interval -> listener.onResponse(interval), exception -> {
                listener.onFailure(exception);
                this.logger.error("Failed to get interval recommendation", (Throwable)exception);
            });
            IntervalRecommendationListener searchResponseListener = new IntervalRecommendationListener((ActionListener<IntervalTimeConfiguration>)intervalListener, searchRequest.source(), minimumInterval, this.clock.millis() + 10000L, timeStampBounds);
            this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
        }
        catch (ValidationException ex) {
            listener.onFailure((Exception)ex);
        }
    }

    private int increaseAndGetNewInterval(IntervalTimeConfiguration oldInterval) {
        return (int)Math.ceil((double)IntervalTimeConfiguration.getIntervalInMinute(oldInterval) * 1.2);
    }

    private void findMinimumInterval(LongBounds timeStampBounds, ActionListener<IntervalTimeConfiguration> listener) {
        try {
            SearchRequest searchRequest = this.aggregationPrep.createSearchRequest(new IntervalTimeConfiguration(1L, ChronoUnit.MINUTES), timeStampBounds, this.topEntity);
            ActionListener searchResponseListener = ActionListener.wrap(response -> {
                List<Long> timestamps = this.aggregationPrep.getTimestamps((SearchResponse)response);
                if (timestamps.isEmpty()) {
                    this.logger.warn("empty data, return one minute by default");
                    listener.onResponse((Object)new IntervalTimeConfiguration(1L, ChronoUnit.MINUTES));
                    return;
                }
                double medianDifference = IntervalCalculation.calculateMedianDifference(timestamps);
                long minimumMinutes = IntervalCalculation.millisecondsToCeilMinutes(Double.valueOf(medianDifference).longValue());
                if (minimumMinutes > 60L) {
                    this.logger.warn("The minimum interval is too large: {}", (Object)minimumMinutes);
                    listener.onResponse(null);
                    return;
                }
                listener.onResponse((Object)new IntervalTimeConfiguration(minimumMinutes, ChronoUnit.MINUTES));
            }, arg_0 -> listener.onFailure(arg_0));
            this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static double calculateMedianDifference(List<Long> timestamps) {
        ArrayList<Long> differences = new ArrayList<Long>();
        for (int i = 1; i < timestamps.size(); ++i) {
            differences.add(timestamps.get(i) - timestamps.get(i - 1));
        }
        Collections.sort(differences);
        int middle = differences.size() / 2;
        if (differences.size() % 2 == 0) {
            return (double)((Long)differences.get(middle - 1) + (Long)differences.get(middle)) / 2.0;
        }
        return ((Long)differences.get(middle)).longValue();
    }

    private static long millisecondsToCeilMinutes(long milliseconds) {
        return (milliseconds + 59999L) / 60000L;
    }

    class IntervalRecommendationListener
    implements ActionListener<SearchResponse> {
        private final ActionListener<IntervalTimeConfiguration> intervalListener;
        IntervalTimeConfiguration currentIntervalToTry;
        private final long expirationEpochMs;
        private LongBounds currentTimeStampBounds;

        IntervalRecommendationListener(ActionListener<IntervalTimeConfiguration> intervalListener, SearchSourceBuilder searchSourceBuilder, IntervalTimeConfiguration currentIntervalToTry, long expirationEpochMs, LongBounds timeStampBounds) {
            this.intervalListener = intervalListener;
            this.currentIntervalToTry = currentIntervalToTry;
            this.expirationEpochMs = expirationEpochMs;
            this.currentTimeStampBounds = timeStampBounds;
        }

        public void onResponse(SearchResponse response) {
            try {
                int newIntervalMinute = IntervalCalculation.this.increaseAndGetNewInterval(this.currentIntervalToTry);
                double fullBucketRate = IntervalCalculation.this.aggregationPrep.getBucketHitRate(response, this.currentIntervalToTry, IntervalCalculation.this.endMillis);
                if (fullBucketRate > 0.75) {
                    this.intervalListener.onResponse((Object)this.currentIntervalToTry);
                } else if (this.expirationEpochMs < IntervalCalculation.this.clock.millis()) {
                    this.intervalListener.onFailure((Exception)new ValidationException(CommonMessages.TIMEOUT_ON_INTERVAL_REC, ValidationIssueType.TIMEOUT, ValidationAspect.MODEL));
                    IntervalCalculation.this.logger.info(CommonMessages.TIMEOUT_ON_INTERVAL_REC);
                } else if ((long)newIntervalMinute < 60L) {
                    this.searchWithDifferentInterval(newIntervalMinute);
                } else {
                    this.intervalListener.onResponse(null);
                }
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        private void searchWithDifferentInterval(int newIntervalMinuteValue) {
            this.currentIntervalToTry = new IntervalTimeConfiguration(newIntervalMinuteValue, ChronoUnit.MINUTES);
            this.currentTimeStampBounds = IntervalCalculation.this.aggregationPrep.getTimeRangeBounds(this.currentIntervalToTry, IntervalCalculation.this.endMillis);
            IntervalCalculation.this.clientUtil.asyncRequestWithInjectedSecurity(IntervalCalculation.this.aggregationPrep.createSearchRequest(this.currentIntervalToTry, this.currentTimeStampBounds, IntervalCalculation.this.topEntity), (arg_0, arg_1) -> ((Client)IntervalCalculation.this.client).search(arg_0, arg_1), IntervalCalculation.this.user, IntervalCalculation.this.client, IntervalCalculation.this.context, this);
        }

        public void onFailure(Exception e) {
            IntervalCalculation.this.logger.error("Failed to recommend new interval", (Throwable)e);
            this.intervalListener.onFailure((Exception)new ValidationException(CommonMessages.MODEL_VALIDATION_FAILED_UNEXPECTEDLY, ValidationIssueType.AGGREGATION, ValidationAspect.MODEL));
        }
    }
}

