/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.sgd.fm;

import java.util.Arrays;
import org.tribuo.Example;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.ONNXExportable;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.common.sgd.AbstractFMModel;
import org.tribuo.common.sgd.AbstractSGDModel;
import org.tribuo.common.sgd.FMParameters;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.regression.ImmutableRegressionInfo;
import org.tribuo.regression.Regressor;
import org.tribuo.util.onnx.ONNXInitializer;
import org.tribuo.util.onnx.ONNXNode;
import org.tribuo.util.onnx.ONNXOperators;
import org.tribuo.util.onnx.ONNXRef;

public class FMRegressionModel
extends AbstractFMModel<Regressor>
implements ONNXExportable {
    private static final long serialVersionUID = 3L;
    private final String[] dimensionNames;
    private final boolean standardise;

    FMRegressionModel(String name, String[] dimensionNames, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Regressor> outputIDInfo, FMParameters parameters, boolean standardise) {
        super(name, provenance, featureIDMap, outputIDInfo, parameters, false);
        this.dimensionNames = dimensionNames;
        this.standardise = standardise;
    }

    public Prediction<Regressor> predict(Example<Regressor> example) {
        AbstractSGDModel.PredAndActive predTuple = this.predictSingle(example);
        double[] predictions = predTuple.prediction.toArray();
        if (this.standardise) {
            predictions = this.unstandardisePredictions(predictions);
        }
        return new Prediction((Output)new Regressor(this.dimensionNames, predictions), predTuple.numActiveFeatures, example);
    }

    private double[] unstandardisePredictions(double[] predictions) {
        ImmutableRegressionInfo info = (ImmutableRegressionInfo)this.outputIDInfo;
        for (int i = 0; i < predictions.length; ++i) {
            double mean = info.getMean(i);
            double variance = info.getVariance(i);
            predictions[i] = predictions[i] * variance + mean;
        }
        return predictions;
    }

    protected FMRegressionModel copy(String newName, ModelProvenance newProvenance) {
        return new FMRegressionModel(newName, Arrays.copyOf(this.dimensionNames, this.dimensionNames.length), newProvenance, this.featureIDMap, (ImmutableOutputInfo<Regressor>)this.outputIDInfo, (FMParameters)this.modelParameters.copy(), this.standardise);
    }

    protected String getDimensionName(int index) {
        return this.dimensionNames[index];
    }

    protected String onnxModelName() {
        return "FMRegressionModel";
    }

    protected ONNXNode onnxOutput(ONNXNode fmOutput) {
        if (this.standardise) {
            ImmutableRegressionInfo info = (ImmutableRegressionInfo)this.outputIDInfo;
            double[] means = new double[this.outputIDInfo.size()];
            double[] variances = new double[this.outputIDInfo.size()];
            for (int i = 0; i < means.length; ++i) {
                means[i] = info.getMean(i);
                variances[i] = info.getVariance(i);
            }
            ONNXInitializer outputMean = fmOutput.onnxContext().array("y_mean", means);
            ONNXInitializer outputVariance = fmOutput.onnxContext().array("y_var", variances);
            return fmOutput.apply(ONNXOperators.MUL, (ONNXRef)outputVariance).apply(ONNXOperators.ADD, (ONNXRef)outputMean);
        }
        return fmOutput;
    }
}

